/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.transport.socket.LRUPool;
import org.jboss.remoting.transport.socket.ServerThread;
import org.jboss.remoting.transport.socket.SocketServerInvokerMBean;
import org.jboss.util.propertyeditor.PropertyEditors;

public class SocketServerInvoker
extends ServerInvoker
implements Runnable,
SocketServerInvokerMBean {
    private InetAddress addr;
    private int port;
    static int clientCount = 0;
    private Properties props = new Properties();
    private static int BACKLOG_DEFAULT = 200;
    private static int MAX_POOL_SIZE_DEFAULT = 300;
    public static final String SERVER_SOCKET_CLASS_FLAG = "serverSocketClass";
    private String serverSocketClass = (class$org$jboss$remoting$transport$socket$ServerSocketWrapper == null ? (class$org$jboss$remoting$transport$socket$ServerSocketWrapper = SocketServerInvoker.class$("org.jboss.remoting.transport.socket.ServerSocketWrapper")) : class$org$jboss$remoting$transport$socket$ServerSocketWrapper).getName();
    protected ServerSocket serverSocket = null;
    protected boolean running = false;
    protected int backlog = BACKLOG_DEFAULT;
    protected Thread[] acceptThreads;
    protected int numAcceptThreads = 1;
    protected int maxPoolSize = MAX_POOL_SIZE_DEFAULT;
    protected LRUPool clientpool;
    protected LinkedList threadpool;
    protected int timeout = 60000;
    protected boolean trace = false;
    static /* synthetic */ Class class$org$jboss$remoting$transport$socket$ServerSocketWrapper;

    public SocketServerInvoker(InvokerLocator locator) {
        super(locator);
    }

    public SocketServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    public InetAddress getAddress() {
        return this.addr;
    }

    public int getPort() {
        return this.port;
    }

    public Properties getProperties() {
        return this.props;
    }

    protected void setup() throws Exception {
        this.props.putAll((Map<?, ?>)this.getConfiguration());
        PropertyEditors.mapJavaBeanProperties(this, this.props, false);
        super.setup();
        String ssclass = this.props.getProperty(SERVER_SOCKET_CLASS_FLAG);
        if (ssclass != null) {
            this.serverSocketClass = ssclass;
        }
    }

    protected void finalize() throws Throwable {
        this.stop();
        super.finalize();
    }

    public synchronized void start() throws IOException {
        this.trace = this.log.isTraceEnabled();
        if (!this.running) {
            InetAddress bindAddress = InetAddress.getByName(this.getServerBindAddress());
            if (this.maxPoolSize <= 0) {
                this.maxPoolSize = MAX_POOL_SIZE_DEFAULT;
            }
            try {
                this.serverSocket = this.createServerSocket(this.getServerBindPort(), this.backlog, bindAddress);
            }
            catch (IOException e) {
                this.log.error("Error starting ServerSocket.  Bind port: " + this.getServerBindPort() + ", bind address: " + bindAddress);
                throw e;
            }
            this.clientpool = new LRUPool(2, this.maxPoolSize);
            this.clientpool.create();
            this.threadpool = new LinkedList();
            this.acceptThreads = new Thread[this.numAcceptThreads];
            for (int i = 0; i < this.numAcceptThreads; ++i) {
                if (this.trace) {
                    this.log.trace("Creating another AcceptThread");
                }
                String name = "SocketServerInvoker#" + i + "-" + this.getServerBindPort();
                this.acceptThreads[i] = new Thread((Runnable)this, name);
                if (!this.trace) continue;
                this.log.trace("Thread accepted");
            }
        }
        try {
            super.start();
        }
        catch (IOException e) {
            this.log.error("Error starting SocketServerInvoker.", e);
            this.cleanup();
        }
        if (!this.running) {
            this.running = true;
            for (int i = 0; i < this.numAcceptThreads; ++i) {
                this.acceptThreads[i].start();
            }
        }
    }

    protected ServerSocket createServerSocket(int serverBindPort, int backlog, InetAddress bindAddress) throws IOException {
        ServerSocket svrSocket = new ServerSocket(serverBindPort, backlog, bindAddress);
        this.log.debug("Created server socket: " + svrSocket);
        return svrSocket;
    }

    public void destroy() {
        this.clientpool.destroy();
    }

    public synchronized void stop() {
        if (this.running) {
            this.cleanup();
        }
        super.stop();
    }

    private void cleanup() {
        this.running = false;
        this.maxPoolSize = 0;
        if (this.acceptThreads != null) {
            for (int i = 0; i < this.acceptThreads.length; ++i) {
                try {
                    this.acceptThreads[i].interrupt();
                    continue;
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
        }
        Set svrThreads = this.clientpool.getContents();
        Iterator itr = svrThreads.iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            ServerThread st = (ServerThread)o;
            st.shutdown();
        }
        this.clientpool.flush();
        this.clientpool.stop();
        for (int i = 0; i < this.threadpool.size(); ++i) {
            ServerThread thread = (ServerThread)this.threadpool.removeFirst();
            thread.shutdown();
        }
        try {
            this.serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getSocketTimeout() {
        return this.timeout;
    }

    public void setSocketTimeout(int time) {
        this.timeout = time;
    }

    public int getCurrentThreadPoolSize() {
        return this.threadpool.size();
    }

    public int getCurrentClientPoolSize() {
        return this.clientpool.size();
    }

    public int getNumAcceptThreads() {
        return this.numAcceptThreads;
    }

    public void setNumAcceptThreads(int size) {
        this.numAcceptThreads = size;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog < 0 ? BACKLOG_DEFAULT : backlog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.trace) {
            this.log.trace("Started execution of method run");
        }
        while (this.running) {
            try {
                Object object;
                if (this.trace) {
                    this.log.trace("Socket is going to be accepted");
                }
                Socket socket = this.serverSocket.accept();
                if (this.trace) {
                    this.log.trace("Accepted: " + socket);
                }
                ServerThread thread = null;
                boolean newThread = false;
                while (thread == null) {
                    object = this.threadpool;
                    synchronized (object) {
                        if (this.threadpool.size() > 0) {
                            thread = (ServerThread)this.threadpool.removeFirst();
                        }
                    }
                    if (thread != null) continue;
                    object = this.clientpool;
                    synchronized (object) {
                        if (this.clientpool.size() < this.maxPoolSize) {
                            thread = new ServerThread(socket, this, this.clientpool, this.threadpool, this.timeout, this.serverSocketClass);
                            newThread = true;
                        }
                        if (thread == null) {
                            this.clientpool.evict();
                            if (this.trace) {
                                this.log.trace("Waiting for a thread...");
                            }
                            this.clientpool.wait();
                            if (this.trace) {
                                this.log.trace("Notified of available thread");
                            }
                        }
                    }
                }
                object = this.clientpool;
                synchronized (object) {
                    this.clientpool.insert(thread, thread);
                }
                if (newThread) {
                    if (this.trace) {
                        this.log.trace("Created a new thread, t=" + thread);
                    }
                    thread.start();
                    continue;
                }
                if (this.trace) {
                    this.log.trace("Reusing thread t=" + thread);
                }
                thread.wakeup(socket, this.timeout);
            }
            catch (Throwable ex) {
                if (!this.running) continue;
                this.log.error("Failed to accept socket connection", ex);
            }
        }
    }

    public boolean isTransportBiDirectional() {
        return true;
    }

    protected String getDefaultDataType() {
        return "serializable";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

