/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.local;

import org.jboss.remoting.AbstractInvoker;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.transport.ClientInvoker;

public class LocalClientInvoker
extends AbstractInvoker
implements ClientInvoker {
    private ServerInvoker serverInvoker;

    public LocalClientInvoker(InvokerLocator locator) {
        super(locator);
    }

    public Object invoke(InvocationRequest invocation) throws Throwable {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Using local client invoker for invocation.");
        }
        Object ret = null;
        if (this.serverInvoker == null) {
            throw new ConnectionFailedException("Error invoking on server because no local server to call upon.");
        }
        ret = this.serverInvoker.invoke(invocation);
        return ret;
    }

    public boolean isConnected() {
        return this.serverInvoker != null;
    }

    public void connect() throws ConnectionFailedException {
    }

    public void disconnect() {
        InvokerRegistry.destroyClientInvoker(this.getLocator());
        this.serverInvoker = null;
    }

    public void setMarshaller(Marshaller marshaller) {
    }

    public Marshaller getMarshaller() {
        return null;
    }

    public void setUnMarshaller(UnMarshaller unmarshaller) {
    }

    public UnMarshaller getUnMarshaller() {
        return null;
    }

    public void setServerInvoker(ServerInvoker svrInvoker) {
        this.serverInvoker = svrInvoker;
    }
}

