/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.tc5.session;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.jboss.logging.Logger;
import org.jboss.metadata.WebMetaData;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.web.tomcat.statistics.ReplicationStatistics;
import org.jboss.web.tomcat.tc5.session.AbstractJBossManager;
import org.jboss.web.tomcat.tc5.session.ClusteredSession;
import org.jboss.web.tomcat.tc5.session.ClusteredSessionValve;
import org.jboss.web.tomcat.tc5.session.ClusteringNotSupportedException;
import org.jboss.web.tomcat.tc5.session.JBossManagerMBean;
import org.jboss.web.tomcat.tc5.session.SessionIDGenerator;

public abstract class JBossManager
implements AbstractJBossManager,
Lifecycle,
JBossManagerMBean,
PropertyChangeListener {
    private static final String info_ = "JBossManager/1.0";
    protected ReplicationStatistics stats_ = new ReplicationStatistics();
    protected int invalidateSessionPolicy_ = 2;
    protected int replicationGranularity_ = 0;
    protected LifecycleSupport lifecycle_ = new LifecycleSupport((Lifecycle)this);
    protected boolean started_ = false;
    protected ObjectName objectName_;
    protected Logger log_ = Logger.getLogger((String)this.getClass().getName());
    protected Container container_;
    protected boolean distributable_;
    protected int maxInactiveInterval_ = 60;
    protected int sessionIdLength_ = 16;
    protected int maxActive_ = -1;
    protected int createdCounter_ = 0;
    protected int rejectedCounter_ = 0;
    protected int activeCounter_ = 0;
    protected int expiredCounter_ = 0;
    protected long timeSinceLastReset_ = 0L;
    protected Map sessions_;
    protected boolean useLocalCache_ = false;
    protected PropertyChangeSupport support_ = new PropertyChangeSupport(this);
    protected SessionIDGenerator sessionIDGenerator_ = SessionIDGenerator.getInstance();

    public JBossManager() {
        this.sessions_ = Collections.synchronizedMap(new HashMap());
    }

    public void init(String name, WebMetaData webMetaData, boolean useJK, boolean useLocalCache) throws ClusteringNotSupportedException {
        this.replicationGranularity_ = webMetaData.getReplicationGranularity();
        this.invalidateSessionPolicy_ = webMetaData.getInvalidateSessionPolicy();
        this.useLocalCache_ = useLocalCache;
        this.log_.info((Object)("init(): replicationGranularity_ is " + this.replicationGranularity_ + " and invaldateSessionPolicy is " + this.invalidateSessionPolicy_));
        try {
            this.objectName_ = new ObjectName("jboss.web:service=ClusterManager,WebModule=" + name);
        }
        catch (Throwable e) {
            this.log_.error((Object)"Could not create ObjectName", e);
            throw new ClusteringNotSupportedException(e.toString());
        }
    }

    public int getInvalidateSessionPolicy() {
        return this.invalidateSessionPolicy_;
    }

    public Engine getEngine() {
        Engine e = null;
        for (Container c = this.getContainer(); e == null && c != null; c = c.getParent()) {
            if (c == null || !(c instanceof Engine)) continue;
            e = (Engine)c;
        }
        return e;
    }

    public String getJvmRoute() {
        Engine e = this.getEngine();
        return e == null ? null : e.getJvmRoute();
    }

    protected String getNextId() {
        return this.sessionIDGenerator_.getSessionId();
    }

    public boolean isUseLocalCache() {
        return this.useLocalCache_;
    }

    public void setSessionCookie(String sessionId) {
        HttpServletResponse response = (HttpServletResponse)ClusteredSessionValve.responseThreadLocal.get();
        this.setNewSessionCookie(sessionId, response);
    }

    public void setNewSessionCookie(String sessionId, HttpServletResponse response) {
        if (response != null) {
            Context context = (Context)this.container_;
            Connector connector = ((Response)response).getConnector();
            if (context.getCookies()) {
                Cookie newCookie = new Cookie("JSESSIONID", sessionId);
                if (this.log_.isDebugEnabled()) {
                    this.log_.debug((Object)("Setting cookie with session id:" + sessionId + " & name:" + "JSESSIONID"));
                }
                String contextPath = null;
                if (!connector.getEmptySessionPath() && context != null) {
                    contextPath = context.getEncodedPath();
                }
                if (contextPath != null && contextPath.length() > 0) {
                    newCookie.setPath(contextPath);
                } else {
                    newCookie.setPath("/");
                }
                if (connector.getSecure()) {
                    newCookie.setSecure(true);
                }
                response.addCookie(newCookie);
            }
        }
    }

    public ReplicationStatistics getReplicationStatistics() {
        return this.stats_;
    }

    public void resetStats() {
        this.stats_.resetStats();
        this.timeSinceLastReset_ = System.currentTimeMillis();
        this.activeCounter_ = 0;
        this.rejectedCounter_ = 0;
        this.createdCounter_ = 0;
        this.expiredCounter_ = 0;
    }

    public long timeInSecondsSinceLastReset() {
        return (System.currentTimeMillis() - this.timeSinceLastReset_) / 1000L;
    }

    public long getActiveSessionCount() {
        return this.getActiveSessions();
    }

    public long getCreatedSessionCount() {
        return this.createdCounter_;
    }

    public long getExpiredSessionCount() {
        return this.expiredCounter_;
    }

    public long getRejectedSessionCount() {
        return this.rejectedCounter_;
    }

    public int getSessionMaxAliveTime() {
        return 0;
    }

    public void setSessionMaxAliveTime(int sessionMaxAliveTime) {
    }

    public int getSessionAverageAliveTime() {
        return 0;
    }

    public void setSessionAverageAliveTime(int sessionAverageAliveTime) {
    }

    public String reportReplicationStatistics() {
        StringBuffer tmp = new StringBuffer();
        HashMap copy = new HashMap(this.stats_.getStats());
        Iterator iter = copy.entrySet().iterator();
        tmp.append("<table><tr>");
        tmp.append("<th>sessionID</th>");
        tmp.append("<th>replicationCount</th>");
        tmp.append("<th>minPassivationTime</th>");
        tmp.append("<th>maxPassivationTime</th>");
        tmp.append("<th>totalPassivationTime</th>");
        tmp.append("<th>minReplicationTime</th>");
        tmp.append("<th>maxReplicationTime</th>");
        tmp.append("<th>totalReplicationlTime</th>");
        tmp.append("<th>loadCount</th>");
        tmp.append("<th>minLoadTime</th>");
        tmp.append("<th>maxLoadTime</th>");
        tmp.append("<th>totalLoadlTime</th>");
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ReplicationStatistics.TimeStatistic stat = (ReplicationStatistics.TimeStatistic)entry.getValue();
            tmp.append("<tr><td>");
            tmp.append(entry.getKey());
            tmp.append("</td><td>");
            tmp.append(stat.replicationCount);
            tmp.append("</td><td>");
            tmp.append(stat.minPassivationTime);
            tmp.append("</td><td>");
            tmp.append(stat.maxPassivationTime);
            tmp.append("</td><td>");
            tmp.append(stat.totalPassivationTime);
            tmp.append("</td><td>");
            tmp.append(stat.minReplicationTime);
            tmp.append("</td><td>");
            tmp.append(stat.maxReplicationTime);
            tmp.append("</td><td>");
            tmp.append(stat.totalReplicationlTime);
            tmp.append("</td><td>");
            tmp.append(stat.loadCount);
            tmp.append("</td><td>");
            tmp.append(stat.minLoadTime);
            tmp.append("</td><td>");
            tmp.append(stat.maxLoadTime);
            tmp.append("</td><td>");
            tmp.append(stat.totalLoadlTime);
            tmp.append("</td></tr>");
        }
        tmp.append("</table>");
        copy.clear();
        return tmp.toString();
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle_.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle_.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle_.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        this.startManager();
    }

    public void stop() throws LifecycleException {
        this.resetStats();
        this.stopManager();
    }

    protected void startManager() throws LifecycleException {
        this.log_.info((Object)"Starting JBossManager");
        if (this.started_) {
            throw new LifecycleException("JBossManager alreadyStarted");
        }
        this.lifecycle_.fireLifecycleEvent("start", null);
        this.started_ = true;
        try {
            MBeanServer server = MBeanServerLocator.locateJBoss();
            server.registerMBean(this, this.objectName_);
        }
        catch (Exception e) {
            this.log_.error((Object)"Could not register ClusterManagerMBean to MBeanServer", (Throwable)e);
        }
    }

    protected void stopManager() throws LifecycleException {
        this.log_.info((Object)"Stopping JBossManager");
        if (!this.started_) {
            throw new LifecycleException("JBossManager notStarted");
        }
        this.lifecycle_.fireLifecycleEvent("stop", null);
        this.started_ = false;
        try {
            MBeanServer server = MBeanServerLocator.locateJBoss();
            server.unregisterMBean(this.objectName_);
        }
        catch (Exception e) {
            this.log_.error((Object)"Could not unregister ClusterManagerMBean from MBeanServer", (Throwable)e);
        }
    }

    public Container getContainer() {
        return this.container_;
    }

    public void setContainer(Container container) {
        if (this.container_ != null && this.container_ instanceof Context) {
            ((Context)this.container_).removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.container_ = container;
        if (this.container_ != null && this.container_ instanceof Context) {
            this.setMaxInactiveInterval(((Context)this.container_).getSessionTimeout() * 60);
            ((Context)this.container_).addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public boolean getDistributable() {
        return this.distributable_;
    }

    public void setDistributable(boolean distributable) {
        this.distributable_ = distributable;
    }

    public String getInfo() {
        return info_;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval_;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval_ = interval;
    }

    public int getSessionIdLength() {
        return this.sessionIdLength_;
    }

    public void setSessionIdLength(int idLength) {
        this.sessionIdLength_ = idLength;
    }

    public int getSessionCounter() {
        return this.createdCounter_;
    }

    public void setSessionCounter(int sessionCounter) {
        this.createdCounter_ = sessionCounter;
    }

    public int getMaxActive() {
        return this.maxActive_;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive_ = maxActive;
    }

    public int getExpiredSessions() {
        return this.expiredCounter_;
    }

    public void setExpiredSessions(int expiredSessions) {
        this.expiredCounter_ = expiredSessions;
    }

    public int getRejectedSessions() {
        return this.rejectedCounter_;
    }

    public void setRejectedSessions(int rejectedSessions) {
        this.rejectedCounter_ = rejectedSessions;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support_.addPropertyChangeListener(listener);
    }

    public abstract void removeLocal(Session var1);

    public abstract boolean storeSession(Session var1);

    public int getActiveSessions() {
        return this.activeCounter_;
    }

    public void load() throws ClassNotFoundException, IOException {
        throw new RuntimeException("JBossManager.load(): Method not implemented.");
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support_.removePropertyChangeListener(listener);
    }

    public void unload() throws IOException {
        throw new RuntimeException("JBossManager.load(): Method not implemented.");
    }

    public void backgroundProcess() {
        this.processExpires();
    }

    protected void processExpires() {
        Session[] sessions = this.findSessions();
        if (this.log_.isDebugEnabled()) {
            this.log_.debug((Object)"Looking for sessions that have expired ...");
        }
        for (int i = 0; i < sessions.length; ++i) {
            ClusteredSession session = (ClusteredSession)sessions[i];
            if (session.isValid()) continue;
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    public abstract ClusteredSession[] findLocalSessions();

    public abstract ClusteredSession findLocalSession(String var1);
}

