/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.tc5.session;

import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.web.tomcat.tc5.session.AbstractJBossManager;
import org.jboss.web.tomcat.tc5.session.ClusteredSession;
import org.jboss.web.tomcat.tc5.session.JBossCacheManager;
import org.jboss.web.tomcat.tc5.session.JBossCacheService;

class AttributeBasedClusteredSession
extends ClusteredSession
implements Serializable {
    static final long serialVersionUID = -5625209785550936713L;
    protected static final String info = "AttributeBasedClusteredSession/1.0";
    private transient boolean isSessionModifiedSinceLastSave_;
    private transient JBossCacheService proxy_;
    private transient Map attrModifiedMap_;
    private transient Map attrRemovedMap_;
    private static int REMOVE = 0;
    private static int MODIFY = 1;
    private transient Map attributes_;

    public AttributeBasedClusteredSession(AbstractJBossManager manager) {
        super(manager);
        this.initAfterLoad(manager);
    }

    public void initAfterLoad(AbstractJBossManager manager) {
        if (this.proxy_ == null) {
            this.setManager(manager);
            this.listeners = new ArrayList();
            this.notes = new HashMap();
            this.support = new PropertyChangeSupport(this);
            this.expiring = false;
            this.attributes_ = Collections.synchronizedMap(new HashMap());
            this.attrModifiedMap_ = new HashMap();
            this.attrRemovedMap_ = new HashMap();
            this.proxy_ = ((JBossCacheManager)manager).getCacheService();
            if (this.proxy_ == null) {
                throw new RuntimeException("SessionBasedClusteredSession: Cache service is null.");
            }
            this.activate();
        }
        this.isOutdated = false;
        this.populateAttributes();
    }

    protected void populateAttributes() {
        Map map = this.proxy_.getAttributes(this.id);
        if (map.size() != 0) {
            this.attributes_ = map;
        }
    }

    public void setCreationTime(long time) {
        super.setCreationTime(time);
        this.sessionIsDirty();
    }

    public void setPrincipal(Principal principal) {
        Principal oldPrincipal = this.principal;
        this.principal = principal;
        this.support.firePropertyChange("principal", oldPrincipal, this.principal);
        if (oldPrincipal != null && !((Object)oldPrincipal).equals(principal) || oldPrincipal == null && principal != null) {
            this.sessionIsDirty();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AttributeBasedClusteredSession[");
        sb.append(this.id);
        sb.append("]");
        return sb.toString();
    }

    public synchronized void processSessionRepl() {
        Object key;
        if (!this.isSessionDirty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"processSessionRepl(): session is not dirty. No need to replicate.");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("processSessionRepl(): session is dirty. Will increment version from: " + this.getVersion() + " and replicate."));
        }
        this.incrementVersion();
        this.proxy_.putSession(this.id, this);
        Set set = this.attrModifiedMap_.keySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            key = it.next();
            this.proxy_.putAttribute(this.id, (String)key, this.attrModifiedMap_.get(key));
        }
        set = this.attrRemovedMap_.keySet();
        it = set.iterator();
        while (it.hasNext()) {
            key = it.next();
            this.proxy_.removeAttribute(this.id, (String)key);
        }
        this.clearAttrChangedMap();
        this.isSessionModifiedSinceLastSave_ = false;
    }

    public void removeMyself() {
        this.proxy_.removeSession(this.id);
        if (this.attributes_ != null) {
            this.attributes_.clear();
        }
    }

    public void removeMyselfLocal() {
        this.proxy_.removeAttributeLocal(this.id);
        this.proxy_.removeSessionLocal(this.id);
        if (this.attributes_ != null) {
            this.attributes_.clear();
        }
    }

    public void access() {
        super.access();
        if (this.invalidationPolicy == 0) {
            this.sessionIsDirty();
        }
    }

    protected Object getJBossInternalAttribute(String name) {
        Object result = null;
        result = this.attributes_.get(name);
        if (result != null) {
            int invalidationPolicy = ((AbstractJBossManager)this.manager).getInvalidateSessionPolicy();
            if (invalidationPolicy == 1) {
                this.attributeChanged(name, result, MODIFY);
            } else if (!(invalidationPolicy != 2 || result instanceof String || result instanceof Integer || result instanceof Long || result instanceof Byte || result instanceof Short || result instanceof Float || result instanceof Double || result instanceof Character || result instanceof Boolean)) {
                this.attributeChanged(name, result, MODIFY);
            }
        }
        return result;
    }

    protected Object removeJBossInternalAttribute(String name) {
        Object result = this.attributes_.remove(name);
        this.attributeChanged(name, result, REMOVE);
        return result;
    }

    protected Map getJBossInternalAttributes() {
        return this.attributes_;
    }

    protected Set getJBossInternalKeys() {
        return this.attributes_.keySet();
    }

    protected String[] keys() {
        return this.getJBossInternalKeys().toArray(EMPTY_ARRAY);
    }

    protected Object setJBossInternalAttribute(String key, Object value) {
        Object old = this.attributes_.put(key, value);
        this.attributeChanged(key, value, MODIFY);
        return old;
    }

    protected void sessionIsDirty() {
        this.isSessionModifiedSinceLastSave_ = true;
    }

    public boolean isSessionDirty() {
        return this.isSessionModifiedSinceLastSave_;
    }

    protected synchronized void attributeChanged(Object key, Object value, int op) {
        if (op == MODIFY) {
            if (this.attrRemovedMap_.containsKey(key)) {
                this.attrRemovedMap_.remove(key);
            }
            this.attrModifiedMap_.put(key, value);
        } else if (op == REMOVE) {
            if (this.attrModifiedMap_.containsKey(key)) {
                this.attrModifiedMap_.remove(key);
            }
            this.attrRemovedMap_.put(key, value);
        }
        this.sessionIsDirty();
    }

    protected synchronized void clearAttrChangedMap() {
        this.attrRemovedMap_.clear();
        this.attrModifiedMap_.clear();
    }
}

