/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.common;

import java.io.IOException;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jk.core.JkHandler;

public class JkMX
extends JkHandler {
    MBeanServer mserver;
    private boolean enabled = false;
    private boolean log4jEnabled = true;
    private int httpport = -1;
    private String httphost = "localhost";
    private String authmode = "none";
    private String authuser = null;
    private String authpassword = null;
    private int jrmpport = -1;
    private String jrmphost = "localhost";
    private boolean useXSLTProcessor = true;
    ObjectName httpServerName = null;
    ObjectName jrmpServerName = null;
    private static Log log = LogFactory.getLog((Class)(class$org$apache$jk$common$JkMX == null ? (class$org$apache$jk$common$JkMX = JkMX.class$("org.apache.jk.common.JkMX")) : class$org$apache$jk$common$JkMX));
    static /* synthetic */ Class class$org$apache$jk$common$JkMX;

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setLog4jEnabled(boolean b) {
        this.log4jEnabled = b;
    }

    public boolean getLog4jEnabled() {
        return this.log4jEnabled;
    }

    public void setPort(int i) {
        this.enabled = i != -1;
    }

    public int getPort() {
        return this.httpport != -1 ? this.httpport : this.jrmpport;
    }

    public void setHttpPort(int i) {
        this.httpport = i;
    }

    public int getHttpPort() {
        return this.httpport;
    }

    public void setHttpHost(String host) {
        this.httphost = host;
    }

    public String getHttpHost() {
        return this.httphost;
    }

    public void setAuthMode(String mode) {
        this.authmode = mode;
    }

    public String getAuthMode() {
        return this.authmode;
    }

    public void setAuthUser(String user) {
        this.authuser = user;
    }

    public String getAuthUser() {
        return this.authuser;
    }

    public void setAuthPassword(String password) {
        this.authpassword = password;
    }

    public String getAuthPassword() {
        return this.authpassword;
    }

    public void setJrmpPort(int i) {
        this.jrmpport = i;
    }

    public int getJrmpPort() {
        return this.jrmpport;
    }

    public void setJrmpHost(String host) {
        this.jrmphost = host;
    }

    public String getJrmpHost() {
        return this.jrmphost;
    }

    public boolean getUseXSLTProcessor() {
        return this.useXSLTProcessor;
    }

    public void setUseXSLTProcessor(boolean uxsltp) {
        this.useXSLTProcessor = uxsltp;
    }

    public void loadAdapter() throws IOException {
        ObjectName processorName;
        boolean httpAdapterLoaded = false;
        boolean jrmpAdapterLoaded = false;
        if (this.httpport != -1 && JkMX.classExists("mx4j.adaptor.http.HttpAdaptor")) {
            try {
                this.httpServerName = this.registerObject("mx4j.adaptor.http.HttpAdaptor", "Http:name=HttpAdaptor");
                if (this.httphost != null) {
                    this.mserver.setAttribute(this.httpServerName, new Attribute("Host", this.httphost));
                }
                this.mserver.setAttribute(this.httpServerName, new Attribute("Port", new Integer(this.httpport)));
                if ("none".equals(this.authmode) || "basic".equals(this.authmode) || "digest".equals(this.authmode)) {
                    this.mserver.setAttribute(this.httpServerName, new Attribute("AuthenticationMethod", this.authmode));
                }
                if (this.authuser != null && this.authpassword != null) {
                    this.mserver.invoke(this.httpServerName, "addAuthorization", new Object[]{this.authuser, this.authpassword}, new String[]{"java.lang.String", "java.lang.String"});
                }
                if (this.useXSLTProcessor) {
                    processorName = this.registerObject("mx4j.adaptor.http.XSLTProcessor", "Http:name=XSLTProcessor");
                    this.mserver.setAttribute(this.httpServerName, new Attribute("ProcessorName", processorName));
                }
                this.mserver.invoke(this.httpServerName, "start", null, null);
                log.info((Object)("Started MX4J console on host " + this.httphost + " at port " + this.httpport));
                httpAdapterLoaded = true;
            }
            catch (Throwable t) {
                this.httpServerName = null;
                log.error((Object)"Can't load the MX4J http adapter ", t);
            }
        }
        if (this.httpport != -1 && !httpAdapterLoaded && JkMX.classExists("mx4j.tools.adaptor.http.HttpAdaptor")) {
            try {
                this.httpServerName = this.registerObject("mx4j.tools.adaptor.http.HttpAdaptor", "Http:name=HttpAdaptor");
                if (this.httphost != null) {
                    this.mserver.setAttribute(this.httpServerName, new Attribute("Host", this.httphost));
                }
                this.mserver.setAttribute(this.httpServerName, new Attribute("Port", new Integer(this.httpport)));
                if ("none".equals(this.authmode) || "basic".equals(this.authmode) || "digest".equals(this.authmode)) {
                    this.mserver.setAttribute(this.httpServerName, new Attribute("AuthenticationMethod", this.authmode));
                }
                if (this.authuser != null && this.authpassword != null) {
                    this.mserver.invoke(this.httpServerName, "addAuthorization", new Object[]{this.authuser, this.authpassword}, new String[]{"java.lang.String", "java.lang.String"});
                }
                if (this.useXSLTProcessor) {
                    processorName = this.registerObject("mx4j.tools.adaptor.http.XSLTProcessor", "Http:name=XSLTProcessor");
                    this.mserver.setAttribute(this.httpServerName, new Attribute("ProcessorName", processorName));
                }
                this.mserver.invoke(this.httpServerName, "start", null, null);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Started MX4J console on host " + this.httphost + " at port " + this.httpport));
                }
                httpAdapterLoaded = true;
            }
            catch (Throwable t) {
                this.httpServerName = null;
                log.error((Object)"Can't load the MX4J http adapter ", t);
            }
        }
        if (this.jrmpport != -1 && JkMX.classExists("mx4j.tools.naming.NamingService")) {
            try {
                this.jrmpServerName = this.registerObject("mx4j.tools.naming.NamingService", "Naming:name=rmiregistry");
                this.mserver.setAttribute(this.jrmpServerName, new Attribute("Port", new Integer(this.jrmpport)));
                this.mserver.invoke(this.jrmpServerName, "start", null, null);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Creating " + this.jrmpServerName));
                }
                ObjectName adaptor = this.registerObject("mx4j.adaptor.rmi.jrmp.JRMPAdaptor", "Adaptor:protocol=jrmp");
                this.mserver.setAttribute(adaptor, new Attribute("JNDIName", "jrmp"));
                this.mserver.invoke(adaptor, "putNamingProperty", new Object[]{"java.naming.factory.initial", "com.sun.jndi.rmi.registry.RegistryContextFactory"}, new String[]{"java.lang.Object", "java.lang.Object"});
                String jrpmurl = "rmi://" + this.jrmphost + ":" + Integer.toString(this.jrmpport);
                this.mserver.invoke(adaptor, "putNamingProperty", new Object[]{"java.naming.provider.url", jrpmurl}, new String[]{"java.lang.Object", "java.lang.Object"});
                this.mserver.invoke(adaptor, "start", null, null);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Creating " + adaptor + " on host " + this.jrmphost + " at port " + this.jrmpport));
                }
                jrmpAdapterLoaded = true;
            }
            catch (Exception ex) {
                this.jrmpServerName = null;
                log.error((Object)("MX4j RMI adapter not loaded: " + ex.toString()));
            }
        }
        if (this.httpport != -1 && !httpAdapterLoaded && JkMX.classExists("com.sun.jdmk.comm.HtmlAdaptorServer")) {
            try {
                this.httpServerName = this.registerObject("com.sun.jdmk.comm.HtmlAdaptorServer", "Adaptor:name=html,port=" + this.httpport);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Registering the JMX_RI html adapter " + this.httpServerName + " at port " + this.httpport));
                }
                this.mserver.setAttribute(this.httpServerName, new Attribute("Port", new Integer(this.httpport)));
                this.mserver.invoke(this.httpServerName, "start", null, null);
                httpAdapterLoaded = true;
            }
            catch (Throwable t) {
                this.httpServerName = null;
                log.error((Object)("Can't load the JMX_RI http adapter " + t.toString()));
            }
        }
        if (!httpAdapterLoaded && !jrmpAdapterLoaded) {
            log.warn((Object)"No adaptors were loaded but mx.enabled was defined.");
        }
    }

    public void destroy() {
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)"Stoping JMX ");
            }
            if (this.httpServerName != null) {
                this.mserver.invoke(this.httpServerName, "stop", null, null);
            }
            if (this.jrmpServerName != null) {
                this.mserver.invoke(this.jrmpServerName, "stop", null, null);
            }
        }
        catch (Throwable t) {
            log.error((Object)("Destroy error" + t));
        }
    }

    public void init() throws IOException {
        block7: {
            try {
                this.mserver = this.getMBeanServer();
                if (this.enabled) {
                    this.loadAdapter();
                }
                if (!this.log4jEnabled) break block7;
                try {
                    this.registerObject("org.apache.log4j.jmx.HierarchyDynamicMBean", "log4j:hierarchy=default");
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Registering the JMX hierarchy for Log4J ");
                    }
                }
                catch (Throwable t) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Can't enable log4j mx: ", t);
                    }
                }
            }
            catch (Throwable t) {
                log.error((Object)"Init error", t);
            }
        }
    }

    public void addHandlerCallback(JkHandler w) {
    }

    MBeanServer getMBeanServer() {
        MBeanServer server = MBeanServerFactory.findMBeanServer(null).size() > 0 ? MBeanServerFactory.findMBeanServer(null).get(0) : MBeanServerFactory.createMBeanServer();
        return server;
    }

    private static boolean classExists(String className) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(className);
            return true;
        }
        catch (Throwable e) {
            if (log.isInfoEnabled()) {
                log.info((Object)("className [" + className + "] does not exist"));
            }
            return false;
        }
    }

    private ObjectName registerObject(String className, String oName) throws Exception {
        Class<?> c = Class.forName(className);
        Object o = c.newInstance();
        ObjectName objN = new ObjectName(oName);
        this.mserver.registerMBean(o, objN);
        return objN;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

