/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator;

import java.io.IOException;
import java.io.Writer;
import org.jfree.xml.generator.model.ClassDescription;
import org.jfree.xml.generator.model.Comments;
import org.jfree.xml.generator.model.DescriptionModel;
import org.jfree.xml.generator.model.IgnoredPropertyInfo;
import org.jfree.xml.generator.model.ManualMappingInfo;
import org.jfree.xml.generator.model.MultiplexMappingInfo;
import org.jfree.xml.generator.model.PropertyInfo;
import org.jfree.xml.generator.model.PropertyType;
import org.jfree.xml.generator.model.TypeInfo;
import org.jfree.xml.writer.AttributeList;
import org.jfree.xml.writer.SafeTagList;
import org.jfree.xml.writer.XMLWriterSupport;

public class ModelWriter {
    private static SafeTagList safeTags;
    private XMLWriterSupport writerSupport = new XMLWriterSupport(ModelWriter.getSafeTags(), 0);
    private DescriptionModel model;

    public static SafeTagList getSafeTags() {
        if (safeTags == null) {
            safeTags = new SafeTagList();
            safeTags.add("objects");
            safeTags.add("object");
            safeTags.add("constructor");
            safeTags.add("element-property");
            safeTags.add("lookup");
            safeTags.add("attribute-property");
            safeTags.add("parameter");
            safeTags.add("include");
            safeTags.add("ignore");
            safeTags.add("manual");
            safeTags.add("mapping");
            safeTags.add("type");
        }
        return safeTags;
    }

    public DescriptionModel getModel() {
        return this.model;
    }

    public void setModel(DescriptionModel descriptionModel) {
        this.model = descriptionModel;
    }

    public static void writeXMLHeader(Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.write(XMLWriterSupport.getLineSeparator());
    }

    protected void writeStandardComment(Writer writer, Comments comments) throws IOException {
        if (comments == null || comments.getOpenTagComment() == null) {
            writer.write("<!-- CVSTag: $Id: ModelWriter.java,v 1.13 2004/04/26 19:15:48 taqua Exp $ " + comments + " -->");
            writer.write(XMLWriterSupport.getLineSeparator());
        } else {
            this.writeComment(writer, comments.getOpenTagComment());
        }
    }

    protected void writeComment(Writer writer, String[] stringArray) throws IOException {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.writerSupport.indent(writer, 3);
            writer.write("<!--");
            writer.write(stringArray[i]);
            writer.write("-->");
            writer.write(XMLWriterSupport.getLineSeparator());
        }
    }

    protected void writeOpenComment(Writer writer, Comments comments) throws IOException {
        if (comments == null) {
            return;
        }
        if (comments.getOpenTagComment() == null) {
            return;
        }
        this.writeComment(writer, comments.getOpenTagComment());
    }

    protected void writeCloseComment(Writer writer, Comments comments) throws IOException {
        if (comments == null) {
            return;
        }
        if (comments.getCloseTagComment() == null) {
            return;
        }
        this.writeComment(writer, comments.getCloseTagComment());
    }

    protected void writeTag(Writer writer, String string, AttributeList attributeList, Comments comments) throws IOException {
        if (comments == null) {
            this.writerSupport.writeTag(writer, string, attributeList, true);
        } else {
            this.writeOpenComment(writer, comments);
            if (comments.getCloseTagComment() != null) {
                this.writerSupport.writeTag(writer, string, attributeList, false);
                this.writeCloseComment(writer, comments);
                this.writerSupport.writeCloseTag(writer, string);
            } else {
                this.writerSupport.writeTag(writer, string, attributeList, true);
            }
        }
    }

    protected void writeTag(Writer writer, String string, String string2, String string3, Comments comments) throws IOException {
        if (comments == null) {
            this.writerSupport.writeTag(writer, string, string2, string3, true);
        } else {
            this.writeOpenComment(writer, comments);
            if (comments.getCloseTagComment() != null) {
                this.writerSupport.writeTag(writer, string, string2, string3, false);
                this.writeCloseComment(writer, comments);
                this.writerSupport.writeCloseTag(writer, string);
            } else {
                this.writerSupport.writeTag(writer, string, string2, string3, true);
            }
        }
    }

    public void write(Writer writer) throws IOException {
        Object object;
        int n;
        this.writeStandardComment(writer, this.model.getModelComments());
        this.writerSupport.writeTag(writer, "objects");
        String[] stringArray = this.model.getSources();
        for (n = 0; n < stringArray.length; ++n) {
            object = this.model.getIncludeComment(stringArray[n]);
            this.writeTag(writer, "include", "src", stringArray[n], (Comments)object);
        }
        for (n = 0; n < this.model.size(); ++n) {
            object = this.model.get(n);
            this.writeClassDescription(writer, (ClassDescription)object);
        }
        ManualMappingInfo[] manualMappingInfoArray = this.getModel().getMappingModel().getManualMapping();
        for (int i = 0; i < manualMappingInfoArray.length; ++i) {
            ManualMappingInfo manualMappingInfo = manualMappingInfoArray[i];
            this.writeManualMapping(writer, manualMappingInfo);
        }
        MultiplexMappingInfo[] multiplexMappingInfoArray = this.getModel().getMappingModel().getMultiplexMapping();
        for (int i = 0; i < multiplexMappingInfoArray.length; ++i) {
            MultiplexMappingInfo multiplexMappingInfo = multiplexMappingInfoArray[i];
            this.writeMultiplexMapping(writer, multiplexMappingInfo);
        }
        this.writeCloseComment(writer, this.model.getModelComments());
        this.writerSupport.writeCloseTag(writer, "objects");
    }

    protected void writeManualMapping(Writer writer, ManualMappingInfo manualMappingInfo) throws IOException {
        AttributeList attributeList = new AttributeList();
        attributeList.setAttribute("class", manualMappingInfo.getBaseClass().getName());
        attributeList.setAttribute("read-handler", manualMappingInfo.getReadHandler().getName());
        attributeList.setAttribute("write-handler", manualMappingInfo.getWriteHandler().getName());
        this.writeTag(writer, "manual", attributeList, manualMappingInfo.getComments());
    }

    protected void writeMultiplexMapping(Writer writer, MultiplexMappingInfo multiplexMappingInfo) throws IOException {
        TypeInfo[] typeInfoArray = multiplexMappingInfo.getChildClasses();
        AttributeList attributeList = new AttributeList();
        attributeList.setAttribute("base-class", multiplexMappingInfo.getBaseClass().getName());
        attributeList.setAttribute("type-attribute", multiplexMappingInfo.getTypeAttribute());
        this.getWriterSupport().writeTag(writer, "mapping", attributeList, false);
        for (int i = 0; i < typeInfoArray.length; ++i) {
            AttributeList attributeList2 = new AttributeList();
            attributeList2.setAttribute("name", typeInfoArray[i].getName());
            attributeList2.setAttribute("class", typeInfoArray[i].getType().getName());
            this.writeTag(writer, "type", attributeList2, typeInfoArray[i].getComments());
        }
        this.getWriterSupport().writeCloseTag(writer, "mapping");
    }

    protected void writeClassDescription(Writer writer, ClassDescription classDescription) throws IOException {
        if (classDescription.isUndefined()) {
            return;
        }
        AttributeList attributeList = new AttributeList();
        attributeList.setAttribute("class", classDescription.getName());
        if (classDescription.getRegisterKey() != null) {
            attributeList.setAttribute("register-name", classDescription.getRegisterKey());
        }
        if (classDescription.isPreserve()) {
            attributeList.setAttribute("ignore", "true");
        }
        this.writerSupport.writeTag(writer, "object", attributeList, false);
        TypeInfo[] typeInfoArray = classDescription.getConstructorDescription();
        if (typeInfoArray != null && typeInfoArray.length != 0) {
            this.writerSupport.writeTag(writer, "constructor");
            for (int i = 0; i < typeInfoArray.length; ++i) {
                AttributeList attributeList2 = new AttributeList();
                attributeList2.setAttribute("class", typeInfoArray[i].getType().getName());
                attributeList2.setAttribute("property", typeInfoArray[i].getName());
                this.writeTag(writer, "parameter", attributeList2, typeInfoArray[i].getComments());
            }
            this.writerSupport.writeCloseTag(writer, "constructor");
        }
        PropertyInfo[] propertyInfoArray = classDescription.getProperties();
        for (int i = 0; i < propertyInfoArray.length; ++i) {
            this.writePropertyInfo(writer, propertyInfoArray[i]);
        }
        this.writerSupport.writeCloseTag(writer, "object");
    }

    private void writePropertyInfo(Writer writer, PropertyInfo propertyInfo) throws IOException {
        AttributeList attributeList = new AttributeList();
        attributeList.setAttribute("name", propertyInfo.getName());
        if (propertyInfo instanceof IgnoredPropertyInfo) {
            this.writeTag(writer, "ignore", attributeList, propertyInfo.getComments());
            return;
        }
        if (propertyInfo.getPropertyType().equals(PropertyType.ATTRIBUTE)) {
            attributeList.setAttribute("attribute", propertyInfo.getXmlName());
            attributeList.setAttribute("handler", propertyInfo.getXmlHandler());
            this.writeTag(writer, "attribute-property", attributeList, propertyInfo.getComments());
        } else if (propertyInfo.getPropertyType().equals(PropertyType.ELEMENT)) {
            if (propertyInfo.getComments() == null || propertyInfo.getComments().getOpenTagComment() == null) {
                this.writerSupport.indent(writer, 3);
                writer.write("<!-- property type is " + propertyInfo.getType() + " -->");
                writer.write(System.getProperty("line.separator", "\n"));
            }
            attributeList.setAttribute("element", propertyInfo.getXmlName());
            this.writeTag(writer, "element-property", attributeList, propertyInfo.getComments());
        } else {
            attributeList.setAttribute("lookup", propertyInfo.getXmlName());
            this.writeTag(writer, "lookup", attributeList, propertyInfo.getComments());
        }
    }

    public XMLWriterSupport getWriterSupport() {
        return this.writerSupport;
    }
}

