/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.handlers;

import java.io.InputStream;
import java.security.MessageDigest;
import javax.activation.DataHandler;
import org.jboss.axis.AxisFault;
import org.jboss.axis.Message;
import org.jboss.axis.MessageContext;
import org.jboss.axis.Part;
import org.jboss.axis.attachments.AttachmentUtils;
import org.jboss.axis.encoding.Base64;
import org.jboss.axis.handlers.BasicHandler;
import org.jboss.axis.message.SOAPBodyElementAxisImpl;
import org.jboss.axis.message.SOAPEnvelopeAxisImpl;
import org.jboss.axis.soap.SOAPConstants;
import org.jboss.axis.utils.Messages;
import org.jboss.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class MD5AttachHandler
extends BasicHandler {
    private static Logger log = Logger.getLogger((String)MD5AttachHandler.class.getName());

    public void invoke(MessageContext msgContext) throws AxisFault {
        log.debug((Object)"Enter: EchoHandler::invoke");
        try {
            Node n;
            Message msg = msgContext.getRequestMessage();
            SOAPConstants soapConstants = msgContext.getSOAPConstants();
            SOAPEnvelopeAxisImpl env = msg.getSOAPEnvelope();
            SOAPBodyElementAxisImpl sbe = env.getFirstBody();
            Element sbElement = sbe.getAsDOM();
            for (n = sbElement.getFirstChild(); n != null && !(n instanceof Element); n = n.getNextSibling()) {
            }
            Element paramElement = (Element)n;
            String href = paramElement.getAttribute(soapConstants.getAttrHref());
            Part ap = msg.getAttachmentsImpl().getAttachmentByReference(href);
            DataHandler dh = AttachmentUtils.getActivationDataHandler(ap);
            Node timeNode = paramElement.getFirstChild();
            long startTime = -1L;
            if (timeNode != null && timeNode instanceof Text) {
                String startTimeStr = ((Text)timeNode).getData();
                startTime = Long.parseLong(startTimeStr);
            }
            long receivedTime = System.currentTimeMillis();
            long elapsedTime = -1L;
            if (startTime > 0L) {
                elapsedTime = receivedTime - startTime;
            }
            String elapsedTimeStr = elapsedTime + "";
            MessageDigest md = MessageDigest.getInstance("MD5");
            InputStream attachmentStream = dh.getInputStream();
            int bread = 0;
            byte[] buf = new byte[65536];
            do {
                if ((bread = attachmentStream.read(buf)) <= 0) continue;
                md.update(buf, 0, bread);
            } while (bread > -1);
            attachmentStream.close();
            buf = null;
            String contentType = dh.getContentType();
            if (contentType != null && contentType.length() != 0) {
                md.update(contentType.getBytes("US-ASCII"));
            }
            sbe = env.getFirstBody();
            sbElement = sbe.getAsDOM();
            for (n = sbElement.getFirstChild(); n != null && !(n instanceof Element); n = n.getNextSibling()) {
            }
            paramElement = (Element)n;
            String MD5String = Base64.encode(md.digest());
            String senddata = " elapsedTime=" + elapsedTimeStr + " MD5=" + MD5String;
            paramElement.appendChild(paramElement.getOwnerDocument().createTextNode(senddata));
            sbe = new SOAPBodyElementAxisImpl(sbElement);
            env.clearBody();
            env.addBodyElement(sbe);
            msg = new Message(env);
            msgContext.setResponseMessage(msg);
        }
        catch (Exception e) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
            throw AxisFault.makeFault(e);
        }
        log.debug((Object)"Exit: EchoHandler::invoke");
    }
}

