/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.enums;

import java.util.Hashtable;
import org.jboss.axis.utils.Messages;
import org.jboss.logging.Logger;

public abstract class Enum {
    private static final Hashtable types = new Hashtable(13);
    private static Logger log = Logger.getLogger((String)Enum.class.getName());
    private final Type type;
    public final int value;
    public final String name;

    protected Enum(Type type, int value, String name) {
        this.type = type;
        this.value = value;
        this.name = name.intern();
    }

    public final int getValue() {
        return this.value;
    }

    public final String getName() {
        return this.name;
    }

    public final Type getType() {
        return this.type;
    }

    public String toString() {
        return this.name;
    }

    public final boolean equals(Object obj) {
        return obj != null && obj instanceof Enum ? this._equals((Enum)obj) : false;
    }

    public final boolean equals(Enum obj) {
        return obj != null ? this._equals(obj) : false;
    }

    private final boolean _equals(Enum obj) {
        return obj.type == this.type && obj.value == this.value;
    }

    public static abstract class Type {
        private final String name;
        private final Enum[] enumArr;
        private Enum dephault = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Type(String name, Enum[] enums) {
            this.name = name.intern();
            this.enumArr = enums;
            Hashtable hashtable = types;
            synchronized (hashtable) {
                types.put(name, this);
            }
        }

        protected void setDefault(Enum dephault) {
            this.dephault = dephault;
        }

        public Enum getDefault() {
            return this.dephault;
        }

        public final String getName() {
            return this.name;
        }

        public final boolean isValid(String enumName) {
            for (int en = 0; en < this.enumArr.length; ++en) {
                if (!this.enumArr[en].getName().equalsIgnoreCase(enumName)) continue;
                return true;
            }
            return false;
        }

        public final int size() {
            return this.enumArr.length;
        }

        public final String[] getEnumNames() {
            String[] nms = new String[this.size()];
            for (int idx = 0; idx < this.enumArr.length; ++idx) {
                nms[idx] = this.enumArr[idx].getName();
            }
            return nms;
        }

        public final Enum getEnum(int en) {
            return en >= 0 && en < this.enumArr.length ? this.enumArr[en] : null;
        }

        public final Enum getEnum(String enumName) {
            Enum e = this.getEnum(enumName, null);
            if (e == null) {
                log.error((Object)Messages.getMessage("badEnum02", this.name, enumName));
            }
            return e;
        }

        public final Enum getEnum(String enumName, Enum dephault) {
            if (enumName != null && enumName.length() > 0) {
                for (int en = 0; en < this.enumArr.length; ++en) {
                    Enum e = this.enumArr[en];
                    if (!e.getName().equalsIgnoreCase(enumName)) continue;
                    return e;
                }
            }
            return dephault;
        }
    }
}

