/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.encoding.ser;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.jboss.axis.encoding.ser.SimpleDeserializer;
import org.jboss.axis.utils.Messages;

public class DateDeserializer
extends SimpleDeserializer {
    private static SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat zuluUTC = new SimpleDateFormat("yyyy-MM-dd");

    public DateDeserializer(Class javaType, QName xmlType) {
        super(javaType, xmlType);
    }

    /*
     * WARNING - void declaration
     */
    private int adjustByZone(Date date, String zone) {
        void var3_3;
        int minutes;
        int hours;
        int sign;
        if (zone.charAt(0) == 'Z') {
            return 0;
        }
        if (zone.charAt(0) == '-') {
            sign = 1;
        } else if (zone.charAt(0) == '+') {
            sign = -1;
        } else {
            throw new NumberFormatException(Messages.getMessage("badTimezone00"));
        }
        if (zone.charAt(3) != ':') {
            throw new NumberFormatException(Messages.getMessage("badTimezone00"));
        }
        try {
            hours = Integer.parseInt(zone.substring(1, 3));
            minutes = Integer.parseInt(zone.substring(4, 6));
        }
        catch (Exception e) {
            throw new NumberFormatException(Messages.getMessage("badTimezone00"));
        }
        if (hours > 14 || hours == 14 && minutes > 0 || minutes > 59) {
            throw new NumberFormatException(Messages.getMessage("badTimezone00"));
        }
        void offset = var3_3 * (hours * 60 + minutes) * 60 * 1000;
        date.setTime(date.getTime() + (long)offset);
        return (int)(-offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object makeValue(String source) {
        Calendar calendar;
        Date result;
        boolean bc;
        block17: {
            bc = false;
            String zonePortion = null;
            if (source == null) {
                throw new NumberFormatException(Messages.getMessage("badDate00"));
            }
            if (source.charAt(0) == '+') {
                source = source.substring(1);
            }
            if (source.charAt(0) == '-') {
                source = source.substring(1);
                bc = true;
            }
            if (source.length() < 10) {
                throw new NumberFormatException(Messages.getMessage("badDate00"));
            }
            if (source.charAt(4) != '-' || source.charAt(7) != '-') {
                throw new NumberFormatException(Messages.getMessage("badDate00"));
            }
            try {
                if (source.length() > 10) {
                    zonePortion = source.substring(10);
                    SimpleDateFormat simpleDateFormat = zuluUTC;
                    synchronized (simpleDateFormat) {
                        result = zuluUTC.parse(source.substring(0, 10));
                    }
                    int offset = this.adjustByZone(result, zonePortion);
                    TimeZone timeZone = offset == 0 ? TimeZone.getTimeZone("GMT") : new SimpleTimeZone(offset, "GMT offset");
                    calendar = Calendar.getInstance(timeZone);
                    break block17;
                }
                SimpleDateFormat offset = zulu;
                synchronized (offset) {
                    result = zulu.parse(source);
                }
                calendar = Calendar.getInstance();
            }
            catch (NumberFormatException e) {
                throw e;
            }
            catch (Exception e) {
                throw new NumberFormatException(e.toString());
            }
        }
        calendar.setTime(result);
        if (bc) {
            calendar.set(0, 0);
            result = calendar.getTime();
        }
        if (this.javaType == Calendar.class) {
            return calendar;
        }
        return result;
    }

    static {
        zuluUTC.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

