/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmptrap.dao;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.snmptrap.dao.SnmpTrapMibMasterDAO;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterBean;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterPK;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SnmpTrapMibMasterDAOImpl
implements SnmpTrapMibMasterDAO {
    protected static Log m_log = LogFactory.getLog(SnmpTrapMibMasterDAOImpl.class);

    public void init() {
    }

    public void load(SnmpTrapMibMasterPK pk, SnmpTrapMibMasterBean ejb) throws EJBException {
        block13: {
            m_log.debug((Object)("load() start : " + pk.toString()));
            Connection conn = null;
            Statement stmt = null;
            ResultSet res = null;
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_snmp_trap_mib_mst WHERE mib = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.mib);
                res = stmt.executeQuery();
                if (res.next()) {
                    ejb.setMib(res.getString("mib"));
                    ejb.setOrderNo(res.getInt("order_no"));
                    ejb.setDescription(res.getString("description"));
                    ejb.setRegDate(res.getTimestamp("reg_date"));
                    ejb.setUpdateDate(res.getTimestamp("update_date"));
                    ejb.setRegUser(res.getString("reg_user"));
                    ejb.setUpdateUser(res.getString("update_user"));
                    break block13;
                }
                String msg = "SnmpTrapMibMaster data is not found.";
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + msg));
                throw new EJBException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (res != null) {
                        res.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e1) {
                    m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
                    throw new EJBException(e1.getMessage());
                }
            }
        }
        m_log.debug((Object)("load() end : " + pk.toString()));
    }

    public void store(SnmpTrapMibMasterBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getMib()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("UPDATE cc_snmp_trap_mib_mst SET ");
            sql.append("order_no = ?, ");
            sql.append("description = ?, ");
            sql.append("reg_date = ?, ");
            sql.append("update_date = ?, ");
            sql.append("reg_user = ?, ");
            sql.append("update_user = ? ");
            sql.append("WHERE mib = ?");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setInt(1, ejb.getOrderNo());
            stmt.setString(2, ejb.getDescription());
            stmt.setTimestamp(3, ejb.getRegDate());
            stmt.setTimestamp(4, ejb.getUpdateDate());
            stmt.setString(5, ejb.getRegUser());
            stmt.setString(6, ejb.getUpdateUser());
            stmt.setString(7, ejb.getMib());
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("store() error : " + ejb.getMib() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("store() error : " + ejb.getMib() + " SQLException"));
            e.printStackTrace();
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("store() error : " + ejb.getMib() + " SQLException"));
                e1.printStackTrace();
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("store() end : " + ejb.getMib()));
    }

    public void remove(SnmpTrapMibMasterPK pk) throws RemoveException, EJBException {
        m_log.debug((Object)("remove() start : " + pk.toString()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "DELETE FROM cc_snmp_trap_mib_mst WHERE mib = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.mib);
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("remove() end : " + pk.toString()));
    }

    public SnmpTrapMibMasterPK create(SnmpTrapMibMasterBean ejb) throws CreateException, EJBException {
        SnmpTrapMibMasterPK pk;
        m_log.debug((Object)("create() start : " + ejb.getMib()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT INTO cc_snmp_trap_mib_mst (");
            sql.append("mib, ");
            sql.append("order_no, ");
            sql.append("description, ");
            sql.append("reg_date, ");
            sql.append("update_date, ");
            sql.append("reg_user, ");
            sql.append("update_user )");
            sql.append("values (?,?,?,?,?,?,?)");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, ejb.getMib());
            stmt.setInt(2, ejb.getOrderNo());
            stmt.setString(3, ejb.getDescription());
            stmt.setTimestamp(4, ejb.getRegDate());
            stmt.setTimestamp(5, ejb.getUpdateDate());
            stmt.setString(6, ejb.getRegUser());
            stmt.setString(7, ejb.getUpdateUser());
            int row = stmt.executeUpdate();
            pk = new SnmpTrapMibMasterPK(ejb.getMib());
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("create() error : " + ejb.getMib() + " SQLException"));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("23505")) {
                m_log.error((Object)("create() error : " + ejb.getMib() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
            throw new CreateException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getMib() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("create() end : " + ejb.getMib()));
        return pk;
    }

    public Collection findAll() throws FinderException {
        m_log.debug((Object)"findAll() start : ");
        ArrayList<SnmpTrapMibMasterPK> ret = new ArrayList<SnmpTrapMibMasterPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_snmp_trap_mib_mst ORDER BY order_no";
            stmt = conn.prepareStatement(sql);
            res = stmt.executeQuery();
            while (res.next()) {
                SnmpTrapMibMasterPK pk = new SnmpTrapMibMasterPK(res.getString("mib"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)"findAll() end : ");
        return ret;
    }

    public SnmpTrapMibMasterPK findByPrimaryKey(SnmpTrapMibMasterPK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_snmp_trap_mib_mst WHERE mib = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.mib);
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            SnmpTrapMibMasterPK snmpTrapMibMasterPK = pk;
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            return snmpTrapMibMasterPK;
        }
        try {
            try {
                String msg = "SnmpTrapMibMasterPK.findByPromaryKey() : id " + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            throw throwable;
        }
    }
}

