/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.axis.server;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;
import org.jboss.net.axis.server.AxisServiceServlet;

public class FlashAxisServiceServlet
extends AxisServiceServlet {
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

    public FlashAxisServiceServlet() {
        this.log.trace((Object)"Constructing");
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Object newReq = req;
        try {
            newReq = new FilteredHttpServletRequest(req);
            this.log.trace((Object)"doPost(): Successfully created a FilteredHttpServletRequest object.");
        }
        catch (IllegalArgumentException e) {
            this.log.error((Object)"doPost(): Failed to create a FilteredHttpServletRequest object.  Use original HttpServletRequest.");
        }
        super.doPost(newReq, res);
    }

    public class FilteredHttpServletRequest
    extends HttpServletRequestWrapper {
        protected String soapAction;

        public FilteredHttpServletRequest(HttpServletRequest req) throws IllegalArgumentException {
            super(req);
            this.soapAction = req.getHeader("SOAPAction");
            if (null != this.soapAction) {
                FlashAxisServiceServlet.this.log.error((Object)"HttpServletRequest already contains a SOAPAction header.");
                throw new IllegalArgumentException("HttpServletRequest already contains a SOAPAction header.");
            }
            this.soapAction = this.getParameter("SOAPAction");
            if (null == this.soapAction) {
                FlashAxisServiceServlet.this.log.error((Object)"HttpServletRequest does not contain a SOAPAction parameter.");
                throw new IllegalArgumentException("HttpServletRequest does not contain a SOAPAction parameter.");
            }
            FlashAxisServiceServlet.this.log.trace((Object)"FilteredHttpServletRequest.ctor(): Matched SOAPAction parameter");
        }

        public String getHeader(String name) {
            FlashAxisServiceServlet.this.log.trace((Object)"FlashAxisServiceServlet.FilteredHttpServletRequest.getHeader()");
            if (name.equals("SOAPAction")) {
                FlashAxisServiceServlet.this.log.trace((Object)"getHeader(): Matched SOAPAction header request");
                return this.soapAction;
            }
            FlashAxisServiceServlet.this.log.trace((Object)"getHeader(): Not a SOAPAction header request, called base class method.");
            return super.getHeader(name);
        }
    }
}

