/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.mail.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.notify.mail.ejb.entity.MailTemplateInfoData;
import com.clustercontrol.notify.mail.ejb.entity.MailTemplateInfoLocal;
import com.clustercontrol.notify.mail.ejb.entity.MailTemplateInfoUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.sql.Timestamp;
import java.util.Date;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModifyMailTemplate {
    protected static Log m_log = LogFactory.getLog(ModifyMailTemplate.class);

    public boolean modify(MailTemplateInfoData data, String name) throws FinderException, NamingException {
        AccessLock.lock((String)"NOTIFY");
        try {
            MailTemplateInfoLocal mailTemplateInfo = MailTemplateInfoUtil.getLocalHome().findByPrimaryKey(data.getMailTemplateId());
            if (mailTemplateInfo != null) {
                mailTemplateInfo.setDescription(data.getDescription());
                mailTemplateInfo.setSubject(data.getSubject());
                mailTemplateInfo.setBody(data.getBody());
                mailTemplateInfo.setUpdateDate(new Timestamp(new Date().getTime()));
                mailTemplateInfo.setUpdateUser(name);
            }
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("MAILTEMP", "mail_template");
            Object[] args = new String[]{data.getMailTemplateId()};
            apllog.put("SYS", "002", args);
            m_log.warn((Object)("modify():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("MAILTEMP", "mail_template");
            Object[] args = new String[]{data.getMailTemplateId()};
            apllog.put("SYS", "002", args);
            m_log.warn((Object)("modify():" + e.getMessage()));
            throw e;
        }
        return true;
    }
}

