/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut.ast;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IdentifierExpression {
    private String original;
    private Pattern namePattern;
    private boolean isAnnotation;

    public IdentifierExpression(String expr) {
        this.original = expr;
        if (expr.startsWith("@")) {
            this.isAnnotation = true;
        } else {
            expr = expr.replaceAll("\\*", ".*");
            this.namePattern = Pattern.compile(expr);
        }
    }

    public boolean matches(String name) {
        if (this.isAnnotation) {
            return false;
        }
        Matcher m = this.namePattern.matcher(name);
        return m.matches();
    }

    public boolean matchesAnnotation(String annotation) {
        if (!this.isAnnotation) {
            return false;
        }
        Matcher m = this.namePattern.matcher(annotation);
        return m.matches();
    }

    public String getOriginal() {
        return this.original;
    }

    public boolean isAnnotation() {
        return this.isAnnotation;
    }
}

