/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.annotation.compiler;

import java.io.PrintWriter;
import org.jboss.aop.annotation.ast.ASTAnnotation;
import org.jboss.aop.annotation.ast.ASTChar;
import org.jboss.aop.annotation.ast.ASTIdentifier;
import org.jboss.aop.annotation.ast.ASTMemberValueArrayInitializer;
import org.jboss.aop.annotation.ast.ASTMemberValuePair;
import org.jboss.aop.annotation.ast.ASTMemberValuePairs;
import org.jboss.aop.annotation.ast.ASTSingleMemberValue;
import org.jboss.aop.annotation.ast.ASTStart;
import org.jboss.aop.annotation.ast.ASTString;
import org.jboss.aop.annotation.ast.AnnotationParserVisitor;
import org.jboss.aop.annotation.ast.SimpleNode;
import org.jboss.aop.annotation.compiler.XmlAnnotationCompiler;

public class XmlAnnotationVisitor
implements AnnotationParserVisitor {
    private int indent;
    PrintWriter pw;

    public XmlAnnotationVisitor(int indent, PrintWriter pw) {
        this.indent = indent;
        this.pw = pw;
    }

    public Object visit(ASTMemberValuePairs node, Object data) {
        node.childrenAccept(this, data);
        return null;
    }

    public Object visit(ASTMemberValuePair node, Object data) {
        XmlAnnotationCompiler.indenter(this.pw, this.indent);
        this.pw.print("<" + node.getIdentifier().getValue() + ">");
        node.getValue().jjtAccept(this, null);
        this.pw.println("</" + node.getIdentifier().getValue() + ">");
        return null;
    }

    public Object visit(ASTSingleMemberValue node, Object data) {
        XmlAnnotationCompiler.indenter(this.pw, this.indent);
        this.pw.print("<value>");
        node.getValue().jjtAccept(this, null);
        this.pw.println("</value>");
        return null;
    }

    public Object visit(ASTAnnotation node, Object data) {
        this.pw.println("");
        ++this.indent;
        XmlAnnotationCompiler.indenter(this.pw, this.indent);
        this.pw.println("<annotation tag=\"" + node.getIdentifier() + "\">");
        ++this.indent;
        node.childrenAccept(this, data);
        --this.indent;
        XmlAnnotationCompiler.indenter(this.pw, this.indent);
        this.pw.println("</annotation>");
        --this.indent;
        XmlAnnotationCompiler.indenter(this.pw, this.indent);
        return null;
    }

    public Object visit(ASTMemberValueArrayInitializer node, Object data) {
        this.pw.println("");
        ++this.indent;
        XmlAnnotationCompiler.indenter(this.pw, this.indent);
        this.pw.println("<array>");
        ++this.indent;
        int size = node.jjtGetNumChildren();
        for (int i = 0; i < size; ++i) {
            XmlAnnotationCompiler.indenter(this.pw, this.indent);
            this.pw.print("<value>");
            node.jjtGetChild(i).jjtAccept(this, null);
            this.pw.println("</value>");
        }
        --this.indent;
        XmlAnnotationCompiler.indenter(this.pw, this.indent);
        this.pw.println("</array>");
        --this.indent;
        XmlAnnotationCompiler.indenter(this.pw, this.indent);
        return null;
    }

    public Object visit(ASTIdentifier node, Object data) {
        this.pw.print(node.getValue());
        return null;
    }

    public Object visit(ASTString node, Object data) {
        this.pw.print(node.getValue());
        return null;
    }

    public Object visit(ASTChar node, Object data) {
        this.pw.print(node.getValue());
        return null;
    }

    public Object visit(SimpleNode node, Object data) {
        return null;
    }

    public Object visit(ASTStart node, Object data) {
        return null;
    }
}

