/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.interfaces;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import org.jboss.ha.framework.interfaces.ClusteringTargetsRepository;
import org.jboss.ha.framework.interfaces.FamilyClusterInfo;
import org.jboss.ha.framework.interfaces.HARMIProxy;
import org.jboss.ha.framework.interfaces.HARMIResponse;
import org.jboss.ha.framework.interfaces.HARMIServer;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.invocation.MarshalledInvocation;

public class HARMIClient
implements HARMIProxy,
InvocationHandler,
Serializable {
    private static final long serialVersionUID = -1227816478666532463L;
    protected static final Method TO_STRING;
    protected static final Method HASH_CODE;
    protected static final Method EQUALS;
    protected String key = null;
    protected LoadBalancePolicy loadBalancePolicy;
    protected transient Object local = null;
    FamilyClusterInfo familyClusterInfo = null;
    static /* synthetic */ Class class$java$lang$Object;

    public HARMIClient() {
    }

    public HARMIClient(ArrayList targets, LoadBalancePolicy policy, String key) {
        this.familyClusterInfo = ClusteringTargetsRepository.initTarget(key, targets, 0L);
        this.loadBalancePolicy = policy;
        this.loadBalancePolicy.init(this);
        this.key = key;
    }

    public HARMIClient(ArrayList targets, long initViewId, LoadBalancePolicy policy, String key, Object local) {
        this.familyClusterInfo = ClusteringTargetsRepository.initTarget(key, targets, initViewId);
        this.loadBalancePolicy = policy;
        this.loadBalancePolicy.init(this);
        this.key = key;
        this.local = local;
    }

    public void updateClusterInfo(ArrayList targets, long viewId) {
        if (this.familyClusterInfo != null) {
            this.familyClusterInfo.updateClusterInfo(targets, viewId);
        }
    }

    public Object getRemoteTarget() {
        return this.loadBalancePolicy.chooseTarget(this.familyClusterInfo, null);
    }

    public void remoteTargetHasFailed(Object target) {
        this.removeDeadTarget(target);
    }

    public Method findLocalMethod(Method method, Object[] args) throws Exception {
        return method;
    }

    public Object invokeRemote(Object proxy, Method method, Object[] args) throws Throwable {
        HARMIServer target = (HARMIServer)this.getRemoteTarget();
        while (target != null) {
            try {
                MarshalledInvocation mi = new MarshalledInvocation(null, method, args, null, null, null);
                mi.setObjectName((Object)"");
                HARMIResponse rsp = target.invoke(this.familyClusterInfo.getCurrentViewId(), mi);
                if (rsp.newReplicants != null) {
                    this.updateClusterInfo(rsp.newReplicants, rsp.currentViewId);
                }
                return rsp.response;
            }
            catch (ConnectException ce) {
            }
            catch (ConnectIOException cioe) {
            }
            catch (NoSuchObjectException nsoe) {
            }
            catch (UnmarshalException ue) {
            }
            catch (UnknownHostException uhe) {
                // empty catch block
            }
            this.remoteTargetHasFailed(target);
            target = (HARMIServer)this.getRemoteTarget();
        }
        throw new RemoteException("Service unavailable.");
    }

    public boolean isLocal() {
        return this.local != null;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        if (method.equals(TO_STRING)) {
            StringBuffer tmp = new StringBuffer(super.toString());
            tmp.append('(');
            tmp.append(this.familyClusterInfo);
            tmp.append(')');
            return tmp.toString();
        }
        if (name.equals("equals")) {
            return method.invoke((Object)this, args);
        }
        if (name.equals("hashCode")) {
            return method.invoke((Object)this, args);
        }
        if (name.equals("isLocal") && (args == null || args.length == 0)) {
            return method.invoke((Object)this, args);
        }
        if (this.local != null) {
            try {
                Method localMethod = this.findLocalMethod(method, args);
                return localMethod.invoke(this.local, args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
        }
        return this.invokeRemote(null, method, args);
    }

    protected void removeDeadTarget(Object target) {
        if (this.familyClusterInfo != null) {
            this.familyClusterInfo.removeDeadTarget(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.key = stream.readUTF();
        ArrayList targets = (ArrayList)stream.readObject();
        long vid = stream.readLong();
        this.loadBalancePolicy = (LoadBalancePolicy)stream.readObject();
        HARMIServer server = (HARMIServer)HARMIServer.rmiServers.get(this.key);
        this.familyClusterInfo = ClusteringTargetsRepository.initTarget(this.key, targets, vid);
        this.loadBalancePolicy.init(this);
        if (server != null) {
            ArrayList arrayList = targets;
            synchronized (arrayList) {
                try {
                    targets = (ArrayList)server.getReplicants();
                    this.local = server.getLocal();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        ArrayList currentTargets = this.familyClusterInfo.getTargets();
        long vid = this.familyClusterInfo.getCurrentViewId();
        stream.writeUTF(this.key);
        stream.writeObject(currentTargets);
        stream.writeLong(vid);
        stream.writeObject(this.loadBalancePolicy);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Class[] empty = new Class[]{};
            Class type = class$java$lang$Object == null ? (class$java$lang$Object = HARMIClient.class$("java.lang.Object")) : class$java$lang$Object;
            TO_STRING = type.getMethod("toString", empty);
            HASH_CODE = type.getMethod("hashCode", empty);
            EQUALS = type.getMethod("equals", type);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExceptionInInitializerError(e);
        }
    }
}

