/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.lindfors.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Document;

public class AboutDialog
extends JDialog {
    public static final String LABEL_CLOSE = "Close";
    public static final String LABEL_ABOUT = "About";
    private String label = "";
    private JButton closeButton = null;
    private JLabel imageLabel = new JLabel();
    private HashMap lang = new HashMap();

    public AboutDialog() {
        this((Frame)null);
    }

    public AboutDialog(Frame frame) {
        super(frame);
        this.init();
    }

    public AboutDialog(Frame frame, Image image, String string) {
        super(frame);
        this.label = string;
        this.setImage(image);
        this.init();
    }

    public AboutDialog(Frame frame, String string, String string2) {
        super(frame);
        this.setImage(string);
        this.init();
    }

    public void setImage(Image image) {
        this.setImage(new ImageIcon(image));
    }

    public void setImage(String string) {
        URL uRL = this.getClass().getResource(string);
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.setImage(imageIcon);
    }

    public void setImage(ImageIcon imageIcon) {
        this.imageLabel.setIcon(imageIcon);
        this.pack();
    }

    public void setDocument(String string) {
    }

    public void setDocument(Document document) {
    }

    public void setLocale(Locale locale, Properties properties) {
        super.setLocale(locale);
        this.lang.put(locale, properties);
    }

    private void init() {
        this.createLayout();
        this.createKeyActions();
    }

    private void createLayout() {
        JPanel jPanel = new JPanel(new BorderLayout());
        BevelBorder bevelBorder = new BevelBorder(1);
        EmptyBorder emptyBorder = new EmptyBorder(10, 10, 10, 10);
        this.imageLabel.setBackground(Color.white);
        this.imageLabel.setOpaque(true);
        jPanel.add((Component)this.imageLabel, "North");
        jPanel.add((Component)new JLabel(this.label), "Center");
        jPanel.setBorder(new CompoundBorder(emptyBorder, bevelBorder));
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "Center");
        container.add((Component)this.createButtonBar(), "South");
        this.pack();
        this.setTitle(this.getLabel(LABEL_ABOUT));
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
    }

    private void createKeyActions() {
        this.getRootPane().registerKeyboardAction(new CloseDialogAction(), KeyStroke.getKeyStroke(27, 0), 2);
        this.closeButton.registerKeyboardAction(new CloseDialogAction(), KeyStroke.getKeyStroke(10, 0), 0);
    }

    private JComponent createButtonBar() {
        JPanel jPanel = new JPanel(new FlowLayout());
        this.closeButton = new JButton(this.getLabel(LABEL_CLOSE));
        this.closeButton.addActionListener(new CloseDialogAction());
        this.closeButton.requestFocus();
        jPanel.add(this.closeButton);
        return jPanel;
    }

    private String getLabel(String string) {
        Locale locale = this.getLocale();
        Properties properties = (Properties)this.lang.get(locale);
        if (properties == null) {
            return string;
        }
        String string2 = (String)((Hashtable)properties).get(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    class CloseDialogAction
    implements ActionListener {
        CloseDialogAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AboutDialog.this.dispose();
        }
    }
}

