/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.security;

import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import org.jboss.resource.security.GetPrincipalInfoAction;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityAssociation;

class GetPrincipalInfoAction {
    GetPrincipalInfoAction() {
    }

    private static char[] getPassword() {
        Object credential = SecurityAssociation.getCredential();
        char[] password = null;
        if (credential instanceof char[]) {
            password = (char[])credential;
        } else if (credential instanceof byte[]) {
            try {
                String tmp = new String((byte[])credential, "UTF-8");
                password = tmp.toCharArray();
            }
            catch (UnsupportedEncodingException e) {
                throw new SecurityException(e.getMessage());
            }
        } else if (credential != null) {
            String tmp = credential.toString();
            password = tmp.toCharArray();
        }
        return password;
    }

    static Principal getPrincipal() {
        Principal principal = System.getSecurityManager() == null ? PrincipalActions.NON_PRIVILEGED.getPrincipal() : PrincipalActions.PRIVILEGED.getPrincipal();
        return principal;
    }

    static char[] getCredential() {
        char[] credential = System.getSecurityManager() == null ? PrincipalActions.NON_PRIVILEGED.getCredential() : PrincipalActions.PRIVILEGED.getCredential();
        return credential;
    }

    static RunAsIdentity peekRunAsIdentity() {
        if (System.getSecurityManager() == null) {
            return PrincipalActions.NON_PRIVILEGED.peek();
        }
        return PrincipalActions.PRIVILEGED.peek();
    }

    static /* synthetic */ char[] access$000() {
        return GetPrincipalInfoAction.getPassword();
    }

    static interface PrincipalActions {
        public static final PrincipalActions PRIVILEGED = new PrincipalActions(){
            private final PrivilegedAction peekAction;
            private final PrivilegedAction getPrincipalAction;
            private final PrivilegedAction getCredentialAction;
            {
                this.peekAction = new PrivilegedAction(this){
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object run() {
                        return SecurityAssociation.peekRunAsIdentity();
                    }
                };
                this.getPrincipalAction = new PrivilegedAction(this){
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object run() {
                        return SecurityAssociation.getPrincipal();
                    }
                };
                this.getCredentialAction = new PrivilegedAction(this){
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object run() {
                        return GetPrincipalInfoAction.access$000();
                    }
                };
            }

            public RunAsIdentity peek() {
                return (RunAsIdentity)AccessController.doPrivileged(this.peekAction);
            }

            public Principal getPrincipal() {
                return (Principal)AccessController.doPrivileged(this.getPrincipalAction);
            }

            public char[] getCredential() {
                return (char[])AccessController.doPrivileged(this.getCredentialAction);
            }
        };
        public static final PrincipalActions NON_PRIVILEGED = new PrincipalActions(){

            public RunAsIdentity peek() {
                return SecurityAssociation.peekRunAsIdentity();
            }

            public Principal getPrincipal() {
                return SecurityAssociation.getPrincipal();
            }

            public char[] getCredential() {
                return GetPrincipalInfoAction.access$000();
            }
        };

        public Principal getPrincipal();

        public char[] getCredential();

        public RunAsIdentity peek();
    }
}

