<?php
/**
 * 既に付加されているタグ情報から
 * ベイジアンフィルタを学習する
 */

require_once 'config.php';
require_once 'phplib/session.php';
init_session();

require_once 'phplib/common.php';
require_once 'phplib/pager.php';
require_once 'phplib/elasticsearch.php';
require_once 'phplib/const.php';

//read metafile
$metaInfoList = readAllInfo () ;

$boardnames = array(
  "軍" 
, "特撮" 
, "flash" 
, "壁紙" 
, "数学" 
, "二次元グロ" 
, "落書き裏" 
,  "ネットキャラ" 
,  "二次元ネタ" 
,  "甘味" 
,  "ラーメン" 
,  "人形" 
,  "スピグラ" 
,  "韓国経済" 
,  "二次元業界" 
,  "おもちゃ" 
,  "カメラ" 
,  "フィギュア" 
,  "家電" 
,  "アクア" 
, "虹裏dat" 
, "どうぶつ" 
, "のりもの" 
, "二次元" 
, "二輪" 
, "壁紙二" 
, "鉄道" 
, "料理" 
, "模型" 
, "虫" 
, "3DCG" 
,  "三次実況" 
,  "東日本大震災" 
,  "発電" 
,  "東方裏" 
,  "ソシャゲ" 
,  "二次元裏転載不可" 
,  "二次元裏転載可" 
,  "艦これ" 
,  "ソニー" 
, "虹裏dec" 
, "雑談" 
, "虹裏img" 
,  "IPv6" 
,  "てすと@jun" 
,  "ゲーム" 
,  "二次元グロ裏" 
, "虹裏jun" 
,  "麻雀" 
,  "うま" 
,  "ねこ" 
,  "軍裏" 
,  "東方" 
, "虹裏may" 
,  "二次元ID" 
,  "ネトゲ" 
,  "なりきり" 
,  "政治" 
,  "経済" 
,  "自転車" 
, "落書き" 
, "模型裏" 
, "野球" 
,  "自作絵" 
,  "サッカー" 
,  "自作絵裏" 
,  "ばら" 
, "ろぼ" 
, "自作PC" 
,  "女装" 
, "えろげ" 
, "ニュース表" 
, "ゆり" 
, "やおい" 
, "お絵かき" 
, "しょくぶつ" 
 );

require_once 'phplib/naivebayes.php';
$bayes = new NaiveBayes(); 
foreach($metaInfoList as $meta) {
  foreach($meta["tags"] as $tag) {
    if(!in_array($tag[0],$boardnames)){
      echo $meta['url'] . " tag " . $tag[0]. "\n";
      $bayes->train($tag[0],$meta["res"]);
    }
  }
}

