<?php

function find_files($rootdir) {
  $rootdir = rtrim($rootdir, "/");
  $files = array();
  //open dir
  if (is_dir($rootdir) && $dir = opendir($rootdir)){
    while ($fbase = readdir($dir)){
      $path = $rootdir . '/' . $fbase;
      if (is_file($path)){
        $files[] = $path;
      }else if($fbase != '.' && $fbase != '..' && is_dir($path)) {
        $files = array_merge($files, find_files($path));
      }
    }
    closedir($dir);
  }
  return $files;
}

/**
* This function creates recursive directories if it doesn't already exist
*
* @param String  The path that should be created
*
* @return  void
*/
function create_dirs($path)
{
  if (!is_dir($path))
  {
    $directory_path = "";
    $directories = explode("/",$path);
    array_pop($directories);

    foreach($directories as $directory)
    {
      $directory_path .= $directory."/";
      if (!is_dir($directory_path))
      {
        mkdir($directory_path);
        chmod($directory_path, 0777);
      }
    }
  }
}
