<?php

class KvsQdbm{
  var $dba;

  public static function enable(){
    return extension_loaded('dba') && in_array('qdbm', dba_handlers());
  }


  function __construct($mode,$dbpath){
    if(!is_file($dbpath)){
      $h = dba_open($dbpath, 'c', 'qdbm') or die("can't create file");
      dba_close($h);
    }
    $this->dba = dba_open($dbpath, $mode, 'qdbm') or die("can't open file");
  }

  function close(){
    dba_close($this->dba);
  }

  function optimize()
  {
    dba_optimize($this->dba);
  }

  function get($key,$default=false){
    $val = dba_fetch($key, $this->dba);
    if($val){
      return $val;
    }else{
      return $default;
    }
  }

  function set($key, $value){
    dba_replace($key, $value, $this->dba);
  }

  function del($key){
    dba_delete( $key, $this->dba);
  }

  function exists($key){
    return dba_exists( $key, $this->dba);
  }

  function allKeys(){
    $keys = array();
    for($k = dba_firstkey($this->dba); $k != false; $k = dba_nextkey($this->dba)){
      $keys[] = $k;
    }
    return $keys;
  }
}
