<?php

/**
 * metaファイル(スレッド情報)をQDBMを利用して格納する
 * sqlite3よりシンプルでランダムアクセス性能が稼ぎやすい
**/

//qdbmが利用出来るかの判断
function enable_qdbm(){
  return extension_loaded('dba') && in_array('qdbm', dba_handlers());
}

class DBA_qdbm{
  var $dba;

  //modeには'r'か'w'を指定
  function DBA_qdbm($mode,$dbpath){
    if(!is_file($dbpath)){
      $h = dba_open($dbpath, 'c', 'qdbm') or die("can't create file");
      dba_close($h);
    }
    $this->dba = dba_open($dbpath, $mode, 'qdbm') or die("can't open file");
  }

  function close(){
    dba_close($this->dba);
  }

  function optimize()
  {
    dba_optimize($this->dba);
  }

  function get($key){
    $val = dba_fetch($key, $this->dba);
    if($val){
      return ftb_unpack($val);
    }else{
      return false;
    }
  }

  function set($key, $value){
    dba_replace($key, ftb_pack($value), $this->dba);
  }

  function del($key){
    dba_delete( $key, $this->dba);
  }

  function exists($key){
    return dba_exists( $key, $this->dba);
  }

  function allKeys(){
    $keys = array();
    for($k = dba_firstkey($this->dba); $k != false; $k = dba_nextkey($this->dba)){
      $keys[] = $k;
    }
    return $keys;
  }

  function allValues()
  {
    $keys = $this->allKeys();

    $infos = array();
    $infosSort = array();

    foreach($keys as $key){
      $info = $this->get($key);
      //if(is_array($info) && array_key_exists("url",$info) && strlen($info["url"]) > 0) {
        $infos[] = $info;
        $infosSort[] = $info["date"];
      //}
    }
    array_multisort($infosSort, SORT_DESC, $infos);

    return $infos;
  }
}
