<?php

/*
 * メタデータの手動編集ページ
 *
 *
 *POST:
 * url    スレッドのURL
 * passwd 管理者パスワードのmd5値
 * newval 更新するメタデータのJSON値
 */


require_once 'config.php';
require_once 'phplib/session.php';
init_session();

require_once 'phplib/common.php';
require_once 'phplib/result.php';
require_once 'phplib/smarty/Smarty.class.php';


//----------------------------------
//query param

$GETURL=get_value($_REQUEST,"url");
$PASSWD=get_value($_REQUEST,"passwd");
$NEWVAL=get_value($_REQUEST,"newvals");

$meta = readUrlInfo($GETURL);

if( !$meta )
{
  echo errorPage("URLが不正です");
  return;
}

if( $PASSWD != readConfig("RMPASSWD") )
{
  echo errorPage("パスワードが不正です");
  return;
}

if($NEWVAL) {
  $newinfo = json_decode($NEWVAL, true);
  if( $newinfo ) {
    foreach($newinfo as $key => $val) {
      if(array_key_exists($key, $meta) ){
        $meta[$key] = $val; //値を更新
      }
    }
    
    //metaファイルの保存
    saveInfo($meta);
  }
}

//ページ生成
$smarty = new Smarty();

$smarty->assign('title', readConfig("TITLE"));
$smarty->assign('metainfo', json_encode( $meta ));
$smarty->assign('infotable',_echoResultTable($meta));

$smarty->assign('passwd',$PASSWD);
$smarty->assign('url',$GETURL);

$smarty->display('editmeta.tpl');


