<?php

require_once 'config.php';
require_once 'phplib/common.php';
require_once 'phplib/crawl.php';
require_once 'phplib/imgfinder.php';
require_once 'phplib/filehashing.php';
require_once 'phplib/cronlock.php';

//------------------------------------------------

$locker = new CronLock("cron_get");
if(!$locker->lock()){
  //ロック失敗 -> 前回実行分が動作中のためexit
  return ;
}

//metaファイル配下を参照し
//古いmetaファイルと関連するファイルを自動で削除する

//read metafile
$metaInfoList = array_reverse(readAllInfo ()) ;

//自動取得対象の板
$targetUrl = "/http:\/\/...\.2chan\.net\/(.*)\/res/i";    //全板対象
#$targetUrl = "/http:\/\/(may|img)\.2chan\.net\/b\/res/i";  //虹裏のみ

//get
foreach($metaInfoList as $info) {

  $basenames = urlToBasename($info["url"]);
  if(!$info['lost'] || $info['date']+60*3 > time()  ) {
    //内容取得を行う
    $lockpath = readConfig("LOCKDIR") . $basenames["LOCK"];
    //ロック処理(同一スレッドのダウンロードの排他)

    if($lock = fopen($lockpath, 'w')){
      if (flock($lock, LOCK_EX | LOCK_NB)){
        //ロックできた場合はダウンロードを行う。
        if ($info = execDownload($info["url"])) {
          //メタデータのセーブ
          saveInfo($info);

          //画像検索システムに登録
          imgfinder_update($info["url"]);
          //ファイルハッシュを登録
          filehash_update($info["url"]);
        }
        flock($lock, LOCK_UN);
      }
      fclose($lock);
    }
    echo $info["url"] . " ". $info["src1res_day"] ." <br>\r\n";
  }
}

//キャッシュ更新
removeJsonApiCache();
readAllInfoCached();

function cleanOldfiles($rootdir) {
  if ($dir = opendir($rootdir)){
    while ($fbase = readdir($dir)){
      if($fbase != '.' && $fbase != '..') {
        $path = $rootdir . $fbase;
        if( is_file($path) && filemtime($path) + 48*60*60 < time()){
          unlink( $path );
        }
      }
    }
    closedir($dir);
  }
}

//linkフォルダのゴミ削除
cleanOldfiles($ROOTDIR . "l/");

//lockフォルダのゴミ削除
cleanOldfiles($ROOTDIR . "lock/");


//-----------------------------------------
//meta フォルダの最適化
meta_optimize();
$locker->close();
