/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.ConsumingNHttpEntity;
import org.apache.http.nio.entity.ContentInputStream;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.SimpleInputBuffer;

public class BufferingNHttpEntity
extends HttpEntityWrapper
implements ConsumingNHttpEntity {
    private static final int BUFFER_SIZE = 2048;
    private final SimpleInputBuffer buffer;
    private boolean finished;
    private boolean consumed;

    public BufferingNHttpEntity(HttpEntity httpEntity, ByteBufferAllocator allocator) {
        super(httpEntity);
        this.buffer = new SimpleInputBuffer(2048, allocator);
    }

    public void consumeContent(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        this.buffer.consumeContent(decoder);
        if (decoder.isCompleted()) {
            this.finished = true;
        }
    }

    public void finish() {
        this.finished = true;
    }

    public void consumeContent() throws IOException {
    }

    public InputStream getContent() throws IOException {
        if (!this.finished) {
            throw new IllegalStateException("Entity content has not been fully received");
        }
        if (this.consumed) {
            throw new IllegalStateException("Entity content has been consumed");
        }
        this.consumed = true;
        return new ContentInputStream(this.buffer);
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isStreaming() {
        return true;
    }

    public void writeTo(OutputStream outstream) throws IOException {
        int l;
        if (outstream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        InputStream instream = this.getContent();
        byte[] buffer = new byte[2048];
        while ((l = instream.read(buffer)) != -1) {
            outstream.write(buffer, 0, l);
        }
    }
}

