/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.rsr.helpers;

import java.io.IOException;
import java.io.OutputStream;
import jp.cssj.rsr.RandomBuilder;

public class RandomBuilderOutputStream
extends OutputStream {
    private final RandomBuilder builder;
    private final int fragmentId;
    private final byte[] buff = new byte[1];

    public RandomBuilderOutputStream(RandomBuilder builder, int fragmentId) {
        if (builder == null) {
            throw new NullPointerException();
        }
        this.builder = builder;
        this.fragmentId = fragmentId;
    }

    public void write(int b) throws IOException {
        this.buff[0] = (byte)b;
        this.builder.write(this.fragmentId, this.buff, 0, 1);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.builder.write(this.fragmentId, b, off, len);
    }

    public void write(byte[] b) throws IOException {
        this.builder.write(this.fragmentId, b, 0, b.length);
    }

    public void close() throws IOException {
        this.builder.closeBlock(this.fragmentId);
    }
}

