/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.driver.ctip.common;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public final class TcpUtils {
    private TcpUtils() {
    }

    public static byte readByte(ReadableByteChannel channel, ByteBuffer destByte) throws IOException {
        TcpUtils.readAll(channel, destByte);
        return destByte.get(0);
    }

    public static short readShort(ReadableByteChannel channel, ByteBuffer destShort) throws IOException {
        TcpUtils.readAll(channel, destShort);
        return destShort.getShort(0);
    }

    public static int readInt(ReadableByteChannel channel, ByteBuffer destInt) throws IOException {
        TcpUtils.readAll(channel, destInt);
        return destInt.getInt(0);
    }

    public static long readLong(ReadableByteChannel channel, ByteBuffer destLong) throws IOException {
        TcpUtils.readAll(channel, destLong);
        return destLong.getLong(0);
    }

    public static String readString(ReadableByteChannel channel, ByteBuffer destShort, String encoding) throws IOException {
        short len = TcpUtils.readShort(channel, destShort);
        if (len == 0) {
            return "";
        }
        byte[] buff = TcpUtils.readBytes(channel, len);
        return new String(buff, encoding);
    }

    public static byte[] readBytes(ReadableByteChannel channel, int len) throws IOException {
        byte[] buff = new byte[len];
        ByteBuffer dest = ByteBuffer.wrap(buff);
        TcpUtils.readAll(channel, dest);
        return buff;
    }

    public static void readAll(ReadableByteChannel channel, ByteBuffer dest) throws IOException {
        dest.position(0);
        do {
            if (channel.read(dest) != -1) continue;
            throw new EOFException();
        } while (dest.remaining() > 0);
    }

    public static void writeAll(WritableByteChannel channel, ByteBuffer src) throws IOException {
        src.position(0);
        do {
            channel.write(src);
        } while (src.remaining() > 0);
    }

    public static byte[] toBytes(String str, String encoding) throws IOException {
        if (str == null) {
            str = "";
        }
        return str.getBytes(encoding);
    }
}

