/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.sakae.opentype.truetype;

import java.io.IOException;
import java.io.RandomAccessFile;
import jp.cssj.sakae.opentype.table.GlyfTable;
import jp.cssj.sakae.opentype.truetype.GlyfDescript;

public class GlyfSimpleDescript
extends GlyfDescript {
    private int[] endPtsOfContours;
    private byte[] flags;
    private short[] xCoordinates;
    private short[] yCoordinates;
    private int count;

    public GlyfSimpleDescript(GlyfTable parentTable, int numberOfContours, RandomAccessFile raf) throws IOException {
        super(parentTable, numberOfContours, raf);
        this.endPtsOfContours = new int[numberOfContours];
        for (int i = 0; i < numberOfContours; ++i) {
            this.endPtsOfContours[i] = raf.read() << 8 | raf.read();
        }
        this.count = this.endPtsOfContours[numberOfContours - 1] + 1;
        this.flags = new byte[this.count];
        this.xCoordinates = new short[this.count];
        this.yCoordinates = new short[this.count];
        int instructionCount = raf.read() << 8 | raf.read();
        this.readInstructions(raf, instructionCount);
        this.readFlags(this.count, raf);
        this.readCoords(this.count, raf);
    }

    public int getEndPtOfContours(int i) {
        return this.endPtsOfContours[i];
    }

    public byte getFlags(int i) {
        return this.flags[i];
    }

    public short getXCoordinate(int i) {
        return this.xCoordinates[i];
    }

    public short getYCoordinate(int i) {
        return this.yCoordinates[i];
    }

    public boolean isComposite() {
        return false;
    }

    public int getPointCount() {
        return this.count;
    }

    public int getContourCount() {
        return this.getNumberOfContours();
    }

    private void readCoords(int count, RandomAccessFile raf) throws IOException {
        int i;
        short x = 0;
        short y = 0;
        for (i = 0; i < count; ++i) {
            if ((this.flags[i] & 0x10) != 0) {
                if ((this.flags[i] & 2) != 0) {
                    x = (short)(x + (short)raf.read());
                }
            } else {
                x = (this.flags[i] & 2) != 0 ? (short)(x + (short)(-((short)raf.read()))) : (short)(x + (short)(raf.read() << 8 | raf.read()));
            }
            this.xCoordinates[i] = x;
        }
        for (i = 0; i < count; ++i) {
            if ((this.flags[i] & 0x20) != 0) {
                if ((this.flags[i] & 4) != 0) {
                    y = (short)(y + (short)raf.read());
                }
            } else {
                y = (this.flags[i] & 4) != 0 ? (short)(y + (short)(-((short)raf.read()))) : (short)(y + (short)(raf.read() << 8 | raf.read()));
            }
            this.yCoordinates[i] = y;
        }
    }

    private void readFlags(int flagCount, RandomAccessFile raf) throws IOException {
        try {
            for (int index = 0; index < flagCount; ++index) {
                this.flags[index] = (byte)raf.read();
                if ((this.flags[index] & 8) == 0) continue;
                int repeats = raf.read();
                for (int i = 1; i <= repeats; ++i) {
                    this.flags[index + i] = this.flags[index];
                }
                index += repeats;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("error: array index out of bounds");
        }
    }
}

