/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.sakae.opentype.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import jp.cssj.sakae.opentype.table.DirectoryEntry;
import jp.cssj.sakae.opentype.table.NameRecord;
import jp.cssj.sakae.opentype.table.Table;

public class NameTable
implements Table {
    private short numberOfNameRecords;
    private short stringStorageOffset;
    private NameRecord[] records;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NameTable(DirectoryEntry de, RandomAccessFile raf) throws IOException {
        RandomAccessFile randomAccessFile = raf;
        synchronized (randomAccessFile) {
            int i;
            raf.seek(de.getOffset());
            raf.readShort();
            this.numberOfNameRecords = raf.readShort();
            this.stringStorageOffset = raf.readShort();
            this.records = new NameRecord[this.numberOfNameRecords];
            for (i = 0; i < this.numberOfNameRecords; ++i) {
                this.records[i] = new NameRecord(raf);
            }
            for (i = 0; i < this.numberOfNameRecords; ++i) {
                this.records[i].loadString(raf, de.getOffset() + this.stringStorageOffset);
            }
        }
    }

    public String getRecord(short nameId) {
        for (int i = 0; i < this.numberOfNameRecords; ++i) {
            if (this.records[i].getNameId() != nameId) continue;
            return this.records[i].getRecordString();
        }
        return "";
    }

    public int getType() {
        return 1851878757;
    }

    public NameRecord get(int i) {
        return this.records[i];
    }

    public int size() {
        return this.numberOfNameRecords;
    }
}

