/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.sakae.opentype.cff;

import java.lang.ref.SoftReference;
import jp.cssj.sakae.opentype.Glyph;
import jp.cssj.sakae.opentype.GlyphList;
import jp.cssj.sakae.opentype.cff.CffTable;
import jp.cssj.sakae.opentype.table.HeadTable;
import jp.cssj.sakae.opentype.table.MaxpTable;

public class CffGlyphList
implements GlyphList {
    private final CffTable cff;
    private final HeadTable head;
    private SoftReference[] glyphs;

    public CffGlyphList(CffTable cff, HeadTable head, MaxpTable maxp) {
        this.cff = cff;
        this.head = head;
        this.glyphs = new SoftReference[maxp.getNumGlyphs()];
    }

    public synchronized Glyph getGlyph(int ix) {
        Glyph glyph;
        if (ix >= this.glyphs.length) {
            return null;
        }
        Glyph glyph2 = glyph = this.glyphs[ix] == null ? null : (Glyph)this.glyphs[ix].get();
        if (glyph == null) {
            short upm = this.head.getUnitsPerEm();
            glyph = this.cff.getGlyph(ix, upm);
            this.glyphs[ix] = new SoftReference<Glyph>(glyph);
        }
        return glyph;
    }
}

