<?php
//
// CSSJ plugin

// Returns PDF page.
require_once ('cssj/cssj_driver.php');

function plugin_cssj_inline()
{
    global $script, $vars;

    $args = func_get_args();
    $count = count($args);
    $href = "$script?plugin=cssj";
    $pages = array();
    if ($count > 2) {
        for ($i = 1; $i < $count - 1; ++$i) {
            $pages[] = $args[$i];
        }
    }
    else {
        $content = $vars['page'];
        $pages[] = $content;
    }
    if (!empty($pages)) {
        $href .= '&pages='.urlencode(implode(',', $pages));
    }
    if ($count > 1) {
        $content = $args[0];
        $href .= '&title='.urlencode($content);
    }
    $content = $args[$count - 1] ? $args[$count - 1] : $content;

    return "<a class=\"cssj-pdflink\" href=\"$href\">$content</a>";
}

function plugin_cssj_action()
{
    global $vars, $_source_messages, $script;

    $host = '127.0.0.1';  // Copper PDF СΥۥ̾
    $port = 8099;         // Copper PDF СΥݡֹ
    $user = 'user';       // 桼
    $password = 'kappa';  // ѥ
    $source = false;      // HTMLɽtrue(ǥХå)
    $cache = true;        // åon/off

    // ڡΥ١URL
    $base = $script;

    // ʤɤΥ꥽ؤΥϰ
    $resource = substr($base, 0, strrpos($base, '/')).'/**';

    // 饯󥳡ǥ
    $charset = "EUC-JP";

    if (PKWK_SAFE_MODE) die_message('PKWK_SAFE_MODE prohibits this');

    // оݥڡ
    if (isset($vars['pages'])) {
        $pages = explode(',', $vars['pages']);
    }
    else {
        $pages = array($vars['page']);
    }

    // ʸΥȥ
    $title = isset($vars['title']) ? $vars['title'] : $pages[0];

    // åΥȹ
    $key = '';
    $time = 0;
    foreach($pages as $page) {
        $key .= $page;
        $time = max($time, get_filetime($page));
    }
    $key = encode(md5($key));

    pkwk_common_headers();
    if (!$source) {
        $filename = CACHE_DIR.$key.'.pdf';
        if ($cache && filemtime($filename) == $time) {
            header("Content-Type: application/pdf");
            header("Content-Length: ".filesize($filename));
            header("Content-Disposition: inline; filename=\"".$pages[0].".pdf\"");
            readfile($filename);
            exit;
        }

        $driver = cssj_create_driver_for($host, $port);
        $session = cssj_create_session($driver, $user, $password) or die('С³Ǥޤ');
        
        $fd = fopen($filename, 'w');
        cssj_set_output($session, $fd, 'application/pdf');
        cssj_set_property($session, 'output.pdf.bookmarks', 'true');
        cssj_set_property($session, 'output.pdf.hyperlinks', 'true');
        cssj_set_property($session, 'processing.page-references', 'true');
        cssj_set_property($session, 'processing.pass-count', '2');
        
        cssj_include_resource($session, $resource);
        
        cssj_ob_start_main($session, $base, 'text/html', $charset);
    }

    print <<<EOD
<html>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=$charset">
    <title>$title</title>
    <link rel="StyleSheet" type="text/css" href="skin/cssj.css">
  </head>
  <body>
<h1>$title</h1>
<div class="toc"
     xmlns:cssj="http://www.cssj.jp/ns/cssjml">
  <div class="title">ܼ</div>
  <span id="toc-page-number"></span>
  <cssj:toc offset="2"/>
  <cssj:make-toc counter="page2"/>
</div>
<div class="body">
EOD;
    foreach ($pages as $page) {
        _cssj_send_page($page);
    }
    print <<<EOD
</div>
  </body>
</html>
EOD;

    if (!$source) {
        cssj_ob_end_flush_main();
        cssj_close($session);
        fclose($fd);
        touch($filename, $time);

        header("Content-Type: application/pdf");
        header("Content-Disposition: inline; filename=\"".$pages[0].".pdf\"");
        header("Content-Length: ".filesize($filename));
        readfile($filename);
    }

    exit;
}

function _cssj_send_page($page)
{
    if (!is_page($page) || !check_readable($page, false, false)) {
        return;
    }
    $vars['refer'] = $page;
    print "<div class=\"content\"><span id=\"page-number\"></span>";
    print convert_html(get_source($page));
    print "</div>";
}
?>
