<?php
/*
 * $RCSfile: note.js.inc,v $
 * $Date: 2005/07/04 12:48:44 $
 * $Author: die $
 * 
 * Ф Ρ 饤¦ץ
 * 
 * Copyright (c) 2005 die kato
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

	global $conf;

	if (isset($_REQUEST['page']) && strlen($_REQUEST['page']) > 0) {
		$page = htmlspecialchars($_REQUEST['page']);
	}
?>
	/*
	 * Ρ
	 */
	b.Note = function() {
		/*
		 * 
		 */
		this.initialize = function() {
			this.openedNote = b.element('openedNote');
			this.closedNote = b.element('closedNote');
			this.tool = b.element('tool');
			this.page = b.element('page');
			this.pageDateHolder = b.element('pageDateHolder');
			this.pageTitleHolder = b.element('pageTitleHolder');
			this.pageImageHolder = b.element('pageImageHolder');
			this.latestIcon = b.element('latest');
			this.nextIcon = b.element('next');
			this.earliestIcon = b.element('earliest');
			this.prevIcon = b.element('prev');
			this.pageNoLeft = b.element('pageNoLeft');
			this.pageNoRight = b.element('pageNoRight');

			b.element('noteOpener').onclick = function() { b.plugins['note'].open(0); };
			b.element('noteCloser').onclick = function() { b.plugins['note'].close(); };
			b.element('save').onclick = function() { return b.plugins['note'].save(); };
			this.latestIcon.onclick = function() { b.plugins['note'].latest(); };
			this.nextIcon.onclick = function() { b.plugins['note'].next(); };
			this.prevIcon.onclick = function() { b.plugins['note'].prev(); };
			this.earliestIcon.onclick = function() { b.plugins['note'].earliest(); };

			this.indexPage = new this.IndexPage(this);

			this.createPages();

			if (location.hash == "#note") {
				var index = 0;
				<?php if (isset($page)) { ?>
					index = this.getIndexByDate("<?php echo $page ?>");
				<?php } ?>
				this.open(index);
			} else {
				this.close();
			}
		}
	
		/*
		 * ڡ
		 */
		this.createPages = function() {
			this.pages = new Array();
			var s = b.element('pageIndex').innerHTML;
			var a1 = s.split('\n');
			for (var i in a1) {
				if (a1[i].match(/([^ ]*) (.*)/)) {
					this.pages.unshift(new this.Page(RegExp.$1, RegExp.$2));
				}
			}
		}
	
		/*
		 * ΡȤ򳫤
		 * index: ڡΥǥå
		 */
		this.open = function(index) {
			this.closedNote.style.display = 'none';
			this.openedNote.style.display = 'block';
			this.tool.style.display = 'block';
			this.load(index);
		}
	
		/*
		 * ΡȤĤ
		 */
		this.close = function() {
			this.closedNote.style.display = 'block';
			this.openedNote.style.display = 'none';
			this.tool.style.display = 'none';
			if (location.hash != '') {
				location.hash = '';
			}
		}
	
		/*
		 * ڡ¸
		 */
		this.save = function() {
			var title = prompt('ʤޤĤƤ');
			if (title == null) {
				; // 󥻥
			} else if (title.length == 0) {
				alert('ʤޤʤ!');
			} else if (title.length > <?php echo $conf['page_title_max_length'] ?>) {
				alert('ʤޤʤ!');
			} else {
				b.element('pageTitle').value = title;
				var form = b.element('toolbox');
				form.action = location.pathname + '?' + (new Date().getTime()) + location.hash;
				return true;
			}
			return false;
		}
	
		/*
		 * ɽѤʸ
		 * date: ե֥
		 */
		this.getDateTimeString = function(date) {
			var s = "";
			s += date.getFullYear() + "ͤ";
			s += (date.getMonth() + 1) + "";
			s += date.getDate() + "ˤ ";
			s += date.getHours() + ":";
			s += date.getMinutes() + ":";
			s += date.getSeconds();
			return s;
		}
	
		/*
		 * ڡɤ
		 * index: ڡΥǥå
		 */
		this.load = function(index) {
			if (this.indexPage.isOpening) {
				this.indexPage.close();
			}
			var page = this.pages[index];
	
			// 
			var date = new Date();
			date.setTime(page.date * 1000); // PHPtime()ä֤JavaScriptϥߥäǰ
			this.pageDateHolder.innerHTML = this.getDateTimeString(date);
	
			// ȥ
			var permalink = location.pathname + "?page=" + page.date + "#note";
			this.pageTitleHolder.innerHTML = '<a href="' + permalink + '">' + page.title + '</a>';
	
			// ᡼
			this.pageImageHolder.src = '<?php echo $conf['data_dir'] . $conf['page_image_prefix'] ?>' + page.date + '<?php echo $conf['page_image_suffix'] ?>';
	
			// ڡֹ
			var pageTotal = this.pages.length;
			var pageNo = pageTotal - index;
			this.pageNoLeft.innerHTML = '' + (pageNo * 2 - 1) + ' / ' + (pageTotal * 2);
			this.pageNoRight.innerHTML = '' + (pageNo * 2) + ' / ' + (pageTotal * 2);;
	
			this.iconState(index);
			this.currentIndex = index;
	
		}
	
		/*
		 * Υڡɽ
		 */
		this.prev = function() {
			this.load(this.currentIndex + 1);
		}
	
		/*
		 * Υڡɽ
		 */
		this.next = function() {
			this.load(this.currentIndex - 1);
		}
	
		/*
		 * ǸŤΥڡɽ
		 */
		this.earliest = function() {
			this.load(this.pages.length - 1);
		}
	
		/*
		 * ǿΥڡɽ
		 */
		this.latest = function() {
			this.load(0);
		}
	
		/*
		 * ξ֤ѹ
		 */
		this.iconState = function(index) {
			var isLatest = (index == 0);
			var isEarliest = (index == this.pages.length - 1);
	
			this.latestIcon.disabled = isLatest;
			this.nextIcon.disabled = isLatest;
			this.earliestIcon.disabled = isEarliest;
			this.prevIcon.disabled = isEarliest;
	
			var imageDir = 'plugins/note/images/';
			this.latestIcon.src = imageDir + (isLatest ? 'latestx.png' : 'latest.png'); 
			this.nextIcon.src = imageDir + (isLatest ? 'nextx.png' : 'next.png');
			this.earliestIcon.src = imageDir + (isEarliest ? 'earliestx.png' : 'earliest.png');
			this.prevIcon.src = imageDir + (isEarliest ? 'prevx.png' : 'prev.png');
		}
	
		/*
		 * դбڡΥǥå
		 * date: 
		 */
		this.getIndexByDate = function(date) {
			for (var i = 0; i < this.pages.length; i++) {
				if (this.pages[i].date == date) {
					return i;
				}
			}
			return 0;
		}

		/*
		 * ڡ
		 * date: 
		 * title: ȥʸ
		 */
		this.Page = function(date, title) {
			this.date = date;
			this.title = title;
		}

		/*
		 * ⤯ڡ
		 * note: Τ⤯ĥΡ 
		 */
		this.IndexPage = function(note) {
			this.ORDER_DESC = 0;
			this.ORDER_ASC = 1;
			var parent = note;
			var indexPage = this;

			/*
			 * 
			 */
			this.initialize = function() {
				this.searchPage = b.element('noteIndexSearchPage');
				this.listPage = b.element('noteIndexListPage');
				this.tab = b.element('noteIndexTab');
				this.entry = b.element('entry');
				this.tab.style.zIndex = 1;
				this.order = <?php echo $conf['note_index_default_order'] ?>;
				this.num = <?php echo $conf['note_index_default_num'] ?>;
				this.query = "<?php echo $conf['note_index_default_query'] ?>";
				this.tab.onclick = function() {
					indexPage.open();
				}
				this.shiori = b.element('shiori');
				this.shiori.onclick = function() {
					indexPage.close();
				}
				var desc = b.element('noteIndexOrderDesc');
				var asc = b.element('noteIndexOrderAsc');
				desc.onclick = function() {
					asc.checked = false;
					indexPage.setOrder(indexPage.ORDER_DESC);
				}
				asc.onclick = function() {
					desc.checked = false;
					indexPage.setOrder(indexPage.ORDER_ASC);
				}
				if (this.order == this.ORDER_DESC) {
					desc.checked = true;
				} else {
					asc.checked = true;
				}
				
				this.queryForm = b.element('noteIndexQuery');
				this.queryForm.onkeyup = function() {
					indexPage.setQuery(indexPage.queryForm.value);
				}
				this.queryForm.onchange = function() {
					indexPage.setQuery(indexPage.queryForm.value);
				}
				this.indexPages = b.element('noteIndexPages');
				this.isOpening = false;
			}
			/*
			 * ⤯򳫤
			 */
			this.open = function() {
				this.isOpening = true;
				this.currentPage = parent.currentIndex;
				this.searchPage.style.display = 'block';
				this.listPage.style.display = 'block';
				parent.tool.style.display = 'none';
				parent.pageImageHolder.src = "images/dummy.png";
				parent.pageDateHolder.innerHTML = "";
				parent.pageTitleHolder.innerHTML = '⤯';
				parent.pageNoLeft.innerHTML = "";
				parent.pageNoRight.innerHTML = "";
				this.tab.style.zIndex = 3;
				this.entry.style.zIndex = 1;
				this.shiori.style.display = 'block';
				if (this.pages == null) {
					this.createList();
				}
			}

			/*
			 * ⤯Ĥ
			 */
			this.close = function() {
				this.isOpening = false;
				this.searchPage.style.display = 'none';
				this.listPage.style.display = 'none';
				this.tab.style.zIndex = 1;
				this.entry.style.zIndex = 3;
				this.shiori.style.display = 'none';
				parent.load(this.currentPage);
				parent.tool.style.display = 'block';
			}

			/*
			 * ϰ֤
			 */
			this.setStart = function(n) {
				this.start = n;
				this.updateView();
			}

			/*
			 * ֤
			 */
			this.setOrder = function(order) {
				this.order = order;
				this.createList();
			}

			/*
			 * ʸ
			 */
			this.setQuery = function(query) {
				this.query = query;
				this.createList();
			}

			/*
			 * ⤯ꥹȤ
			 */
			this.createList = function() {
				this.pages = new Array();
				var query = this.query.toLowerCase();
				for (var i = 0; i < parent.pages.length; i++) {
					// ʸ󤬻ꤵƤ鸡
					if (query != "") {
						var title = parent.pages[i].title.toLowerCase();
						if (title.indexOf(query) == -1) {
							continue;
						}
					}
					// ɽ
					if (this.order == this.ORDER_DESC) {
						this.pages.push(parent.pages[i]);
					} else {
						this.pages.unshift(parent.pages[i]);
					}
				}
				this.setStart(<?php echo $conf['note_index_default_start'] ?>);
			}

			/*
			 * ɽ򹹿
			 */
			this.updateView = function() {
				var total = this.pages.length;
				// ɽ
				var num = this.num;
				if (this.start > total) {
					num = 0;
				} else if (this.start + num > total) {
					num = total - this.start;
				}
				// ꥹȤκ
				var s = "<dl>";
				for (var i = 0; i < num; i++) {
					var page = this.pages[i + this.start];
					var date = new Date();
					date.setTime(page.date * 1000);
					s += "<dt class='noteIndexDate'>" + parent.getDateTimeString(date) + "</dt>";
					s += "<dd><a href='#note' onclick='" + app + ".plugins[\"note\"].load(";
					s += app + ".plugins[\"note\"].getIndexByDate(\"" + page.date + "\"));return false;'>";
					s += page.title + "</a></dd>";
				}
				s += "</dl>";
				this.listPage.innerHTML = s;

				// ⤯ڡֹ󥯤κ
				var indexPages = Math.ceil(total / this.num);
				this.indexPages.innerHTML = "";
				if (indexPages > 1) {
					for (var i = 0; i < indexPages; i++) {
						if (this.start == (i * this.num)) {
							this.indexPages.innerHTML += ' ' + i + ' ';
						} else {
							this.indexPages.innerHTML += ' <a href="#note" onclick="' + app + '.plugins[\'note\'].indexPage.setStart(' + (i * this.num) + ')">' + i + '</a> ';
						}
					}
				}
			}

			this.initialize();
		}
	}
	b.plugins['note'] = new b.Note();

