#cs #INDEX# --------------------------------------------------------------------

 Title         : autest_xml_generator
 Author        : Takazumi Shirayanagi

 Copyright (C) 2013, Takazumi Shirayanagi
 The new BSD License is applied to this software.
 see LICENSE

#ce ----------------------------------------------------------------------------

#include-once

#cs #VARIABLE# -----------------------------------------------------------------
#ce ----------------------------------------------------------------------------

#cs #INCLUDE# ------------------------------------------------------------------
#ce ----------------------------------------------------------------------------

#cs #CURRENT# ------------------------------------------------------------------
 * @brief	Xml Gen FUNCTION
 * @public
 * Autest_DefaultXmlGenerator_OnTestProgramEnd
#ce ----------------------------------------------------------------------------

;
; Autest_DefaultXmlGenerator_OnTestProgramEnd
;
Func Autest_DefaultXmlGenerator_OnTestProgramEnd()
	Local $output = AutestOpt_GetOutput()
	IF StringLen($output) == 0 Then Return
	IF StringInStr($output, "xml") == 1 Then
		Local $split = StringSplit($output, ":", 2)
		Local $path = "testdefault.xml"
		IF UBound($split) == 2 Then
			$path = $split[1]
		EndIf
		Autest_DefaultXmlGenerator_OnReport($path)
	EndIf
EndFunc

#cs #INTERNAL_USE_ONLY# --------------------------------------------------------
 * @private
 * Autest_DefaultXmlGenerator_OnReport
 * Autest_DefaultXmlGenerator_OnReportTestCase
 * Autest_DefaultXmlGenerator_OnReportTestInfo
#ce ----------------------------------------------------------------------------

;
; Autest_DefaultXmlGenerator_OnReport
;
Func Autest_DefaultXmlGenerator_OnReport($path)
	Local $file = FileOpen($path, 2+8)
	IF $file == -1 Then
		Return False
	EndIf

	FileWrite($file, '<?xml version="1.0" encoding="UTF-8"?>' & @LF )
	Local $total_test_cout = Autest_GetTotalTestCount()
	Local $fatal_test_cout = Autest_GetFatalTestCount()
	FileWrite($file, '<testsuites tests="' & String($total_test_cout) & '" ')
	FileWrite($file, 'failures="' & String($fatal_test_cout) & '" disabled="0" errors="0" time="0" ')
	FileWrite($file, 'name="AllTests">' & @LF )

	Local $tests = Autest_GetTestCases()
	Local $elem = Autest_GetTestCaseCount()
	For $I=0 To $elem
		Autest_DefaultXmlGenerator_OnReportTestCase($file, $tests[$I])
	Next

	FileWrite($file, '</testsuites>' & @LF )

	FileClose($file)
	Return True
EndFunc

;
; Autest_DefaultXmlGenerator_OnReportTestCase
;
Func Autest_DefaultXmlGenerator_OnReportTestCase($file, $testcase)
	Local $name = DllStructGetData($testcase, "name")
	Local $total_test_cout = AutestTestCase_GetTotalTestCount($testcase)
	Local $fatal_test_cout = AutestTestCase_GetFatalTestCount($testcase)
	FileWrite($file, '  <testsuite name="' & Autest_EscapeXmlAttribute($name) & '" ')
	FileWrite($file, 'tests="' & String($total_test_cout) & '" ')
	FileWrite($file, 'failures="' & String($fatal_test_cout) & '" disabled="0" ')
	FileWrite($file, 'errors="0" time="' & Autest_FormatTimeInMillisecAsSecond(AutestTestCase_GetElapsedTime($testcase)) & '">' & @LF )

	Local $curr = DllStructGetData($testcase, "testinfo")
	Local $num = DllStructGetData($testcase, "num")-1
	For $I=0 To $num
		Autest_DefaultXmlGenerator_OnReportTestInfo($file, $name, $curr)
		$curr = Autest_GetNextTestInfo($curr)
	Next

	FileWrite($file, '  </testsuite>' & @LF )
EndFunc

;
; Autest_DefaultXmlGenerator_OnReportTestInfo
;
Func Autest_DefaultXmlGenerator_OnReportTestInfo($file, $testcase_name, $testinfo_ptr)
	Local $name = AutestTestInfo_GetName($testinfo_ptr)
	FileWrite($file, '    <testcase name="' & Autest_EscapeXmlAttribute($name) & '" ')
	FileWrite($file, 'status="run" ')
	FileWrite($file, 'time="' & Autest_FormatTimeInMillisecAsSecond(AutestTestInfo_GetElapsedTime($testinfo_ptr)) & '" ')
	FileWrite($file, 'classname="' & Autest_EscapeXmlAttribute($testcase_name) & '" ')

	Local $result =  AutestTestInfo_GetResult($testinfo_ptr)
	IF $result Then
		FileWrite($file, ' />' & @LF)
	Else
		FileWrite($file, ">" & @LF)
		Local $msg = String(AutestTestInfo_GetMessage($testinfo_ptr))
		FileWrite($file, '      <failure message="' & Autest_EscapeXmlAttribute($msg) & '" ')
		FileWrite($file, 'type="">' & @LF)
		FileWrite($file, '    </testcase>' & @LF)
	EndIf
EndFunc

;
; Autest_IsWhitespace
;
Func Autest_IsWhitespace($ch)
	IF $ch == 0x09 Then Return True
	IF $ch == 0x0A Then Return True
	IF $ch == 0x0D Then Return True
	Return False
EndFunc

;
; Autest_FormatTimeInMillisecAsSecond
;
Func Autest_FormatTimeInMillisecAsSecond($msec)
	Return String($msec / 1000.0)
EndFunc

;
; Autest_IsValidXmlCharacter
;
Func Autest_IsValidXmlCharacter($ch)
	IF Autest_IsWhitespace($ch) Then Return True
	IF $ch >= 0x20 Then Return True
	Return False
EndFunc

;
; Autest_EscapeXmlAttribute
;
Func Autest_EscapeXmlAttribute($string)
	Return Autest_EscapeXml($string, True)
EndFunc

;
; Autest_EscapeXmlText
;
Func Autest_EscapeXmlText($string)
	Return Autest_EscapeXml($string, False)
EndFunc

;
; Autest_EscapeXml
;
Func Autest_EscapeXml($string, $is_attr)
	Local $str = $string
	$str = StringReplace($str, "<", "&lt;")
	$str = StringReplace($str, ">", "&lt;")
	$str = StringReplace($str, "&", "&amp;")
	If $is_attr Then
		$str = StringReplace($str, "'", "&apos;")
		$str = StringReplace($str, '"', "&quot;")
		$str = StringReplace($str, String(0x09), "&#x09;")
		$str = StringReplace($str, String(0x0A), "&#x0A;")
		$str = StringReplace($str, String(0x0D), "&#x0D;")
	EndIf
	Return $str
EndFunc
