#cs #INDEX# --------------------------------------------------------------------

 Title         : autest
 AuTest Version: 0.99.7
 Author        : Takazumi Shirayanagi

 Copyright (C) 2012-2013, Takazumi Shirayanagi
 The new BSD License is applied to this software.
 see LICENSE

#ce ----------------------------------------------------------------------------

#include-once

#cs #VARIABLE# -----------------------------------------------------------------
#ce ----------------------------------------------------------------------------

; Version
Global $AUTEST_VERSION = "0.9.7"

#cs #INCLUDE# ------------------------------------------------------------------
#ce ----------------------------------------------------------------------------
#include "autest_option.au3"
#include "autest_console.au3"
#include "autest_result.au3"
#include "autest_testcase.au3"
#include "autest_assertion.au3"
#include "autest_listener.au3"

#cs #CURRENT# ------------------------------------------------------------------
 * @brief	ASSETION FUNCTION
 * @public
 * Autest_RunAll
 * Autest_GetTotalTestCount
 * Autest_GetFatalTestCount
 * AUTEST_TEST
 * AUTEST_TEST_END
#ce ----------------------------------------------------------------------------

;
; Autest_RunAll
;
Func Autest_RunAll()
	Autest_ParseCommandLine()
	;Local $tests = Autest_GetTests()
	Local $tests = Autest_GetTestCases()
	Local $elem = Autest_GetTestCaseCount()
	For $I=0 To $elem
		;Autest_RunTest($tests[$I])
		Autest_RunTestCase($tests[$I])
	Next
	Autest_OnTestProgramEnd()
	Return Autest_GetResult()
EndFunc

;
; Autest_GetTotalTestCount
;
Func Autest_GetTotalTestCount()
	Local $count = 0
	Local $tests = Autest_GetTestCases()
	Local $elem = Autest_GetTestCaseCount()
	For $I=0 To $elem
		$count += AutestTestCase_GetTotalTestCount($tests[$I])
	Next
	Return $count
EndFunc

;
; Autest_GetFatalTestCount
;
Func Autest_GetFatalTestCount()
	Local $count = 0
	Local $tests = Autest_GetTestCases()
	Local $elem = Autest_GetTestCaseCount()
	For $I=0 To $elem
		$count += AutestTestCase_GetFatalTestCount($tests[$I])
	Next
	Return $count
EndFunc

;
; AUTEST_TEST
; Dummy Function
;
Func AUTEST_TEST($testcase, $testname)
EndFunc

;
; AUTEST_TEST_END
; Dummy Function
;
Func AUTEST_TEST_END()
EndFunc

#cs #INTERNAL_USE_ONLY# --------------------------------------------------------
 * @private
 * Autest_ParseCommandLine
 * Autest_ParseCommandLineElem
#ce ----------------------------------------------------------------------------

;
; Autest_ParseCommandLine
;
Func Autest_ParseCommandLine()
	IF $CmdLine[0] > 0 Then
		For $I=0 To $CmdLine[0]
			Autest_ParseCommandLineElem($CmdLine[$I])
		Next
	EndIf
EndFunc

;
; Autest_ParseCommandLineElem
;
Func Autest_ParseCommandLineElem($option)
	IF StringInStr($option, "--autest_") == 1 Then
		Local $str = StringMid($option, 3)
		Local $arg = StringSplit($str,"=", 2)
		IF UBound($arg) == 2 Then
			IF StringCompare($arg[0], "autest_filter") == 0 Then
				AutestOpt_SetFilter($arg[1])
			ElseIf StringCompare($arg[0], "autest_output") == 0 Then
				AutestOpt_SetOutput($arg[1])
			Else
				AutestOpt_SetShowHelp(True)
			EndIf
		Else
			AutestOpt_SetShowHelp(True)
		EndIf
	EndIf
EndFunc

