package org.jpn.xucker.rcp.subplayer.views;


import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.util.StatusLineContributionItem;
import org.eclipse.ui.part.ViewPart;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.betwixt.io.BeanWriter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.commons.audio.AudioListener;
import org.jpn.xucker.commons.audio.AudioStopper;
import org.jpn.xucker.commons.audio.JavaSoundAudioPlayer;
import org.jpn.xucker.commons.audio.WaveUtils;
import org.jpn.xucker.commons.io.PathnameUtils;
import org.jpn.xucker.mp3.JavaLayerMP3Player;
import org.jpn.xucker.mp3.MP3Utils;
import org.jpn.xucker.rcp.draw2d.AlphaLayerFigure;
import org.jpn.xucker.rcp.draw2d.AlphaUtils;
import org.jpn.xucker.rcp.draw2d.DoubleScalableFigure;
import org.jpn.xucker.rcp.draw2d.FileImageCache;
import org.jpn.xucker.rcp.draw2d.WaveFormFigureCanvas;
import org.jpn.xucker.rcp.draw2d.WaveFormListener;
import org.jpn.xucker.rcp.draw2d.WrapTextPainter;
import org.jpn.xucker.rcp.subplayer.MultiTimeAudioListener;
import org.jpn.xucker.rcp.subplayer.MultiTimeAudioPlayer;
import org.jpn.xucker.rcp.subplayer.PlayPatternComposite;
import org.jpn.xucker.rcp.subplayer.SubplayerPlugin;
import org.jpn.xucker.rcp.subplayer.TextAndImageFigure;
import org.jpn.xucker.rcp.subplayer.TimeBaseFileObjectReadUtils;
import org.jpn.xucker.rcp.subplayer.TimeBaseFileUpdater;
import org.jpn.xucker.rcp.subplayer.TimeBaseFileWindow;
import org.jpn.xucker.rcp.subplayer.label.LabelControler;
import org.jpn.xucker.rcp.subplayer.label.LabelMoveComposite;
import org.jpn.xucker.rcp.subplayer.preferences.LabelPage;
import org.jpn.xucker.rcp.subplayer.preferences.SubPlayPage;
import org.jpn.xucker.rcp.subplayer.preferences.SubViewPage;
import org.jpn.xucker.rcp.ui.FileDialogBuilder;
import org.jpn.xucker.rcp.ui.RCPFileApplication;
import org.jpn.xucker.subtitle.ParameterObject;
import org.jpn.xucker.subtitle.StandardSubObject;
import org.jpn.xucker.subtitle.SubUtils;
import org.jpn.xucker.subtitle.TimeBaseFileObject;
import org.jpn.xucker.subtitle.TimeParameterObject;
import org.xml.sax.SAXException;

import java.beans.IntrospectionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;


/**
 * [bug]no more handle ---@ACe炷?
 * [todo]ǂݍ݂ɎԂ g`͒xǂݍ?́AIvVŃItɂłB
 * [bug]figureƃnhG[?
 */

public class SubView extends ViewPart {
    public static final String ID=SubView.class.getName();
    public static Log log=LogFactory.getLog(SubView.class);
    
    
    private SubApplication subApplication;
    
    private Shell editShell;
    
    private StandardSubObject currentStandardSubObject;
    
    MultiTimeAudioPlayer multiTimeAudioPlayer;
	/**
	 * The constructor.
	 */
	public SubView() {
	    FileDialogBuilder builder=new FileDialogBuilder();
        builder.setCreateAny(true);
        String xmlName="Subplayer-XML Files";
        builder.add(xmlName,new String[]{"xml"});
        builder.add("Audio Files","MP3 Files",new String[]{"mp3"});
        builder.add("Audio Files","Wave Files",new String[]{"wav"});
        
	    subApplication=new SubApplication();
	    subApplication.setOpenFilterExtensions(builder.getFilterExtentions(xmlName));
	    subApplication.setOpenFilterNames(builder.getFilterNames(xmlName));
	    
	    
	    FileDialogBuilder saveBuilder=new FileDialogBuilder();
	    saveBuilder.setCreateAll(false);
        
	    saveBuilder.add(xmlName,new String[]{"xml"});
        subApplication.setSaveFilterExtensions(saveBuilder.getFilterExtentions(null));
	    subApplication.setSaveFilterNames(saveBuilder.getFilterNames(null));
        
	}
	
	private TimeBaseFileObject timeBaseFileObject;
	
	
	private FileImageCache imageCache=new FileImageCache();
	
	private CenterImageFigure ci;
	public class SubApplication extends RCPFileApplication{

        /* (non-Javadoc)
         * @see org.jpn.xucker.commons.util.AbstractBasicFileApplication#execOpen()
         */
        protected void execOpen() {
            initData();
    	    TimeBaseFileObject data=null;
    	    log.trace("read-data:"+getFile());
            data=TimeBaseFileObjectReadUtils.read(getFile());
    	    if(data==null){
    	        //wrong xml?
    	        log.info("invalid data:"+getFile());
    	        audioFile=null;
    	    }else{
    	        try {
                    setData(getFile(),data);
                } catch (UnsupportedAudioFileException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                } catch (IOException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
    	    }
    	    
    	    if(TimeBaseFileObjectReadUtils.checkType(getFile())==TimeBaseFileObjectReadUtils.SUBPLAY_FILE_OBJECT){
    	    //need save file.
    	    setFile(null);
    	    //setNeedSave(true); //for instant play.
    	    }
    	    
    	    saveStatusChanged();
        }

        
        public void toLoadRelativePath(File base,TimeBaseFileObject timeBaseFileObject){
            String baseDir=base.getParent();
            ParameterObject params[]=timeBaseFileObject.getParameters();
    	    for (int i = 0; i < params.length; i++) {
                if(params[i].getName().equals("file")
                        ){
                    String old=params[i].getValue();
                    String newValue=PathnameUtils.getRemainPath(baseDir,params[i].getValue());
                    if(!old.equals(newValue)){
                        log.info("oldValue="+old+",newValue="+newValue);
                        changeTimeParam(timeBaseFileObject,old,newValue);
                        params[i].setValue(newValue);
                        
                    }
                   }
            }
        }
        
        /**
         * @param old
         * @param newValue
         */
        private void changeTimeParam(TimeBaseFileObject timeBaseFileObject,String old, String newValue) {
            TimeParameterObject[] times=timeBaseFileObject.getTimeParameters();
            for (int i = 0; i < times.length; i++) {
                if(times[i].getName().equals(old)){
                    times[i].setName(newValue);
                }
            }
            
        }


        /* (non-Javadoc)
         * @see org.jpn.xucker.commons.util.AbstractBasicFileApplication#execSave()
         */
        protected void execSave() {
            log.info("dosave");
            toLoadRelativePath(getFile(),timeBaseFileObject);
            
            BeanWriter writer;
            try {
                writer = new BeanWriter(new FileWriter(getFile()));
                writer
                .writeXmlDeclaration("<?xml version=\"1.0\" encoding=\"Shift_JIS\"?>");
        writer.write(timeBaseFileObject);
        writer.close();
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            } catch (SAXException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            } catch (IntrospectionException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
          
            
        }

        /* (non-Javadoc)
         * @see org.jpn.xucker.commons.util.AbstractBasicFileApplication#saveStatusChanged()
         */
        protected void saveStatusChanged() {
          
           String title;
           if(getFile()==null){
               title="Untitled";
           }else{
               title=getFile().getName();
           }
           if(isNeedSave()){
               title="*"+title;
           }
           log.info("saveStatusChanged:"+title);
           getFileInfoStatusLine().setText(title);
        }

        /* (non-Javadoc)
         * @see org.jpn.xucker.commons.util.AbstractBasicFileApplication#execNew()
         */
        protected void execNew() {
           
            //never called.
        }
        
        protected void execOpenSubFile(File file){
            initData();
    	    TimeBaseFileObject data=null;
            if(TimeBaseFileObjectReadUtils.isWavFile(file.getName())){
    	        //add wav & sub
    	        data=new TimeBaseFileObject();
    	        data.addParameter(new ParameterObject("file",file.getAbsolutePath()));
    	        
    	        File srtFile=new File(file.getParentFile(),TimeBaseFileObjectReadUtils.changeExtentionName(file.getName(),"srt"));
    	        if(srtFile.exists()){
    	            data.addParameter(new ParameterObject("file",srtFile.getAbsolutePath()));
    	        }
    	        
    	    }else if(TimeBaseFileObjectReadUtils.isMP3File(file.getName())){
    	        data=new TimeBaseFileObject();
    	        data.addParameter(new ParameterObject("file",file.getAbsolutePath()));
    	        
    	        File srtFile=new File(file.getParentFile(),TimeBaseFileObjectReadUtils.changeExtentionName(file.getName(),"srt"));
    	        if(srtFile.exists()){
    	            data.addParameter(new ParameterObject("file",srtFile.getAbsolutePath()));
    	        }
    	    }
    	    
            if(data!=null){
    	        try {
                    setData(null,data);
                } catch (UnsupportedAudioFileException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                } catch (IOException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
    	    }
            
    	    setFile(null);//need save file.
//    	  setNeedSave(true); //for instant play.
    	    
    	    saveStatusChanged();
        }

        protected boolean isStandardFile(File file){
            return TimeBaseFileObjectReadUtils.isXMLFile(file.getName());
        }
        
	    
	}
	
	/*
	public void load(File file){
	    initData();
	    TimeBaseFileObject data=null;
	    if(TimeBaseFileObjectReadUtils.isXMLFile(file.getName())){
	        data=TimeBaseFileObjectReadUtils.read(file);
	    if(currentTimeBaseFile==null){
	        //wrong xml?
	        
	    }else{
	        
	        //read Wave
	        //read Sub
	    }
	    }else if(TimeBaseFileObjectReadUtils.isWavFile(file.getName())){
	        //add wav & sub
	        data=new TimeBaseFileObject();
	        data.addParameter(new ParameterObject("file",file.getAbsolutePath()));
	        
	        File srtFile=new File(file.getParentFile(),TimeBaseFileObjectReadUtils.changeExtentionName(file.getName(),"srt"));
	        if(srtFile.exists()){
	            data.addParameter(new ParameterObject("file",srtFile.getAbsolutePath()));
	        }
	        
	    }else if(TimeBaseFileObjectReadUtils.isMP3File(file.getName())){
	        //add wav & sub
	    }
	    
	    
	}*/
	
	
	public class LoadWave extends Thread{
	    private AudioInputStream audioInputStream;
	    private File targetAudioFile;
	    public LoadWave(AudioInputStream audioInputStream,File targetAudioFile){
	        this.audioInputStream=audioInputStream;
	       this.targetAudioFile=targetAudioFile;
	    }
	    
	    public void run(){
	        List byteList=waveFormFigureCanvas.loadByteList(audioInputStream);
	        if(audioFile!=null && audioFile.getAbsolutePath().equals(audioFile.getAbsolutePath())){
	            log.trace("setWaveFirugre:audio="+audioFile+",target="+targetAudioFile.getAbsolutePath());
		        
	            shell.getDisplay().asyncExec(new SetWaveFormFigure(byteList));
	        }
	    }
	}
	
	public class SetWaveFormFigure extends Thread{
	    List byteList;
	    public SetWaveFormFigure(List byteList){
	        this.byteList=byteList;
	    }
	    public void run(){
	        waveFormFigureCanvas.setByteData(byteList);
	    }
	}
	
	private void alertFileNotFound(String message){
	    MessageBox messageBox=new MessageBox(shell,SWT.OK);
	    messageBox.setText("File Not Found");
	    messageBox.setMessage("File Not Found\n"+message);
	    messageBox.open();
	    
	}
	
	private void cancelLoadWaveForm(){
	    //cancel loading
        if(waveFormFigureCanvas.getCanceller()!=null){
            waveFormFigureCanvas.getCanceller().setCanceld(true);
        }
        try {
            //wati cancel.TODO event
            Thread.sleep(200);
        } catch (InterruptedException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        
	}
	private void setData(File baseFile,TimeBaseFileObject data) throws UnsupportedAudioFileException, IOException{
	    timeBaseFileObject=data;
	    //set audio.
	    File audio=parseFirstAudioFile(baseFile,data);
	    if(audio!=null){
	        if(!audio.exists()){
	        alertFileNotFound(audio.getAbsolutePath());    
	        audioFile=null;
	        }else{
	            cancelLoadWaveForm();
	           
	            
	        audioFile=audio;
	       
	        log.info("load-audio:"+audioFile);
	        if(TimeBaseFileObjectReadUtils.isWavFile(audioFile.getName())){
	            waveFormFigureCanvas.loadEmpty(WaveUtils.
	    	            countAudioMillisecond(audioFile));
                  
	            
	        //waveFormFigureCanvas.loadWave(audioFile);
	        new LoadWave(AudioSystem.getAudioInputStream(audioFile),audioFile).start();
	        player=new JavaSoundAudioPlayer();//TODO remove.
	        }else if(TimeBaseFileObjectReadUtils.isMP3File(audioFile.getName())){
	            cancelLoadWaveForm();
	            try {
	                log.trace("load-mp3:"+audioFile);
	                
	                waveFormFigureCanvas.loadEmpty(MP3Utils.getAudioDurationTimeQuickly(audioFile));
	                //waveFormFigureCanvas.loadWave(MP3Utils.toPCMAudioInputStream(new FileInputStream(audioFile)));
	                new LoadWave(MP3Utils.toPCMAudioInputStream(new FileInputStream(audioFile)),audioFile).start();
	                player=new JavaLayerMP3Player();
	                
                } catch (FileNotFoundException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                } catch (UnsupportedAudioFileException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                } catch (IOException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
	        }
	    }
	    }else{
	        cancelLoadWaveForm();
	        waveFormFigureCanvas.loadEmpty(0);
	        
	    }
	   
	    setSubtitleData(baseFile,data);
	    waveFormFigureCanvas.getInFigure().setVisible(true);
	    lastset=System.currentTimeMillis();
	    //waveFormFigureCanvas.setSelectRealValue(100,200);//clear.
	}
	long lastset;
	public void setSubtitleData(File baseFile,TimeBaseFileObject data){
	    //remove sub.
	    for(int i=0;i<srtListFigures.length;i++){
	    srtListFigures[i].setStandardSubObjectList(null);
	    srtListFigures[i].rerect();
	    }
	    //set sub. //check color.
	    ParameterObject params[]=getSubtitleParameters(data);
	    
	    Map alreadyMap=new HashMap();
	    
	    for(int i=0;i<params.length;i++){
	        try {
	            String subfilePath=params[i].getValue();
                File subFile=toRelationPath(baseFile,subfilePath);
                if(!subFile.exists()){
                    alertFileNotFound(subFile.getAbsolutePath());
                }else{
                if(alreadyMap.get(subFile.getAbsolutePath())==null){//don't read same file.
                List subDataList=SubUtils.loadSub(subFile);
                loadLabel(subfilePath,subDataList,data.getTimeParameters());
                addSubs(subfilePath,i,subDataList);
                alreadyMap.put(subFile.getAbsolutePath(),"");
                }
                }
            } catch (IOException e) {
               
                e.printStackTrace();
            }
	    }
	}
	
	/**
     * @param subfilePath
     * @param subDataList
     * @param timeParameters
     */
    private void loadLabel(String subfilePath, List subDataList, TimeParameterObject[] timeParameters) {
        for(int i=0;i<timeParameters.length;i++){
            log.info(timeParameters[i]+","+subfilePath);
            if(timeParameters[i].getName().equals(subfilePath)){
                for(int j=0;j<subDataList.size();j++){
                    if(timeParameters[i].equalTime((StandardSubObject)subDataList.get(j))){
                        log.info("mutch:"+timeParameters[i]);
                        ((StandardSubObject)subDataList.get(j)).setOption(timeParameters[i].getValue());
                        break;
                    }
                }
            }
        }
    }

    public static ParameterObject[] getAudioParameters(TimeBaseFileObject data){
	    List subs=new ArrayList();
	    ParameterObject params[]=data.getParameters();
	    int index=0;
	    for(int i=0;i<params.length;i++){
	        if(params[i].getName().equals("file")){
	            log.trace("file:"+params[i].getValue());
	            if(TimeBaseFileObjectReadUtils.isAudioFile(params[i].getValue())){
	                subs.add(params[i]);
	                
	            }
	        }
	    }
	    return (ParameterObject[])subs.toArray(new ParameterObject[subs.size()]);
	}
	
	public static ParameterObject[] getSubtitleParameters(TimeBaseFileObject data){
	    List subs=new ArrayList();
	    ParameterObject params[]=data.getParameters();
	    int index=0;
	    for(int i=0;i<params.length;i++){
	        if(params[i].getName().equals("file")){
	            log.trace("file:"+params[i].getValue());
	            if(TimeBaseFileObjectReadUtils.isSRTFile(params[i].getValue())){
	                subs.add(params[i]);
	                
	            }
	        }
	    }
	    return (ParameterObject[])subs.toArray(new ParameterObject[subs.size()]);
	}
	
	public void addSubs(String path,int index,List sublist){
	    /*
	    StandardSubObject[] subobject=(StandardSubObject[]) sublist.toArray(new StandardSubObject[sublist.size()]);
	    for (int i = 0; i < subobject.length; i++) {
//	      //check label.
	        SRTFigure srt=
	             new SRTFigure(shell,index);
	        srt.setLocation(new Point(0,32*(index+1)));//TODO change this is test.
	        srt.setText(subobject[i].getText());
	        srt.setStart(subobject[i].getStartTime());
	        srt.setEnd(subobject[i].getEndTime());
	        log.trace("srt:"+srt.getStart()+","+srt.getEnd()+","+srt.getText());
	        //TODO support cached thumb image ?.
			srt.setScale(waveFormFigureCanvas.getZoom(),1.0);
			log.trace("srt-size:"+srt.getClientArea());
			srtListFigure.add(srt); //tmp change.
        }
	    srtListFigure.revalidate();
	    */
	    srtListFigures[index].setStandardSubObjectList(sublist);
	    srtListFigures[index].setSubObjectPath(path);
	    srtListFigures[index].rerect();
	    log.trace("sub-added:"+srtListFigures[index].getClientArea());
	}
	
	
	private void initData(){
	    log.trace("initData");
	    stopped=true;
	    //remove figure.
	    waveFormFigureCanvas.removeWaveForm();
	    waveFormFigureCanvas.setSelectRealValue(0,0);
	    waveFormFigureCanvas.setCurrentRealValue(0);
	    //remove srt
	    for(int i=0;i<srtListFigures.length;i++){
	    if(srtListFigures[i]!=null){
	        srtListFigures[i].removeAll();
	    	}
	    }
	    log.trace("removed-subtitle");
	    
	    waveFormFigureCanvas.scrollToX(0);
	    //init subview.
	    waveFormFigureCanvas.getInFigure().setVisible(false);
	    
	    audioFile=null;
	    //clear sub files.
	    subtitleShowText1.setText("");
        subtitleShowText1.repaint();
	}

	public File parseFirstAudioFile(File baseFile,TimeBaseFileObject object){
	    ParameterObject params[]=object.getParameters();
	    for (int i = 0; i < params.length; i++) {
            if(params[i].getName().equals("file") && 
                    //TODO support other audio formats.
                    TimeBaseFileObjectReadUtils.isWavFile(params[i].getValue()) || TimeBaseFileObjectReadUtils.isMP3File(params[i].getValue())
                    ){
                
                return toRelationPath(baseFile,params[i].getValue());
                
            }
        }
	    return null;
	}
	public File toRelationPath(File file,String value){
	    if(file==null){
	        return new File(value);
	    }else{
	        return new File(PathnameUtils.createPath(file.getAbsolutePath(),value));
	    }
	}
	
	private void setLayerData(File baseFile,TextAndImageFigure target,StandardSubObject sub){
	   log.trace("set layer data");
	    if(sub.getText()!=null && !target.getText().equals(sub.getText())){//TODO null check.
	        target.setText(sub.getText());
	        target.repaint();
	    }else{
	        String imagePath=sub.getImagePath();
            if(log.isTraceEnabled()){
            log.trace("sub-image:"+imagePath);
            }
            if(imagePath!=null){
                Image image=imageCache.loadImage(new File(baseFile,imagePath).getAbsolutePath());
               if(image!=null && !image.equals(target.getImage())){//TODO null check.
                log.trace("sub-setImage:"+imagePath);
                    target.setImage(image);
                    target.repaint();
               }
            }
	    }
	}
	
	
	public File getSubtitleBaseFile(int index){
	    return new File(srtListFigures[index].getSubObjectPath()).getParentFile();    
	}
	
	public class ChangeSubInfo implements WaveFormListener{

        /* (non-Javadoc)
         * @see org.jpn.xucker.rcp.draw2d.WaveFormListener#changeCurrent(long)
         */
        public void changeCurrent(long arg0) {
            if(log.isTraceEnabled()){
                log.trace("changed:"+arg0);
            }
           
            for(int j=0;j<srtListFigures.length;j++){
            
            if(srtListFigures[j]!=null && srtListFigures[j].getStandardSubObjectList()!=null && srtListFigures[j].getStandardSubObjectList().size()>0){
            StandardSubObject[] subs=(StandardSubObject[]) srtListFigures[j].getStandardSubObjectList().toArray(new StandardSubObject[srtListFigures[j].getStandardSubObjectList().size()]);
           
            File baseFile=getSubtitleBaseFile(j);
            for(int i=0;i<subs.length;i++){
               // log.info("figures-time:"+figures[i].getStart()+","+figures[i].getEnd());
                if(subs[i].getStartTime()<=arg0 && subs[i].getEndTime()>=arg0){
                    log.trace("sub-selected:"+subs[i].getText());
                    //TODO image Support.
                    if(subs[i].getText()!=null && !subtitleShowText1.getText().equals(subs[i].getText())){//TODO null check.
                    if(j==0){//TODO multi
                    subtitleShowText1.setText(subs[i].getText());
                    subtitleShowText1.repaint();
                    }else{
                        subtitleShowText2.setText(subs[i].getText());
                        subtitleShowText2.repaint();
                    }
                   // waveFormFigureCanvas.getInFigure().repaint(figures[i].getClientArea());
                    }else{
                        String imagePath=subs[i].getImagePath();
                        if(log.isTraceEnabled()){
                        log.trace("sub-image:"+imagePath);
                        }
                        if(imagePath!=null){
                            Image image=imageCache.loadImage(new File(baseFile,imagePath).getAbsolutePath());
                           //TODO support multi sub.
                                if(j==0){
                                    if(image!=null && !image.equals(subtitleShowText1.getImage())){//TODO null check.
                                        log.trace("sub-setImage:"+imagePath);
                                subtitleShowText1.setImage(image);
                                subtitleShowText1.repaint();
                                    }else{
                                        if(image!=null){
                                            log.trace("sub-sameimage:"+imagePath);
                                        }
                                    }
                                }else{
                                    if(image!=null && !image.equals(subtitleShowText2.getImage())){//TODO null check.
                                        log.trace("sub-setImage:"+imagePath);
                                    subtitleShowText2.setImage(image);
                                    subtitleShowText2.repaint();
                                    }else{
                                        if(image!=null){
                                            log.trace("sub-sameimage:"+imagePath);
                                        }
                                    }
                                }
                               // waveFormFigureCanvas.getInFigure().repaint(figures[i].getClientArea());
                              
                        }
                    }
                }
            }
        }
            }
        }
	    
	}
	
	/**
	 * This is a callback that will allow us
	 * to create the viewer and initialize it.
	 */
	
	/*
	public class KeyTmp implements KeyListener{

        
        public void keyPressed(KeyEvent e) {
            // TODO Auto-generated method stub
           
            ICommand command=PlatformUI.getWorkbench().getCommandSupport().getCommandManager().getCommand("ccc.com1");
            //ICommand command=PlatformUI.getWorkbench().getCommandSupport().add
           // PlatformUI.getWorkbench().getCommandSupport().
            try {
                System.out.println(command.getName());
            } catch (NotDefinedException e1) {
                // TODO Auto-generated catch block
                e1.printStackTrace();
            }
        }

        
        public void keyReleased(KeyEvent e) {
            // TODO Auto-generated method stub
            
        }
	    
	}*/
	/*
	public class CommandL implements ICommandManagerListener{

        public void commandManagerChanged(CommandManagerEvent commandManagerEvent) {
            // TODO Auto-generated method stub
            System.out.println(commandManagerEvent);
        }
	    
	}*/
	
	public TextAndImageFigure createTextAndImageFigure(int width,int height){
	    TextAndImageFigure subtitleShowText = new TextAndImageFigure(this.shell);
		
		 RGB c=PreferenceConverter.getColor(SubplayerPlugin.getDefault().getPreferenceStore(),SubViewPage.LAYER1_BGCOLOR);
         subtitleShowText.setBackgroundColor(new Color(shell.getDisplay(), c));
         
         RGB c2=PreferenceConverter.getColor(SubplayerPlugin.getDefault().getPreferenceStore(),SubViewPage.LAYER1_FGCOLOR);
         subtitleShowText.setForegroundColor(new Color(shell.getDisplay(), c2));
         
		
         int transparent=SubplayerPlugin.getDefault().getPreferenceStore().getInt(SubViewPage.LAYER1_TRANSPARENT);
        
         subtitleShowText.setAlpha(transparent);
         
         
		
        subtitleShowText.setFont(new Font(shell.getDisplay(),PreferenceConverter.getFontData(SubplayerPlugin.getDefault().getPreferenceStore(),SubViewPage.LAYER1_FONT)));
        
        
		subtitleShowText.setSize(width,height);
		
		
		return subtitleShowText;
	}
	
	public Figure createMixFigure(Figure main,int width, int height){
	    int shadow=5;
	    AlphaLayerFigure alpha=new AlphaLayerFigure(ColorConstants.black,32);
		alpha.setSize(width,height);
		alpha.setLocation(new Point(shadow,shadow));
		alpha.setVisible(false);
		
		
		MixWindowFigure mix=new MixWindowFigure();
		//mix.setSize(width,height);
		mix.setShadowFigure(alpha);
		mix.setMainFigure(main);
		//box.addTarget(r2);
		//box.addTarget(alpha);
		//box.addTarget(mix);
		
		//box.setLocation(new Point(300,220));
		
		
		
		mix.setLayoutManager(null);
		mix.add(alpha);
		mix.add(main);
		
		
		mix.setSize(width+shadow,height+shadow);
		
		ResizeBox box=new ResizeBox(mix);
		//box.setSize(20,20);
		
		mix.add(box);
		//mix.setLocation(new Point(100,100));
		
		
		FigureMove move=new FigureMove();
		
		mix.addMouseListener(move);
		mix.addMouseMotionListener(move);
		return mix;
	}
	
	public void createPartControl(Composite parent) {
	    //PlatformUI.getWorkbench().getCommandSupport().getCommandManager().
	    imageCache.setMaxSize(4);
	    //PlatformUI.getWorkbench().getCommandSupport().getCommandManager().addCommandManagerListener(new CommandL()); no need
	    Composite component =new Composite(parent,SWT.NULL);
	    
	    this.shell=parent.getShell();
	    
		component.setLayout(new GridLayout());
		
		Composite panel=new Composite(component,SWT.NULL);
		panel.setLayout(new RowLayout());
		panel.addKeyListener(new EmptyKeyListener());
		/*
		Button bt=new Button(panel,SWT.NULL);
		
		bt.setText("open");
		bt.addSelectionListener(new Select());
		*/
		playButton = new Button(panel,SWT.NULL);
		
		
		
        playButton.setText("play");
        Image play=ImageDescriptor.createFromURL(SubplayerPlugin.getDefault().find(new Path("icons/play.png"))).createImage(); //$NON-NLS-1$
        
        playButton.setImage(play);
        playButton.addSelectionListener(new Play());
		
        //playButton.addSelectionListener(new Play());
		
		Button bt3=new Button(panel,SWT.NULL);
		bt3.setText("stop");
		bt3.setImage(ImageDescriptor.createFromURL(SubplayerPlugin.getDefault().find(new Path("icons/stop.png"))).createImage());
		bt3.addSelectionListener(new Stop());
		
		Button bt4=new Button(panel,SWT.NULL);
		bt4.setText("Zoom In");
		bt4.addSelectionListener(new Zoomup());
		
		
		Button bt5=new Button(panel,SWT.NULL);
		bt5.setText("Zoom Out");
		bt5.addSelectionListener(new Zoomdown());
		
		
		Button bt6=new Button(panel,SWT.NULL);
		bt6.setText("subplay");
		bt6.setImage(ImageDescriptor.createFromURL(SubplayerPlugin.getDefault().find(new Path("icons/subplay.png"))).createImage());
		bt6.addSelectionListener(new PlayRepeat());
		
		
		/*
		 * change play
		 
		Button bt6=new Button(panel,SWT.NULL);
		bt6.setText("play repeat");
		bt6.addSelectionListener(new PlayRepeat());
		*/
		
		labelMove = new LabelMoveComposite(panel,SWT.NULL);
		labelControler = new SubViewLabelControler();
        labelMove.setLabelControler(labelControler);
        initLabelMove();
        
        playPattern = new PlayPatternComposite(panel,SWT.NULL);
        Composite base=new Composite(component,SWT.NULL);
		base.setLayoutData(new GridData(GridData.FILL_BOTH));
		FillLayout fillLayout=new FillLayout();
		
		base.setLayout(fillLayout);
		
		//base
		
		waveFormFigureCanvas = new WaveFormFigureCanvas(base);
		waveFormFigureCanvas.getInFigure().setVisible(false);//for initial
		waveFormFigureCanvas.setWaveFormListener(new ChangeSubInfo());
		
		
		ci=new CenterImageFigure();
		ci.setParentCanvas(waveFormFigureCanvas);
		try{
		 String imgPath=   SubplayerPlugin.getDefault().getPreferenceStore().getString(SubViewPage.BGIMAGE);
		 if(new File(imgPath).exists()){
		 Image img=new Image(null,imgPath);
         if(img!=null){
             ci.setImage(img);
         }
		 }
		}catch(Exception e){
		    e.printStackTrace();
		}
		//ci.setImage(new Image(this.shell.getDisplay(),"c:\\tmp\\bg.jpg"));
		waveFormFigureCanvas.getBackgroundFigure().setLayoutManager(null);
		waveFormFigureCanvas.getBackgroundFigure().add(ci);
		waveFormFigureCanvas.addKeyListener(new CanvasKeyListener());
		/*
		TextAndImageFigure r1=new TextAndImageFigure(this.shell);
		r1.setBackgroundColor(ColorConstants.black);
		r1.setForegroundColor(ColorConstants.yellow);
		log.trace("textandimage");
		r1.setText("hello this is text.");
		log.trace("textandimage");
		r1.setSize(640,480);
		log.trace("textandimage");
		
		FigureMove move=new FigureMove();
		r1.addMouseListener(move);
		r1.addMouseMotionListener(move);
		r1.setLocation(new Point(200,400));
		//r1.setVisible(false);
		*/
		
		
		
		
		
		
		
		
		
		int w=700;
		int h=240;
		subtitleShowText1=createTextAndImageFigure(w,h);
		
		Figure mix1=createMixFigure(subtitleShowText1,w,h);
		mix1.setLocation(new Point(1,150));
		
		subtitleShowText2=createTextAndImageFigure(w,h);
		
		Figure mix2=createMixFigure(subtitleShowText2,w,h);
		mix2.setLocation(new Point(1,300));
		
		
		
		waveFormFigureCanvas.getForegroundFigure().setLayoutManager(null);
		waveFormFigureCanvas.setSplitFrame(0.1);
		//waveFormFigureCanvas.getForegroundFigure().add(r1);
		waveFormFigureCanvas.getForegroundFigure().add(mix2);
		
		waveFormFigureCanvas.getForegroundFigure().add(mix1);
		//waveFormFigureCanvas.getForegroundFigure().add(new RectangleFigure());
		//waveFormFigureCanvas.setBackground(ColorConstants.red);
		
		//file=new File("c:\\tmp\\30.wav");
		//for test
		//waveFormFigureCanvas.loadWave(file);
		
		for(int i=0;i<srtListFigures.length;i++){
		srtListFigures[i] = new SRTListFigure(1,1);
		srtListFigures[i].setScale(waveFormFigureCanvas.getZoom(),1);
		srtListFigures[i].setRectangleY(toSubtitleY(i));
		//srtListFigure.setLayoutManager(new DelegatingLayout());//auto resize?
		srtListFigures[i].setLocation(new Point(0,0));
		
		waveFormFigureCanvas.getInFigure().add(srtListFigures[i]);
		//srtListFigures[i].setVisible(false);//debug
		}
		
		
		
		waveFormFigureCanvas.getForegroundFigure().addMouseListener(new SRTClick());
		
		//test data
		/*
        srt = new SRTFigure(shell);
        
		srt.setScale(waveFormFigureCanvas.getZoom(),1.0);
		srtListFigure.add(srt);
		*/
		
		
		player = new JavaSoundAudioPlayer();
		
		
		  GC gc=new GC(component.getDisplay());
		    String text="text\n\nalo";
		    org.eclipse.swt.graphics.Point dm=gc.stringExtent(text);
		    log.trace("dm:"+dm);
		    
		    
		    
		    

	        WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
	        IStatusLineManager lineManager = workbenchWindow.getStatusLineManager();
	        
	        
		    StatusLineContributionItem item=new StatusLineContributionItem("fileinfo",32);
	        //item.setText("");
	        
	        StatusLineContributionItem item2=new StatusLineContributionItem("subinfo",32);
	        //item2.setText("duration:03:23:20,1000");
	        
	        lineManager.add(item2);
	        
	        lineManager.add(item);
	        
	        
	        //System.out.println("frames:"+MP3Utils.countFrame(new File("c:\\tmp\\matchgirl.mp3")));
	        //
	        long time=System.currentTimeMillis();
	        
	        /*
	         * 
	         subApplication.setFile(new File("C:\\tmp\\testTime.xml"));
	        
	        subApplication.execOpen();
	        */
		       
	        
	        log.trace("loadTime:"+(System.currentTimeMillis()-time));
	        
	        SubplayerPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new PropertyCheck());
	
	
	

	        Transfer[] types = new Transfer[] {FileTransfer.getInstance()};
	    	
	    	int operations = DND.DROP_MOVE | DND.DROP_COPY ;
	    	
	    	
	    		
	    	
	    	
	    	
	    	
	    		DropTarget target2 = new DropTarget (waveFormFigureCanvas, operations);
	    		target2.setTransfer(types);
	    	
	    		target2.addDropListener(new DropMonitor());
	    		
	}
	
	
    public class DropMonitor extends DropTargetAdapter{
		public void dragEnter(DropTargetEvent event){
			//System.out.println("drag enter:"+event.data);
		}
		public void dragOver(DropTargetEvent event){
			//System.out.println("drag over:"+event.data);
			}
		public void drop(DropTargetEvent event){
			//System.out.println("drop:"+event.data);
			
			//System.out.println(event.data.getClass().getName());
			String files[]=(String[])event.data;
		
		
			 if(isPlayingAudio()){
		            stop();
		        }
			subApplication.openFile(new File(files[0]));
			
			}
	}
	
	
	/**
     * 
     */
    private void initLabelMove() {
        log.info("initlabelmove");
        labelMove.initComposite();
        labelMove.addTarget("subtitle1");
		labelMove.addTarget("subtitle2");
		labelMove.addTarget("subtitle3");
		labelMove.addTarget("subtitle4");
		labelMove.addLabel("ALL             ",null);
		for(int i=0;i<8;i++){
		    labelMove.addLabel("["+(i+1)+"]"+SubplayerPlugin.getDefault().getPluginPreferences().getString(LabelPage.LABEL_BASE+(i+1)),
		            new Color(null,PreferenceConverter.getColor(SubplayerPlugin.getDefault().getPreferenceStore(),LabelPage.LABEL_COLOR_BASE+(i+1))));
		}
		
		
		labelMove.selectLabel(labelMove.getLastSelection());
		log.info("selected");
    }

    private boolean shiftPressed;
	public class CanvasKeyListener implements KeyListener,Runnable{

	    public void run(){
	        try {
                Thread.sleep(500);
               
            } catch (InterruptedException e1) {
                // TODO Auto-generated catch block
                e1.printStackTrace();
            }
            if(shiftPressed){
                System.out.println("shift-press");
                while(shiftPressed){
                    try {
                        Thread.sleep(100);
                    } catch (InterruptedException e) {
                        // TODO Auto-generated catch block
                        e.printStackTrace();
                    }
                }
                System.out.println("shift-off");
            }
	    }
        /* (non-Javadoc)
         * @see org.eclipse.swt.events.KeyListener#keyPressed(org.eclipse.swt.events.KeyEvent)
         */
        public void keyPressed(KeyEvent e) {
        //   System.out.println("press:"+e.keyCode);
           // System.out.println("state:"+e.stateMask);
            if(e.keyCode==SWT.SHIFT){
                if(shiftPressed==false){
                shiftPressed=true;
                Thread t=new Thread(this);
                t.start();
                }
            }else{
                shiftPressed=false;
            }
        }

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.KeyListener#keyReleased(org.eclipse.swt.events.KeyEvent)
         */
        public void keyReleased(KeyEvent e) {
       //     System.out.println("release:"+e.keyCode);
       //     System.out.println("state:"+e.stateMask);
            shiftPressed=false;
        }
	    
	}
	
	public class EmptyKeyListener implements KeyListener{

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.KeyListener#keyPressed(org.eclipse.swt.events.KeyEvent)
         */
        public void keyPressed(KeyEvent e) {
            log.trace("pressed:"+e);
        }

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.KeyListener#keyReleased(org.eclipse.swt.events.KeyEvent)
         */
        public void keyReleased(KeyEvent e) {
            log.trace("released:"+e);
        }
	    
	}
	
	public int toSubtitleY(int index){
	    return 20+36*index;
	}
	public int toSubtitleHeight(int index){
	    return 32;
	}
	
	public class PropertyCheck implements IPropertyChangeListener{

        /* (non-Javadoc)
         * @see org.eclipse.jface.util.IPropertyChangeListener#propertyChange(org.eclipse.jface.util.PropertyChangeEvent)
         */
        public void propertyChange(PropertyChangeEvent event) {
            // TODO Auto-generated method stub
            log.trace("propertychange:"+event.getProperty()+","+event.getNewValue()+","+event.getOldValue());
            if(event.getProperty().equals(SubViewPage.LAYER1_BGCOLOR)){
             //  String rgb=SubplayerPlugin.getDefault().getPreferenceStore().getString(SubViewPage.LAYER1_BGCOLOR);
               RGB c=PreferenceConverter.getColor(SubplayerPlugin.getDefault().getPreferenceStore(),SubViewPage.LAYER1_BGCOLOR);
               subtitleShowText1.setBackgroundColor(new Color(null, c));
                //subtitleShowText1.setBackgroundColor(new Color(SubplayerPlugin.getDefault().getPreferenceStore().getInt(SubViewPage.LAYER1_BGCOLOR)));
               subtitleShowText1.repaint(subtitleShowText1.getClientArea());
               
               subtitleShowText2.setBackgroundColor(new Color(null, c));
               //subtitleShowText1.setBackgroundColor(new Color(SubplayerPlugin.getDefault().getPreferenceStore().getInt(SubViewPage.LAYER1_BGCOLOR)));
              subtitleShowText2.repaint(subtitleShowText2.getClientArea());
              
            }else if(event.getProperty().equals(SubViewPage.LAYER1_FGCOLOR)){
                //  String rgb=SubplayerPlugin.getDefault().getPreferenceStore().getString(SubViewPage.LAYER1_BGCOLOR);
                RGB c=PreferenceConverter.getColor(SubplayerPlugin.getDefault().getPreferenceStore(),SubViewPage.LAYER1_FGCOLOR);
                subtitleShowText1.setForegroundColor(new Color(null, c));
                 //subtitleShowText1.setBackgroundColor(new Color(SubplayerPlugin.getDefault().getPreferenceStore().getInt(SubViewPage.LAYER1_BGCOLOR)));
                subtitleShowText1.repaint(subtitleShowText1.getClientArea());
                
                subtitleShowText2.setForegroundColor(new Color(null, c));
                //subtitleShowText1.setBackgroundColor(new Color(SubplayerPlugin.getDefault().getPreferenceStore().getInt(SubViewPage.LAYER1_BGCOLOR)));
               subtitleShowText2.repaint(subtitleShowText2.getClientArea());
               
             }else if(event.getProperty().equals(SubViewPage.LAYER1_TRANSPARENT)){
                int transparent=Integer.parseInt((String)event.getNewValue());
                log.trace("new-trans:"+transparent);
                subtitleShowText1.setAlpha(transparent);
                subtitleShowText1.repaint(subtitleShowText1.getClientArea()); 
                
                subtitleShowText2.setAlpha(transparent);
                subtitleShowText2.repaint(subtitleShowText2.getClientArea()); 
                
            }else if(event.getProperty().equals(SubViewPage.LAYER1_FONT)){
               log.trace("font:"+SubplayerPlugin.getDefault().getPreferenceStore().getString(SubViewPage.LAYER1_FONT));
                FontData fontData=PreferenceConverter.getFontData(SubplayerPlugin.getDefault().getPreferenceStore(),SubViewPage.LAYER1_FONT);
                subtitleShowText1.setFont(new Font(null,fontData));
                subtitleShowText1.repaint(subtitleShowText1.getClientArea());
                
                //debug
                subtitleShowText2.setFont(new Font(null,fontData));
                subtitleShowText2.repaint(subtitleShowText2.getClientArea());
                
            }else if(event.getProperty().equals(SubViewPage.BGIMAGE)){
                log.info("bgimage:"+SubplayerPlugin.getDefault().getPreferenceStore().getString(SubViewPage.BGIMAGE));
                Image img=new Image(null,SubplayerPlugin.getDefault().getPreferenceStore().getString(SubViewPage.BGIMAGE));
                if(img!=null){
                    if(ci.getImage()!=null){
                        ci.getImage().dispose();
                    }
                    ci.setImage(img);
                    ci.repaint(ci.getClientArea());
                }
                
            }else if(event.getProperty().startsWith(LabelPage.LABEL_COLOR_BASE)){
                log.info("change color");
                int index=LabelPage.toIndex(event.getProperty());
                for(int i=0;i<srtListFigures.length;i++){
                    srtListFigures[i].initColor(index-1);
                }
                waveFormFigureCanvas.getInFigure().repaint();
                initLabelMove();
            }else if(event.getProperty().startsWith(LabelPage.LABEL_BASE)){
                initLabelMove();
            }
            
        }
	    
	}
	
	public class ResizeBox extends Figure implements MouseListener,MouseMotionListener{
	    
	    int minWidth=100;
	    int minHeight=100;
	    int clickx;
	    int clicky;
	    //List targets=new ArrayList();
	    /*
	    public void addTarget(Figure figure){
	        targets.add(figure);
	    }*/
	    Figure target;
	    int sizeX=20;
	    int sizeY=20;
	    public ResizeBox(Figure target){
	    super();
	    this.target=target;
	    this.setForegroundColor(ColorConstants.gray);
	    this.addMouseListener(this);
	    this.addMouseMotionListener(this);
	    this.setSize(sizeX,sizeY);
	    this.setLocation(newPoint());
	    }
        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseListener#mousePressed(org.eclipse.draw2d.MouseEvent)
         */
        public void mousePressed(MouseEvent arg0) {
            clickx=arg0.x;
            clicky=arg0.y;
            log.trace("click:"+clickx+","+clicky);
            arg0.consume();
            
        }
        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseListener#mouseReleased(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseReleased(MouseEvent arg0) {
            // TODO Auto-generated method stub
            
        }
        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseListener#mouseDoubleClicked(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseDoubleClicked(MouseEvent arg0) {
            // TODO Auto-generated method stub
            
        }
        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseMotionListener#mouseDragged(org.eclipse.draw2d.MouseEvent)
         */
        int marginX=5+2;
        int marginY=5+2;
        public void mouseDragged(MouseEvent arg0) {
            int moveX=clickx-arg0.x;
            int moveY=clicky-arg0.y;
            
            clickx=arg0.x;
            clicky=arg0.y;
            
            
            //Figure[] figures=(Figure[]) targets.toArray(new Figure[targets.size()]);
            //log.trace("figures-size:"+figures.length);
            
            boolean movex=false;
            boolean movey=false;
           // for(int i=0;i<figures.length;i++){
                int newSizeX=0;
                int newSizeY=0;
                
            if(target.getSize().width>minWidth){
                newSizeX=Math.max(minWidth,target.getSize().width-moveX);
            }else if(target.getSize().width<=minWidth){
                newSizeX=Math.max(minWidth,target.getSize().width-moveX);
            }
            
            if(target.getSize().height>minHeight){
                newSizeY=Math.max(minHeight,target.getSize().height-moveY);
            }else if(target.getSize().height<=minHeight){
                newSizeY=Math.max(minHeight,target.getSize().height-moveY);
            }
            
            if(newSizeX>0 && newSizeY>0){
                log.trace("newsize:"+newSizeX+","+newSizeY);
                shell.getDisplay().syncExec(new Resize(target,newSizeX,newSizeY));
               // target.setSize(newSizeX,newSizeY);
               
            }
            if(newSizeX>minWidth){
                movex=true;
            }
            
            if(newSizeY>minHeight){
                movey=true;
            }
            
            
        
            if(movex || movey){
                Point current=newPoint();
            log.trace("newPoint:"+current);
            this.setLocation(current);
            }
            
            arg0.consume();
        }
        
        public Point newPoint(){
            return new Point(target.getLocation().x+target.getSize().width-sizeX-marginX,target.getLocation().y+target.getSize().height-sizeY-marginY);
            
        }
        
        public class Resize implements Runnable{
            Figure target;
            int w;
            int h;
            public Resize(Figure target,int w,int h){
                this.target=target;
                this.w=w;
                this.h=h;
            }
            public void run(){
                target.setSize(w,h);
            }
        }
        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseMotionListener#mouseEntered(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseEntered(MouseEvent arg0) {
            // TODO Auto-generated method stub
            
        }
        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseMotionListener#mouseExited(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseExited(MouseEvent arg0) {
            // TODO Auto-generated method stub
            
        }
        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseMotionListener#mouseHover(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseHover(MouseEvent arg0) {
            // TODO Auto-generated method stub
            
        }
        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseMotionListener#mouseMoved(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseMoved(MouseEvent arg0) {
           
        }
        
        public void paintFigure(Graphics g){
            
            g.drawRectangle(this.getClientArea().x,this.getClientArea().y,this.getClientArea().width-1,this.getClientArea().height-1);
        }
	}
	

	private StatusLineContributionItem getFileInfoStatusLine(){
	    WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IStatusLineManager lineManager = workbenchWindow.getStatusLineManager();
        return (StatusLineContributionItem) lineManager.find("fileinfo");
	}
	private WaveFormFigureCanvas waveFormFigureCanvas;

	
    /**
	 * @param shell
	 */
	
	private Shell shell;

	private File audioFile;
	
	private long lastSelectionEvent;
	public class MixWindowFigure extends Figure{
	    private Figure shadowFigure;
	    private Figure mainFigure;
	    //private Figure resizeFigure;
        public Figure getMainFigure() {
            return mainFigure;
        }
        public void setMainFigure(Figure mainFigure) {
            this.mainFigure = mainFigure;
        }
        public Figure getShadowFigure() {
            return shadowFigure;
        }
        public void setShadowFigure(Figure shadowFigure) {
            this.shadowFigure = shadowFigure;
        }
	    int shadowSizeX=5;
	    int shadowSizeY=5;
	    
	    public void setSize(int w,int h){
	        super.setSize(w,h);
	        shadowFigure.setSize(getSize().width-shadowSizeX,getSize().height-shadowSizeY);
	        mainFigure.setSize(getSize().width-shadowSizeX,getSize().height-shadowSizeY);
	    }
	    /*
        public Figure getResizeFigure() {
            return resizeFigure;
        }
        public void setResizeFigure(Figure resizeFigure) {
            this.resizeFigure = resizeFigure;
        }*/
	}
	
	public class FigureMove implements MouseMotionListener,MouseListener{

	    int downx=0;
	    int downy=0;
	    boolean pressed=false;
        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseMotionListener#mouseDragged(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseDragged(MouseEvent me) {
            if(pressed){
            log.trace("dragged:"+me);
            Figure figure=(Figure)me.getSource();
            int moveX=downx-me.x;
            int moveY=downy-me.y;
            log.trace("moveX="+moveX+",moveY="+moveY);
            Point loc=figure.getLocation();
            loc.x-=moveX;
            loc.y-=moveY;
            log.trace("locx="+loc.x+",loc.y="+loc.y);
            figure.setLocation(loc);
            downx=me.x;
            downy=me.y;
            me.consume();
            }
        }

        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseMotionListener#mouseEntered(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseEntered(MouseEvent me) {
            // TODO Auto-generated method stub
            
        }

        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseMotionListener#mouseExited(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseExited(MouseEvent me) {
            // TODO Auto-generated method stub
            
        }

        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseMotionListener#mouseHover(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseHover(MouseEvent me) {
            // TODO Auto-generated method stub
            
        }

        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseMotionListener#mouseMoved(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseMoved(MouseEvent me) {
            // TODO Auto-generated method stub
            
        }

        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseListener#mousePressed(org.eclipse.draw2d.MouseEvent)
         */
        public void mousePressed(MouseEvent me) {
            Figure figure=(Figure)me.getSource();
            IFigure parent=figure.getParent();
            //figure.requestFocus();
            List list=parent.getChildren();
            int index=0;
            for(int i=0;i<list.size();i++){
                if(list.get(i)==figure){
                    index=i;
                    break;
                }
            }
            log.trace("index:"+index);
            if(index!=list.size()-1){
              parent.remove(figure);
                parent.add(figure);
            }
            
            //figure.
            downx=me.x;
            downy=me.y;
            pressed=true;
            me.consume();
        }

        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseListener#mouseReleased(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseReleased(MouseEvent me) {
            
            pressed=false;
        }

        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseListener#mouseDoubleClicked(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseDoubleClicked(MouseEvent me) {
            log.info("doubleclick:"+me.x+","+me.y);
            Figure figure=(Figure)me.getSource();
            
            if(figure instanceof MixWindowFigure){
                Figure main=((MixWindowFigure)figure).getMainFigure();
                if(main instanceof TextAndImageFigure){
                    TextAndImageFigure textAndImage=(TextAndImageFigure)main;
                    
                    
                    WrapTextPainter painter=((TextAndImageFigure)main).getWrapTextPainter();
                    int index=painter.getClickIndex(me.x-main.getClientArea().x-textAndImage.getMarginX(),me.y-main.getClientArea().y-textAndImage.getMarginY());
                    if(index!=-1){
                        String word=painter.getWord(index);
                        log.info("word:"+word);
                        if(word.equals("")){
                            execTranslate(textAndImage.getText());
                        }else{
                            execWebDictionary(word);
                        }
                    }else{
                        execTranslate(textAndImage.getText());
                    }
                    
                }
            }
        }
	    
	}
	public void execTranslate(String text){
	   
	    String lines[]=text.split("\\.");
	   
	    String newText="";
	    for(int i=0;i<lines.length;i++){
	        int index=0;
	        if(lines[i].startsWith("\n")){
	            index=1;
	        }
	       // log.info("t:"+lines[i]);
	        newText+=lines[i].substring(index)+".\n";
	    }
	    
	    TranslateView view=(TranslateView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(TranslateView.ID);
		if(view!=null){
		   // log.info("exec:"+newText);
		    view.setText(newText);
		    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate(view);
		}
		
	    }
	
	
	public void execWebDictionary(String text){
		   
		    
		    WebDictionaryView view=(WebDictionaryView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(WebDictionaryView.ID);
			if(view!=null){
			   // log.info("exec:"+newText);
			    view.setText(text);
			    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate(view);
			}
			
		    }
	public class SRTClick implements MouseListener{

        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseListener#mousePressed(org.eclipse.draw2d.MouseEvent)
         */
        public void mousePressed(MouseEvent me) {
           // lastset=System.currentTimeMillis();
            // TODO Auto-generated method stub
            //log.trace(me.getSource().getClass().getName());
           for(int i=0;i<srtListFigures.length;i++){
            StandardSubObject[] subs=srtListFigures[i].containSubtitles(me.x,me.y);
            if(subs.length>0){
                selectSubtitle(i,subs[0]);
                /*
                int dx1=timeToRealValue(subs[0].getStartTime());
                int dx2=timeToRealValue(subs[0].getEndTime());
                currentStandardSubObject=subs[0];
                waveFormFigureCanvas.setSelectRealValue(dx1,dx2);
                
                waveFormFigureCanvas.setRectangleRealValue(new Rectangle(dx1,toSubtitleY(i),dx2-dx1,toSubtitleHeight(i)));
                */
                me.consume();
                return;
            }
           }
           currentStandardSubObject=null;
           waveFormFigureCanvas.setRectangleRealValue(null);
        }

        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseListener#mouseReleased(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseReleased(MouseEvent me) {
            if(lastset+500>System.currentTimeMillis()){
            log.trace("opend so soon");
            return;
            }
            for(int i=0;i<srtListFigures.length;i++){
            StandardSubObject[] subs=srtListFigures[i].containSubtitles(me.x,me.y);
            if(subs.length>0){
                selectSubtitle(i,subs[0]);
                /*
                currentStandardSubObject=subs[0];
                int dx1=timeToRealValue(subs[0].getStartTime());
                int dx2=timeToRealValue(subs[0].getEndTime());
                currentStandardSubObject=subs[0];
                waveFormFigureCanvas.setSelectRealValue(dx1,dx2);
                */
                me.consume();
                return;
            }
            }
            
            currentStandardSubObject=null;
        }

        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseListener#mouseDoubleClicked(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseDoubleClicked(MouseEvent me) {
           // log.trace("play:"+currentStandardSubObject);
            if(!isPlayingAudio()){
                if((me.getState() & MouseEvent.SHIFT)>0){
                 singleRepeat();   
                }else{
                    
                    play();
                }
            }
        }
	    
	}
	public class Zoomup implements SelectionListener{

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
         */
        public void widgetSelected(SelectionEvent e) {
            waveFormFigureCanvas.zoomUp();
            waveFormFigureCanvas.setFocus();
        }

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
         */
        public void widgetDefaultSelected(SelectionEvent e) {
           
        }
	    
	}
	
	public class Zoomdown implements SelectionListener{

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
         */
        public void widgetSelected(SelectionEvent e) {
            
            waveFormFigureCanvas.zoomDown();
            waveFormFigureCanvas.setFocus();
        }

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
         */
        public void widgetDefaultSelected(SelectionEvent e) {
           
        }
	    
	}
	
	public class PlayRepeat implements SelectionListener{

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
         */
        public void widgetSelected(SelectionEvent e) {
            
            playRepeat();
            waveFormFigureCanvas.setFocus();
        }

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
         */
        public void widgetDefaultSelected(SelectionEvent e) {
           
        }
	    
	}
	
	public class SRTFigure extends DoubleScalableFigure{

	    long start=1000;
	    long end=2000;
	    private int index;
	   // TextAndImageFigure textAndImage;
        public long getEnd() {
            return end;
            
            
        }
        public void setEnd(long end) {
            this.end = end;
        }
        public long getStart() {
            return start;
        }
        public void setStart(long start) {
            this.start = start;
        }
      
       private String text;
       
	    public void setImage(Image img){
	     //   textAndImage.setImage(img);
	    }
	   // double perms=0.01;
	    
	    int height=32;
        /**
         * @param arg0
         * @param arg1
         */
	    
	    AlphaLayerFigure alpha;
        public SRTFigure(Shell shell,int index) {
            super(1,1);
            this.index=index;
            //alpha=new AlphaLayerFigure(ColorConstants.white,128);
            //this.add(alpha);
       //     textAndImage=new TextAndImageFigure(shell);
         //   add(textAndImage);
            this.setLayoutManager(new StackLayout());
            // TODO Auto-generated constructor stub
            setScale(1.0,1.0);
        }
        
        public void setScale(double w,double h){
            wzoom=w;
            hzoom=h;
            setBounds(getRectangle());
        }
        
        public Rectangle getRectangle(){
            int dx=(int)(start*this.getHorizontalScale()/waveFormFigureCanvas.getSplitFrame()/1000);
            int dx2=(int)(end*this.getHorizontalScale()/waveFormFigureCanvas.getSplitFrame()/1000);
            //log.trace(color+","+getClientArea()+","+getParent().getClientArea());
            //Rectangle rectangle=new Rectangle(dx,0,dx2-dx,height);
            Rectangle rectangle=new Rectangle(dx,this.getClientArea().y,dx2-dx,height);
            if(getParent()!=null){
            rectangle.x=rectangle.x+getParent().getClientArea().x;//???
            //rectangle.y=rectangle.y-getParent().getClientArea().y;//???
            }
            log.trace("srt-rectangle:"+rectangle);
            return rectangle;
        }
        
        public void paintFigure(Graphics g){
            log.trace("srt-paint:"+this.getClientArea());
            if(text!=null){
                g.setFont(new Font(shell.getDisplay(),"MS ",12,SWT.NONE));
                g.drawString(text,this.getClientArea().x,this.getClientArea().y);
            }
            //g.fillRectangle(this.getClientArea());
           // g.drawRectangle(this.getClientArea());
        }
       
    public String getText() {
        return text;
    }
    public void setText(String text) {
        this.text = text;
    }
	}
	
	public class Stop implements SelectionListener{

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
         */
        public void widgetSelected(SelectionEvent e) {
            waveFormFigureCanvas.setFocus();
            stop();
           
        }

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
         */
        public void widgetDefaultSelected(SelectionEvent e) {
            
        }
	    
	}
	
	boolean stopped=true;
    private JavaSoundAudioPlayer player;
    private Button playButton;

    private Point selection;
    
    //double splitframe=0.01;
	public class PlayStop implements AudioStopper{

        /* (non-Javadoc)
         * @see org.jpn.xucker.commons.audio.AudioStopper#isStopped()
         */
        public boolean isStopped() {
            // TODO Auto-generated method stub
            return stopped;
        }

        /* (non-Javadoc)
         * @see org.jpn.xucker.commons.audio.AudioStopper#setStopped(boolean)
         */
        public void setStopped(boolean arg0) {
            // TODO Auto-generated method stub
            
        }
	    
	}
	
	private long duration;
	private boolean playMoveSelection;

   // private SRTFigure srt;
	SRTListFigure[] srtListFigures=new SRTListFigure[4];
   // private DoubleScalableFigure srtListFigure;
    private TextAndImageFigure subtitleShowText1;
    private TextAndImageFigure subtitleShowText2;
    private LabelMoveComposite labelMove;
    private SubViewLabelControler labelControler;
    private PlayPatternComposite playPattern;
    public class SRTListFigure extends DoubleScalableFigure{
        List standardSubObjectList=new ArrayList(0);
        private Rectangle[] inRectangle;
        
        private int rectangleY=32;
        private int rectangleHeight=32;
        
        private Image[] labelImages=new Image[8];
        
        private String subObjectPath;
        /**
         * @param arg0
         * @param arg1
         */
        public SRTListFigure(int arg0, int arg1) {
            super(arg0, arg1);
            for(int i=0;i<8;i++){
           initColor(i);
            }
        }
        
        public void initColor(int index){
            
            RGB color=PreferenceConverter.getColor(SubplayerPlugin.getDefault().getPreferenceStore(),LabelPage.LABEL_COLOR_BASE+(index+1));
            
            labelImages[index]=AlphaUtils.createColorAlphaImageData(new Color(shell.getDisplay(), color),128);
            
            
        }
        
        public void setStandardSubObjectList(List list){
            standardSubObjectList=list;
           // rerect();
        }
        
        public StandardSubObject[] containSubtitles(int x,int y){
            if(standardSubObjectList!=null){
            List tmp=new ArrayList();
            for(int i=0;i<inRectangle.length;i++){
                if(inRectangle[i].contains(-getParent().getBounds().x+x,y)){
                    tmp.add(standardSubObjectList.get(i));
                }
                
            }
            return (StandardSubObject[]) tmp.toArray(new StandardSubObject[tmp.size()]);
            }else{
                return new StandardSubObject[0];
            }
        }
        
        public void setScale(double w,double h){
            super.setScale(w,h);
            rerect();
        }
        public void rerect(){
            log.trace("rerect");
            if(standardSubObjectList!=null){
            StandardSubObject subs[]=(StandardSubObject[]) standardSubObjectList.toArray(new StandardSubObject[standardSubObjectList.size()]);
            Rectangle[] tmpRect=new Rectangle[subs.length];
            for(int i=0;i<subs.length;i++){
                int dx=(int)(subs[i].getStartTime()*this.getHorizontalScale()/waveFormFigureCanvas.getSplitFrame()/1000);
                int dx2=(int)(subs[i].getEndTime()*this.getHorizontalScale()/waveFormFigureCanvas.getSplitFrame()/1000);
                tmpRect[i]=new Rectangle(dx,rectangleY,dx2-dx,rectangleHeight);
                log.trace("subrect:"+tmpRect[i]);
            }
            
            inRectangle=tmpRect;
            }else{
                inRectangle=new Rectangle[0];
            }
        }
        
        public void paintFigure(Graphics g){
            if(inRectangle==null){
                rerect();
            }
            log.trace("srtlist-paint:"+this.getClientArea()+",inRectangle="+inRectangle.length);
            
            for(int i=0;i<inRectangle.length;i++){
                //g.drawRectangle(inRectangle[i].x+getParent().getBounds().x,inRectangle[i].y,inRectangle[i].width,inRectangle[i].height);//TODO image & label.
                Rectangle drawRec=new Rectangle(inRectangle[i].x+getParent().getBounds().x,inRectangle[i].y,inRectangle[i].width,inRectangle[i].height);
                int labelIndex=0;
                String option=((StandardSubObject)standardSubObjectList.get(i)).getOption();
                if(option!=null){
                    labelIndex=(Integer.parseInt(option))-1;
                }
               
                g.drawImage(labelImages[labelIndex],new Rectangle(labelImages[0].getBounds()),drawRec);
                
            }
        }
        
        public int getRectangleHeight() {
            return rectangleHeight;
        }
        public void setRectangleHeight(int rectangleHeight) {
            this.rectangleHeight = rectangleHeight;
        }
        public int getRectangleY() {
            return rectangleY;
        }
        public void setRectangleY(int rectangleY) {
            this.rectangleY = rectangleY;
        }
        public List getStandardSubObjectList() {
            return standardSubObjectList;
        }
        public String getSubObjectPath() {
            return subObjectPath;
        }
        public void setSubObjectPath(String subObjectPath) {
            this.subObjectPath = subObjectPath;
        }
    }
	 public void play(){
	     
	     if(isPlayingAudio() || audioFile==null){
	        stop();
	        return;
	     	}
	     
	     AudioFormat format=null;
        try {
            if(TimeBaseFileObjectReadUtils.isMP3File(audioFile.getName())){
                format = MP3Utils.getAudioFormat(new FileInputStream(audioFile));
            }else{
            format = WaveUtils.getAudioFormat(audioFile);//TODO mp3 support
            }
        } catch (UnsupportedAudioFileException e1) {
            // TODO Auto-generated catch block
            e1.printStackTrace();
        } catch (IOException e1) {
            // TODO Auto-generated catch block
            e1.printStackTrace();
        }
            selection = waveFormFigureCanvas.getSelection();
           // log.info("selection:"+selection);
            if(selection==null || (selection.x==0 && selection.y==0)){
                selection=new Point(waveFormFigureCanvas.getCurrentRealValue(),waveFormFigureCanvas.getLastPosition());
            }
          // log.info("selection:"+selection);
           
	       long starttime=(long)(selection.x*1000/waveFormFigureCanvas.getBaseMemoryPixel());
	       long endtime=(long)(selection.y*1000/waveFormFigureCanvas.getBaseMemoryPixel());
	       duration=endtime-starttime;
	       log.trace("duration:"+starttime+","+endtime);
	       
	       player.setStopper(new PlayStop());
	       player.setAudioListener(new AudioMove());
	       
	       
	       playButton.setEnabled(false);
	       Thread t=new Thread(new Playing(audioFile,starttime,endtime));
	       
	       t.start();
	    }
	 
	 public void play(long start,long end){
	     
	 }
	    
	    public void stop(){
	        log.trace("call stop");
	        stopped=true;
	        shell.getDisplay().asyncExec(new EnablePlay());
	        playMoveSelection=false;
	        if(multiTimeAudioPlayer!=null){
	            multiTimeAudioPlayer.stop();
	        }
	    }
	    public boolean isPlayingAudio(){
	        return !stopped;
	    }
	    public class EnablePlay implements Runnable{
	        public void run(){
	            playButton.setEnabled(true);
	        }
	    }
	    
	    public class Playing implements Runnable{
	        private File file;
	        private long start;
	        private long end;
	        public Playing(File file,long start,long end){
	            this.file=file;
	            this.start=start;
	            this.end=end;
	        }
	        public void run(){
	            if(stopped==true){
	               
	                    log.trace("play-duration:"+(end-start));
	        	        stopped=false;
	        	        try {
                            player.play(file,start,end);
                        } catch (UnsupportedAudioFileException e) {
                            // TODO Auto-generated catch block
                            e.printStackTrace();
                        } catch (IOException e) {
                            // TODO Auto-generated catch block
                            e.printStackTrace();
                        } catch (LineUnavailableException e) {
                            // TODO Auto-generated catch block
                            e.printStackTrace();
                        }
	                    
	              
	                
	            }
	            stop();
	        }
	    }
	    
	    
	    public class MovePosition implements Runnable{
	        private int selection;
	        public MovePosition(int selection){
	            this.selection=selection;
	        }
	        public void run(){
	            log.trace("move-position:"+selection);
	            waveFormFigureCanvas.moveCurrentPosition(selection);
	           
	        }
	    }
	    
	    public class AudioMove implements AudioListener{

            /* (non-Javadoc)
             * @see org.jpn.xucker.commons.audio.AudioListener#startPlaying()
             */
            public void startPlaying() {
                playMoveSelection=true;
                //log.info("start-playing");
                shell.getDisplay().syncExec(new MovePosition(selection.x));
                log.info("start-playing2");
                
                if(selection.x==-1){
                    //zero start.
                    selection.x=0;
                }
                PlayMove move=new PlayMove(selection.x);
                Thread t=new Thread(move);
                t.start();
                
            }

            /* (non-Javadoc)
             * @see org.jpn.xucker.commons.audio.AudioListener#stopPlaying()
             */
            public void stopPlaying() {
                log.trace("stopplaying");
                // TODO Auto-generated method stub
                stopped=true;
                playMoveSelection=false;
            }

            /* (non-Javadoc)
             * @see org.jpn.xucker.commons.audio.AudioListener#finishPlaying()
             */
            public void finishPlaying() {
                log.trace("finishplaying");
                stopped=true;
                playMoveSelection=false;
            }
	        
	    }
	    
	    public class PlayMove implements Runnable{
	        int sleeptime=30;
	        int startPosition;
	        private boolean canceld=false;
	        public PlayMove(int start){
	            startPosition=start;
	            //log.info("init:"+start);
	        }
	        public void cancel(){
	            canceld=true;
	        }
	        public void run(){
	            
	            long start=System.currentTimeMillis();
	            log.trace("playMoveSelection="+playMoveSelection+","+canceld);
	            while(playMoveSelection && canceld==false){
	            try {
                    Thread.sleep(sleeptime);
                } catch (InterruptedException e) {
                    
                    e.printStackTrace();
                }
               
	            long played=System.currentTimeMillis()-start;
	            log.trace("played:"+played+",duration="+duration);
	            if(played>duration){
	                break;
	            }
	            shell.getDisplay().syncExec(new MovePosition(toPosition(played)));
	            
	            }
	        }
	        
	        public int toPosition(long time){
	            //log.trace("move"+time);
		        
		        return timeToRealValue(time)+startPosition;
		    }
	    }
	    
	    
	    public int timeToRealValue(long time){
	        return (int)(time*waveFormFigureCanvas.getBaseMemoryPixel()/1000);
	    }
	   
	    
	    
	    
	
	public class CenterImageFigure extends Figure{
	    private Image image;
	    private Canvas parentCanvas;
	    
	    public CenterImageFigure(){
	        //setBackgroundColor(null);
	    }
        public Image getImage() {
            return image;
        }
        public void setImage(Image image) {
            this.image = image;
        }
        public Canvas getParentCanvas() {
            return parentCanvas;
        }
        public void setParentCanvas(Canvas parentCanvas) {
            this.parentCanvas = parentCanvas;
            parentCanvas.addControlListener(new ResizeCheck());
            parentCanvas.getHorizontalBar().addSelectionListener(new Selection());
        }
       
        public void paintFigure(Graphics g) {
            Rectangle client=new Rectangle(parentCanvas.getClientArea());
            Rectangle rec=g.getClip(client);
            log.trace("repaint:"+rec);
            
            /*
            if(client.width!=rec.width || client.height!=rec.height){
                return;
            }*/
            
            if(image!=null){
               
	        int centerX=(parentCanvas.getClientArea().width-image.getBounds().width)/2;
	        int centerY=(parentCanvas.getClientArea().height-image.getBounds().height)/2;
	        
	        Rectangle rectangle=new Rectangle(this.getLocation().x+centerX,this.getLocation().y+centerY,image.getBounds().width,image.getBounds().height);
	        log.trace("g:"+rectangle);
	        //g.clipRect(new Rectangle(parentCanvas.getClientArea()));//change clip
	        g.drawImage(image,new Rectangle(image.getBounds()),rectangle);
            
            }
            
            }
	    
        public void moveImage(){
            log.trace("move");
            this.setLocation(new Point(parentCanvas.getHorizontalBar().getSelection(),parentCanvas.getVerticalBar().getSelection()));
            //repaint();
        }
        
        public class Selection implements SelectionListener{

            /* (non-Javadoc)
             * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
             */
            public void widgetSelected(SelectionEvent e) {
              // moveImage();
            }

            /* (non-Javadoc)
             * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
             */
            public void widgetDefaultSelected(SelectionEvent e) {
               
            }
            
        }
        public class ResizeCheck implements ControlListener{

            /* (non-Javadoc)
             * @see org.eclipse.swt.events.ControlListener#controlMoved(org.eclipse.swt.events.ControlEvent)
             */
            public void controlMoved(ControlEvent e) {
                // TODO Auto-generated method stub
                log.trace("moved");
            }

            /* (non-Javadoc)
             * @see org.eclipse.swt.events.ControlListener#controlResized(org.eclipse.swt.events.ControlEvent)
             */
            public void controlResized(ControlEvent e) {
               log.trace("resized");
               setSize(parentCanvas.getClientArea().width,parentCanvas.getClientArea().height);
            }
            
        }
	}
	public class Play implements SelectionListener{

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
         */
        public void widgetSelected(SelectionEvent e) {
            waveFormFigureCanvas.setFocus();
            play();
           
        }

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
         */
        public void widgetDefaultSelected(SelectionEvent e) {
           
        }
	    
	}
	
	public class DrawTextFigure extends Figure{
	  
	    
	}
	
	public class Select implements SelectionListener{

	    /* (non-Javadoc)
         * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
         */
        public void widgetSelected(SelectionEvent e) {
            log.warn("select?");
        }

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
         */
        public void widgetDefaultSelected(SelectionEvent e) {
            // TODO Auto-generated method stub
            
        }
	    
	}
	
	public class EditExecuter implements TimeBaseFileUpdater{

        /* (non-Javadoc)
         * @see org.jpn.xucker.rcp.subplayer.TimeBaseFileUpdater#update(org.jpn.xucker.subtitle.TimeBaseFileObject, org.jpn.xucker.subtitle.TimeBaseFileObject)
         */
        public void update(TimeBaseFileObject oldObject, TimeBaseFileObject newObject) {
            log.trace("update");
            //load
            File newAudio=parseFirstAudioFile(subApplication.getFile(),newObject);
            boolean different=false;
            if(audioFile==null){
                if(newAudio!=null){
                    different=true;
                }
            }else{
                if(newAudio==null){
                    different=true;
                }else if(!audioFile.getAbsolutePath().equals(newAudio.getAbsolutePath())){
                    different=true;
                }
            }
            
           
    	    if(different){
    	        log.info("different:"+newAudio);
    	        subApplication.setNeedSave(true);
    	        
    	        try {
    	            
                    setData(subApplication.getFile(),newObject);
                } catch (UnsupportedAudioFileException e) {
                   
                    e.printStackTrace();
                } catch (IOException e) {
                  
                    e.printStackTrace();
                }
    	    }else{
    	        audioFile=newAudio;
    	        ParameterObject[] oldsaudio=getAudioParameters(oldObject);
    	        ParameterObject[] newsaudio=getAudioParameters(newObject);
    	        if(!ArrayUtils.isEquals(oldsaudio,newsaudio)){
    	            subApplication.setNeedSave(true);
    	           
    	        }
    	        
    	        
    	        //reset sub.
    	        ParameterObject[] olds=getSubtitleParameters(oldObject);
    	        ParameterObject[] news=getSubtitleParameters(newObject);
    	        if(!ArrayUtils.isEquals(olds,news)){
    	            subApplication.setNeedSave(true);
    	            log.info("different");
    	            setSubtitleData(subApplication.getFile(),newObject);    
    	            waveFormFigureCanvas.getInFigure().setVisible(true);
    	        }
    	        
    	    }
    	    
            timeBaseFileObject=newObject;
        }
        
	    
	}
	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() {
		waveFormFigureCanvas.setFocus();
	}
    
	public void editFile(){
	    File file=subApplication.getFile();//return null?
	    log.info("file:"+file);
	    
	    if(editShell==null || editShell.isDisposed()){
	    
	    editShell=new Shell(shell);
	    editShell.setSize(640,400);
	    
	    TimeBaseFileWindow timeBase=new TimeBaseFileWindow(file,timeBaseFileObject,new EditExecuter(),editShell);
	    editShell.open();
	    }else{
	        log.info("edit-active:");
	        editShell.setActive();
	    }
	}
    public void openFile(){
        if(isPlayingAudio()){
            stop();
        }
        subApplication.openFile();
        //
        log.info(labelMove);
        
        currentStandardSubObject=null;//
        waveFormFigureCanvas.setRectangleRealValue(null);//unselect
        labelMove.updateButtons();
    }
    
    public void saveFile(){
        subApplication.saveFile();
    }
    
    public void saveAsFile(){
        subApplication.saveAsFile();
    }
    
    public void execLabel(int index){
        log.info("label:"+index);
        if(currentStandardSubObject!=null){
            if(index==1){
                currentStandardSubObject.setOption(null);//1 is null
                boolean changed=updateTimeBaseData(currentStandardSubObject);
                if(changed){
                    subApplication.setNeedSave(true);
                }
            }else if(index==0){
                log.warn("0 never called");
            }else{
                currentStandardSubObject.setOption(""+index);
                boolean changed=updateTimeBaseData(currentStandardSubObject);
                if(changed){
                    subApplication.setNeedSave(true);
                }
            }
            waveFormFigureCanvas.getInFigure().repaint();
        }
        
        labelMove.updateButtons();
    }

    /**
     * @param currentStandardSubObject2
     */
    private boolean updateTimeBaseData(StandardSubObject subObject) {
        int subtitleIndex=checkSubtitleIndex(subObject);
        if(subtitleIndex==-1){
            log.warn("subtitle value wrong");
        }
        TimeParameterObject timeObject=findTimeObject(subObject,subtitleIndex);
        if(timeObject==null){
            String subObjectValue=subObject.getOption();
            if(subObjectValue!=null){
                //create
                TimeParameterObject newTime=new TimeParameterObject();
                newTime.setStartTime(subObject.getStartTime());
                newTime.setEndTime(subObject.getEndTime());
                newTime.setName(getSubtitlePathName(subtitleIndex));
                newTime.setValue(subObjectValue);
                timeBaseFileObject.addTimeParameter(newTime);
                log.info("add-time:"+newTime);
                return true;
            }
           
            
        }else{
            String subObjectValue=subObject.getOption();
            if(subObjectValue==null){
                subObjectValue="1";
               
            }
            if(!timeObject.getValue().equals(subObjectValue)){
                if(subObjectValue.equals("1")){
                    timeBaseFileObject.removeTimeParameter(timeObject);//default is empty
                    log.info("remove-time:");
                }else{
                    timeObject.setValue(subObjectValue);  
                    log.info("edit-time:"+timeObject);
                }
                
                return true;
            }
        }
        return false;
    }

    /**
     * @param subObject
     * @param subtitleIndex
     * @return
     */
    private TimeParameterObject findTimeObject(StandardSubObject subObject, int subtitleIndex) {
        TimeParameterObject[] timeObjects=timeBaseFileObject.getTimeParameters();
        String timeObjectName=getSubtitlePathName(subtitleIndex);
        for(int i=0;i<timeObjects.length;i++){
          if(  timeObjects[i].getName().equals(timeObjectName) && timeObjects[i].getStartTime()==subObject.getStartTime() && timeObjects[i].getEndTime()==subObject.getEndTime()){
                return timeObjects[i];
            }
        }
        return null;
    }

    private String getSubtitlePathName(int subtitleIndex){
        ParameterObject[] subs=getSubtitleParameters(timeBaseFileObject);
        if(subs.length<subtitleIndex){
            log.warn("invalid index");
            return null;
        }
        return subs[subtitleIndex].getValue();
    }
    /**
     * @param subObject
     * @return
     */
    private int checkSubtitleIndex(StandardSubObject subObject) {
        
        for(int i=0;i<srtListFigures.length;i++){
            for(int j=0;j<srtListFigures[i].getStandardSubObjectList().size();j++){
                if(srtListFigures[i].getStandardSubObjectList().get(j)==subObject){
                    return i;
                }
            }     
       }
        return -1;
    }
    
    private StandardSubObject findFirstSub(int index){
       
        if(srtListFigures.length>index){
            
            if(srtListFigures[index].getStandardSubObjectList()==null){
                return null;
            }
            
            if(srtListFigures[index].getStandardSubObjectList().size()>0){
                return (StandardSubObject)srtListFigures[0].getStandardSubObjectList().get(0);
            }
            
            
        }
       return null;
    }
    
    private StandardSubObject findFirstSub(int index,String value){
        
         if(srtListFigures.length>index){
             
             if(srtListFigures[index].getStandardSubObjectList()==null){
                 return null;
             }
             
             for(int i=0;i<srtListFigures[index].getStandardSubObjectList().size();i++){
                 StandardSubObject sub=(StandardSubObject)srtListFigures[index].getStandardSubObjectList().get(i);
                 if(ObjectUtils.equals(sub.getOption(),value)){
                     return sub;
                 }
             }
             
             
         }
        return null;
     }
    
    private StandardSubObject findPrevSubtitle(StandardSubObject subtitle,boolean isSame){
        
        for(int i=0;i<srtListFigures.length;i++){
            for(int j=0;j<srtListFigures[i].getStandardSubObjectList().size();j++){
            if(srtListFigures[i].getStandardSubObjectList().get(j)==subtitle){
                for(int k=j-1;k>=0;k--){
                    StandardSubObject nextSubtitle=(StandardSubObject)srtListFigures[i].getStandardSubObjectList().get(k);
                    if(isSame){
                        if(ObjectUtils.equals(subtitle.getOption(),nextSubtitle.getOption())){
                            return nextSubtitle;
                        }
                    }else{
                        return nextSubtitle;
                    }
                }
                return null;
            }
            }
            
        }   
        
        return null;
    }
    
    
    private StandardSubObject findNextSubtitle(StandardSubObject subtitle,boolean isSame){
        
        for(int i=0;i<srtListFigures.length;i++){
            for(int j=0;j<srtListFigures[i].getStandardSubObjectList().size();j++){
            if(srtListFigures[i].getStandardSubObjectList().get(j)==subtitle){
                for(int k=j+1;k<srtListFigures[i].getStandardSubObjectList().size();k++){
                    StandardSubObject nextSubtitle=(StandardSubObject)srtListFigures[i].getStandardSubObjectList().get(k);
                    if(isSame){
                        if(ObjectUtils.equals(subtitle.getOption(),nextSubtitle.getOption())){
                            return nextSubtitle;
                        }
                    }else{
                        return nextSubtitle;
                    }
                }
                return null;
            }
            }
            
        }   
        
        return null;
    }
    private int getSubtitleIndex(StandardSubObject subtitle){
        for(int i=0;i<srtListFigures.length;i++){
            for(int j=0;j<srtListFigures[i].getStandardSubObjectList().size();j++){
            if(srtListFigures[i].getStandardSubObjectList().get(j)==subtitle){
                return i;
            }
            }
            
        }        
        return -1;
    }
    
    public void moveSubtitleNext(){
        
        StandardSubObject sub=null;
        int index=0;
        if(currentStandardSubObject==null){
        sub    =findFirstSub(0);
            index=0;
           
        }else{
            sub=findNextSubtitle(currentStandardSubObject,false);
            index=getSubtitleIndex(currentStandardSubObject);
        }
        
        if(sub!=null){
            
            selectSubtitle(index,sub);
            }
    }
    
    public void moveSubtitlePrev(){
        StandardSubObject sub=null;
        int index=0;
        if(currentStandardSubObject==null){
        sub    =findFirstSub(0);
            index=0;
        }else{
            sub=findPrevSubtitle(currentStandardSubObject,false);
            index=getSubtitleIndex(currentStandardSubObject);
        }
        
        if(sub!=null){
            selectSubtitle(index,sub);
            }
    }
    
    public void moveSubtitleLabelNext(){
        StandardSubObject sub=null;
        int index=0;
        if(currentStandardSubObject==null){
        sub    =findFirstSub(0);
            index=0;
           
        }else{
            sub=findNextSubtitle(currentStandardSubObject,true);
          //  log.info("find:"+sub);
            index=getSubtitleIndex(currentStandardSubObject);
        }
        
        if(sub!=null){
            
            selectSubtitle(index,sub);
            }
    }
    
    public void moveSubtitleLabelPrev(){
        StandardSubObject sub=null;
        int index=0;
        if(currentStandardSubObject==null){
        sub    =findFirstSub(0);
            index=0;
        }else{
            sub=findPrevSubtitle(currentStandardSubObject,true);
          //  log.info("find:"+sub);
            index=getSubtitleIndex(currentStandardSubObject);
        }
        
        if(sub!=null){
            selectSubtitle(index,sub);
            }
    }
    
    public void selectSubtitle(int index,StandardSubObject subtitle){
        	log.info("index:"+index+" sub:"+subtitle);
            int dx1=timeToRealValue(subtitle.getStartTime());
            int dx2=timeToRealValue(subtitle.getEndTime());
            currentStandardSubObject=subtitle;
            waveFormFigureCanvas.setSelectRealValue(dx1,dx2);
            
            waveFormFigureCanvas.setRectangleRealValue(new Rectangle(dx1,toSubtitleY(index),dx2-dx1,toSubtitleHeight(index)));
            
            int firstX=waveFormFigureCanvas.realToCanvasValue(dx1);
            if(firstX<8){//TODO 8 is magic number.
                waveFormFigureCanvas.scrollToX(waveFormFigureCanvas.getHorizontalBar().getSelection()+Math.min(-200,firstX+8-100));
            }
            int lastX=waveFormFigureCanvas.realToCanvasValue(dx2);
            //log.info("firstX="+lastX+",canvas:"+waveFormFigureCanvas.getInFigure().getClientArea());
            if(lastX>waveFormFigureCanvas.getClientArea().width){
                int scrollValue=Math.max(200,lastX-waveFormFigureCanvas.getClientArea().width+100);
                log.info("client="+waveFormFigureCanvas.getClientArea().width+",lastX="+lastX+",scroll:"+scrollValue);
                waveFormFigureCanvas.scrollToX(waveFormFigureCanvas.getHorizontalBar().getSelection()+scrollValue);
            }
            
            labelMove.updateButtons();
            //log.info("button-updated");
            if(index==0){
                setLayerData(getSubtitleBaseFile(index),subtitleShowText1,subtitle);
                
            }else if(index==1){
                setLayerData(getSubtitleBaseFile(index),subtitleShowText2,subtitle);
                
            }else{
                log.warn("currently don't support");
            }
    }
    
    public class SubViewLabelControler implements LabelControler{

        public StandardSubObject prev(int index1,int index2){
            if(srtListFigures==null || srtListFigures[index1]==null){
                return null;
            }
            log.info("prev");
            
            if(index1<srtListFigures.length && srtListFigures[index1].getStandardSubObjectList().size()>0){
                if(currentStandardSubObject!=null){
                    int currentIndex=getSubtitleIndex(currentStandardSubObject);
                    if(currentIndex==index1){
                        if(index2==0){
                            //any sub
                            return findPrevSubtitle(currentStandardSubObject,false);
                            
                        }else{
                            String indexValue=null;
                            if(index2>1){
                                indexValue=""+index2;
                            }
                            
                            if(ObjectUtils.equals(currentStandardSubObject.getOption(),indexValue)){
                                return findPrevSubtitle(currentStandardSubObject,true);
                            }else{
                                return findFirstSub(index1,indexValue);
                            }
                            
                        }
                    }else{
                        return findFirstSub(index1);//may select first sub;
                    }
                }else{
                    return findFirstSub(index1);//may select first sub;
                }
            }
            return null;
        }
        
        public StandardSubObject next(int index1,int index2){
            log.trace("next");
            if(srtListFigures==null || srtListFigures[index1]==null){
                return null;
            }
            
            if(index1<srtListFigures.length && srtListFigures[index1].getStandardSubObjectList().size()>0){
                if(currentStandardSubObject!=null){
                    int currentIndex=getSubtitleIndex(currentStandardSubObject);
                    if(currentIndex==index1){
                        if(index2==0){
                            //any sub
                            return findNextSubtitle(currentStandardSubObject,false);
                            
                        }else{
                            String indexValue=null;
                            if(index2>1){
                                indexValue=""+index2;
                            }
                            
                            if(ObjectUtils.equals(currentStandardSubObject.getOption(),indexValue)){
                                return findNextSubtitle(currentStandardSubObject,true);
                            }else{
                                return findFirstSub(index1,indexValue);
                            }
                            
                        }
                    }else{
                        return findFirstSub(index1);//may select first sub;
                    }
                }else{
                    return findFirstSub(index1);//may select first sub;
                }
            }
            return null;
        }
        /* (non-Javadoc)
         * @see org.jpn.xucker.rcp.subplayer.LabelControler#canMoveNext(int, int)
         */
        public boolean canMoveNext(int index1, int index2) {
            return next(index1,index2)!=null;
        }

        /* (non-Javadoc)
         * @see org.jpn.xucker.rcp.subplayer.LabelControler#canMovePrev(int, int)
         */
        public boolean canMovePrev(int index1, int index2) {
            return prev(index1,index2)!=null;
        }

        /* (non-Javadoc)
         * @see org.jpn.xucker.rcp.subplayer.LabelControler#moveNext(int, int)
         */
        public void moveNext(int index, int index2) {
            StandardSubObject sub=next(index,index2);
            if(sub!=null){
                selectSubtitle(index,sub);
            }
        }

        /* (non-Javadoc)
         * @see org.jpn.xucker.rcp.subplayer.LabelControler#movePrev(int, int)
         */
        public void movePrev(int index, int index2) {
            StandardSubObject sub=prev(index,index2);
            if(sub!=null){
                selectSubtitle(index,sub);
            }
        }

        /* (non-Javadoc)
         * @see org.jpn.xucker.rcp.subplayer.label.LabelControler#changed(int, int)
         */
        public void changed(int index, int index2) {
           //do nothing??   
        }
        
    }
    
    public void singleRepeat(){

        if(isPlayingAudio() || currentStandardSubObject==null){
            log.trace("do nothing:now playing or current null");
            return;
        }
        stopped=false;
        playButton.setEnabled(false);
        
        
        multiTimeAudioPlayer=new MultiTimeAudioPlayer();
        multiTimeAudioPlayer.setWaitTime(SubplayerPlugin.getDefault().getPreferenceStore().getInt(SubPlayPage.SUBPLAY_WAIT));
        multiTimeAudioPlayer.setMultiTimeAudioListener(new SubViewMultiTimeAudioListener());
        int cIndex=getSubtitleIndex(currentStandardSubObject);
            
        
            multiTimeAudioPlayer.addData(currentStandardSubObject);
            multiTimeAudioPlayer.setIndex(cIndex);
            multiTimeAudioPlayer.setPlayPattern(new int[]{PlayPatternComposite.FOREEVER});
            //set expand
            //set wait
            multiTimeAudioPlayer.setAudioFile(audioFile);
            
            MultiTimeAudioPlayerPlay thread=new MultiTimeAudioPlayerPlay(multiTimeAudioPlayer);
            thread.start();//for bg play.
        
    }
    public void playRepeat(){
        if(isPlayingAudio()){
            log.trace("do nothing:now playing");
            return;
        }
        stopped=false;
        playButton.setEnabled(false);
        
        
         multiTimeAudioPlayer=new MultiTimeAudioPlayer();
         multiTimeAudioPlayer.setRepeat(playPattern.isLoop());
         
         multiTimeAudioPlayer.setWaitTime(SubplayerPlugin.getDefault().getPreferenceStore().getInt(SubPlayPage.SUBPLAY_WAIT));
         multiTimeAudioPlayer.setExtendTime(SubplayerPlugin.getDefault().getPreferenceStore().getInt(SubPlayPage.SUBPLAY_EXTEND));
         multiTimeAudioPlayer.setPlayPattern(playPattern.getPlayPattern());
         
        multiTimeAudioPlayer.setMultiTimeAudioListener(new SubViewMultiTimeAudioListener());
        int target=labelMove.getTarget();
        int label=labelMove.getLabel();
        log.info("play:target="+target+",label="+label);
        //create data
        if(srtListFigures[target].getStandardSubObjectList().size()>0){
            String option=null;
            if(label>1){
                option=""+label;
            }
            int cIndex=0;
            boolean isCheck=false;
            if(currentStandardSubObject!=null && getSubtitleIndex(currentStandardSubObject)==target){
                
                if(label==0 || ObjectUtils.equals(currentStandardSubObject.getOption(),option)){
                    isCheck=true;
                }
            }
            int index=0;
            
            for(int i=0;i<srtListFigures[target].getStandardSubObjectList().size();i++){
                StandardSubObject sub=(StandardSubObject) srtListFigures[target].getStandardSubObjectList().get(i);
                if(label==0 || ObjectUtils.equals(sub.getOption(),option)){
                    if(isCheck==true && sub==currentStandardSubObject){
                        cIndex=index;
                        log.info("cindex:"+index);
                    }
                    multiTimeAudioPlayer.addData(sub);
                    log.trace("addsub:"+sub);
                    index++;
                }
            }
            
            multiTimeAudioPlayer.setIndex(cIndex);
            //set expand
            //set wait
            multiTimeAudioPlayer.setAudioFile(audioFile);
            
            MultiTimeAudioPlayerPlay thread=new MultiTimeAudioPlayerPlay(multiTimeAudioPlayer);
            thread.start();//for bg play.
        }
        
        
    }
    public class MultiTimeAudioPlayerPlay extends Thread{
        MultiTimeAudioPlayer player;
        public MultiTimeAudioPlayerPlay(MultiTimeAudioPlayer player){
            this.player=player;
        }
        public void run(){
            player.play();
        }
    }
    
    public class SubViewMultiTimeAudioListener implements MultiTimeAudioListener{

        private PlayMove move;

        /* (non-Javadoc)
         * @see org.jpn.xucker.rcp.subplayer.MultiTimeAudioListener#play(org.jpn.xucker.subtitle.StandardSubObject)
         */
        public void play(StandardSubObject subtitle,long start,long end) {
            log.info("set:"+subtitle);
            shell.getDisplay().asyncExec(new SelectSubtitle(getSubtitleIndex(subtitle),subtitle));
            //start move?
            log.info("set-end:"+subtitle);
            
            
            if(move!=null){
                move.cancel();
            }
           duration=subtitle.getEndTime()-subtitle.getStartTime();
            
            shell.getDisplay().syncExec(new StartPlayMove(start));
           }
        
        public class StartPlayMove extends Thread{
            private long startTime;
            public StartPlayMove(long startTime){
                this.startTime=startTime;
            }
            public void run(){
                
                int value=(int)(timeToRealValue(startTime));
                log.trace("value="+value);
                move = new PlayMove(
                        value);
                Thread t=new Thread(move);
                t.start();
            }
        }

        /* (non-Javadoc)
         * @see org.jpn.xucker.rcp.subplayer.MultiTimeAudioListener#finish()
         */
        public void finishPlaying() {
            log.trace("finish");
            //stop move?
            stop();
        }

        /* (non-Javadoc)
         * @see org.jpn.xucker.rcp.subplayer.MultiTimeAudioListener#startPlaying()
         */
        public void startPlaying() {
            playMoveSelection=true;
            
        }
        
    }
    
    public class SelectSubtitle extends Thread{
        private int index;
        private StandardSubObject subtitle;
        
        public SelectSubtitle(int index,StandardSubObject subtitle){
            this.index=index;
            this.subtitle=subtitle;
        }
        public void run(){
            selectSubtitle(getSubtitleIndex(subtitle),subtitle);
            
        }
    }
}


 