/*
 * Created on 2005/06/22
 * Author aki@www.xucker.jpn.org
 * License Apache2.0 or Common Public License
 */
package org.jpn.xucker.rcp.subplayer.label;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

import org.apache.commons.lang.ArrayUtils;

/**
 * 
 *
 */
public class LabelMoveComposite extends Composite{
/**
     * @param parent
     * @param style
     */
    public LabelMoveComposite(Composite parent, int style) {
        super(parent, style);
        ButtonClick btc=new ButtonClick();
        GridLayout layout=new GridLayout(3,false);
        layout.marginHeight=0;
        layout.marginWidth=0;
        layout.verticalSpacing=0;
        this.setLayout(layout);
        prevButton = new Button(this,SWT.ARROW|SWT.LEFT);
        prevButton.addSelectionListener(btc);
        prevButton.setLayoutData(new GridData(GridData.FILL_VERTICAL));
        Composite center=new Composite(this,SWT.NULL);
        nextButton = new Button(this,SWT.ARROW|SWT.RIGHT);
        nextButton.setLayoutData(new GridData(GridData.FILL_VERTICAL));
        nextButton.addSelectionListener(btc);
        GridLayout centerLayout=new GridLayout();
        centerLayout.marginHeight=0;
        centerLayout.marginWidth=0;
        center.setLayout(centerLayout);
        targetCombo = new CCombo(center,SWT.NULL);
        targetCombo.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        targetCombo.addSelectionListener(new ComboChange());
        
        
        
        Composite cp=new Composite(center,SWT.NULL);
        cp.setSize(32,32);
        cp.setLayout(new GridLayout(2,false));
        colorBG = new Composite(cp,SWT.NULL);
        GridData data1=new GridData();
        data1.heightHint=16;
        data1.widthHint=16;
        colorBG.setLayoutData(data1);
        labelCombo = new CCombo(cp,SWT.READ_ONLY);
        labelCombo.addSelectionListener(new ComboChange());
        
        updateButtons();
    }
    
private LabelControler labelControler;

private String targets[];
private Color colors[];
private String labels[];
private Composite colorBG;
private CCombo labelCombo;
private CCombo targetCombo;

private Color nullColor=new Color(null,0xEC,0XE9,0XD8);

private int lastSelection;

private Button prevButton;

private Button nextButton;

public class ButtonClick implements SelectionListener{

    /* (non-Javadoc)
     * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
     */
    public void widgetSelected(SelectionEvent e) {
        if(labelControler!=null){
            if(e.getSource()==prevButton){
                labelControler.movePrev(targetCombo.getSelectionIndex(),labelCombo.getSelectionIndex());
                 
            }else if(e.getSource()==nextButton){
            labelControler.moveNext(targetCombo.getSelectionIndex(),labelCombo.getSelectionIndex());
            }
            
            updateButtons();
        }
    }

    /* (non-Javadoc)
     * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
     */
    public void widgetDefaultSelected(SelectionEvent e) {
        // TODO Auto-generated method stub
        
    }
    
}
public int getTarget(){
    return targetCombo.getSelectionIndex();
}
public int getLabel(){
    return labelCombo.getSelectionIndex();
}
public void comboChanged(){
    lastSelection=labelCombo.getSelectionIndex();
    if(colors[labelCombo.getSelectionIndex()]!=null){
        colorBG.setBackground(colors[labelCombo.getSelectionIndex()]);
        
    }else{
        colorBG.setBackground(nullColor);
        
    }
    colorBG.redraw();
    
  
    updateButtons();
    labelControler.changed(targetCombo.getSelectionIndex(),labelCombo.getSelectionIndex());
    
}
public void updateButtons(){
    boolean canPrev=false;
    if(labelControler!=null){
        canPrev=labelControler.canMovePrev(targetCombo.getSelectionIndex(),labelCombo.getSelectionIndex());
    }
    prevButton.setEnabled(canPrev);
    
    boolean canNext=false;
    if(labelControler!=null){
        canNext=labelControler.canMoveNext(targetCombo.getSelectionIndex(),labelCombo.getSelectionIndex());
    }
    nextButton.setEnabled(canNext);
}
public void selectLabel(int index){
    labelCombo.select(index);
   
    comboChanged();
}
public class ComboChange implements SelectionListener{

    /* (non-Javadoc)
     * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
     */
    public void widgetSelected(SelectionEvent e) {
       comboChanged();
        
    }

    /* (non-Javadoc)
     * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
     */
    public void widgetDefaultSelected(SelectionEvent e) {
       
    }
    
}

public void addTarget(String name){
    targets=(String[]) ArrayUtils.add(targets,name);
    targetCombo.add(name);
    if(targetCombo.getItemCount()==1){
        targetCombo.select(0);
    }
}

public void addLabel(String label,Color color){
    colors= (Color[]) ArrayUtils.add(colors,color);
    labels=(String[]) ArrayUtils.add(labels,label);
    labelCombo.add(label);
    if(labelCombo.getItemCount()==1){
        labelCombo.select(0);
    }
}


public void initComposite(){
    targetCombo.removeAll();
    labelCombo.removeAll();
    colors=new Color[0];
    labels=new String[0];
    targets=new String[0];
}

public int getLastSelection() {
    return lastSelection;
}
public void setLastSelection(int lastSelection) {
    this.lastSelection = lastSelection;
}
public LabelControler getLabelControler() {
    return labelControler;
}
public void setLabelControler(LabelControler labelControler) {
    this.labelControler = labelControler;
}
}
