/*
 * Created on 2005/06/21
 * Author aki@www.xucker.jpn.org
 * License Apache2.0 or Common Public License
 */
package org.jpn.xucker.rcp.subplayer;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.commons.audio.AudioListener;
import org.jpn.xucker.commons.audio.AudioStopper;
import org.jpn.xucker.commons.audio.WaveUtils;
import org.jpn.xucker.mp3.JavaLayerMP3Player;
import org.jpn.xucker.mp3.MP3Utils;
import org.jpn.xucker.rcp.subplayer.views.SubView;
import org.jpn.xucker.rcp.subplayer.views.SubView.LoadWave;
import org.jpn.xucker.subtitle.StandardSubObject;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

/**
 * 
 *
 */
public class MultiTimeAudioPlayer {
private JavaLayerMP3Player mp3Player=new JavaLayerMP3Player();

    public static Log log=LogFactory.getLog(MultiTimeAudioPlayer.class);
    
private StandardSubObject timeDatas[]=new StandardSubObject[0];

private int index;

private int extendTime;
private int waitTime;



private File audioFile;
private AudioFormat audioFormat;

private boolean repeat;

private MultiTimeAudioListener multiTimeAudioListener;

public int playPattern[];

public void removeAll(){
    timeDatas=new StandardSubObject[0];
    index=0;
}

public void addData(StandardSubObject subs){
    timeDatas=(StandardSubObject[]) ArrayUtils.add( timeDatas,subs);
}

public void play(){
    stopped=false;
    mp3Player.setStopper(new MP3Stopper());
    log.info("play:subtitles="+timeDatas.length);
    if(audioFile==null){
        log.trace("audioFile=null");
        return;
    }
    
    
    int subIndex=index;
    
    if(multiTimeAudioListener!=null){
        multiTimeAudioListener.startPlaying();
    }
    open();
    
    while(!stopped){
    
        inLooped=false;
        
       
        for(int j=0;j<playPattern.length||playPattern[0]==PlayPatternComposite.FOREEVER ;j++){
            if(playPattern[0]==PlayPatternComposite.FOREEVER || playPattern[j]==PlayPatternComposite.PLAY){
            play(timeDatas[subIndex]);
            }else{
                int time=(int)(timeDatas[subIndex].getEndTime()-timeDatas[subIndex].getStartTime());
                log.trace("mute:"+time);
                
                if(multiTimeAudioListener!=null){
                    multiTimeAudioListener.play(timeDatas[subIndex],timeDatas[subIndex].getStartTime(),timeDatas[subIndex].getEndTime());
                }
                
                sleep(time);//mute
            }
            
            inLooped=true;
            if(stopped){
                break;
            }
            
            if(j!=playPattern.length-1){
                sleep(waitTime);//call sleep at last .
            }
        }
        
        
        
    
        subIndex++;//TODO support reverse.
        
        if(subIndex>=timeDatas.length){
            if(repeat){
                subIndex=0;
                lastEnd=0;
                sleep(waitTime);
            }else{
                break;
            }
        }else{
           sleep(waitTime);
            
        }
        
    }
    
    if(multiTimeAudioListener!=null){
        multiTimeAudioListener.finishPlaying();
    }
    
    close();
    
    stopped=true;//for normal play end.
}

private void sleep(int time){
    if(stopped){
        return;
    }
    log.trace("sleep:"+time);
    try {
        //wait
        Thread.sleep(time);
    } catch (InterruptedException e) {
        // TODO Auto-generated catch block
        e.printStackTrace();
    }
}

long lastEnd=0;
boolean inLooped;
private void play(StandardSubObject sub){
    long start=sub.getStartTime()-extendTime;
    
    if(inLooped==false){
        start=Math.max(start,lastEnd);
    }
    
    long end=sub.getEndTime()+extendTime;
    lastEnd=end;
    
        if(multiTimeAudioListener!=null){
            multiTimeAudioListener.play(sub,start,end);
        }
        playFile(audioFile,start,end);
    
}

public AudioInputStream toAudioInputStream(){
    if(TimeBaseFileObjectReadUtils.isMP3File(audioFile.getName())){
        try {
            return MP3Utils.toPCMAudioInputStream(new FileInputStream(audioFile));
        } catch (FileNotFoundException e) {
           
            e.printStackTrace();
        } catch (UnsupportedAudioFileException e) {
            
            e.printStackTrace();
        } catch (IOException e) {
           
            e.printStackTrace();
        }
    }else{
        try {
            return AudioSystem.getAudioInputStream(audioFile);
        } catch (UnsupportedAudioFileException e) {
           
            e.printStackTrace();
        } catch (IOException e) {
            
            e.printStackTrace();
        }
    }
    return null;
}

public void playFile(File file,long start,long end){
    if(TimeBaseFileObjectReadUtils.isMP3File(file.getName())){
        log.info("mp3-play:"+start+","+end);
        mp3Player.play(file,start,end);
    }else{
        try {
            playByte(toAudioInputStream(),WaveUtils.millisecondToSample(start,audioFormat.getSampleRate()),WaveUtils.millisecondToSample(end,audioFormat.getSampleRate()));
        } catch (UnsupportedAudioFileException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (LineUnavailableException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }
}

public void playByte(AudioInputStream audioInputStream,long startSample,long endSample) throws UnsupportedAudioFileException, IOException, LineUnavailableException{
    log.info("play-byte");	
    AudioFormat format =audioInputStream.getFormat();
    log.trace("audioFormat:"+format);
        long playByte=(endSample-startSample)*format.getChannels()*2;//2=16bit   
        
        //skip
         audioInputStream.skip(startSample*format.getChannels()*(format.getSampleSizeInBits()/8));//2=16bit);
      
         int readBytes = 0;
         int buffersize=1024;//256
         int bbyte=64;
         byte[] bytedata = new byte[buffersize];
         long readedByte=0;
         
         boolean isStart=false;// for audioStart.
         
         long playStart=0;
         while (readBytes != -1) {
             
             if(isStopped()){
                 execClose(audioInputStream);
                 execStop();
                 return;
             } 
          readBytes = audioInputStream.read(bytedata, 0, bytedata.length);
       //   log.trace("readbytes:"+readBytes);
          //System.out.println("readBytes:"+readBytes);
          if (readBytes > 0) { 
       //   if (readBytes >= 0) { //why neeed 0?
               if(isStart==false){
                   execStart();
                   playStart=System.currentTimeMillis();
                   isStart=true;
               }
            
               if(isStopped()){
                   execClose(audioInputStream);
                   execStop();
                   return;
               }
               
               if(readedByte+readBytes<playByte || endSample==0){
               readedByte+=readBytes;
               int writed=line.write(bytedata, 0, readBytes);
              // log.trace("writed:"+writed);
               }else{
               //byte[] tmpbyte=new byte[buffersize];
               //int min=Math.min(0,(int)(playByte-readedByte));
               //System.arraycopy(bytedata,0,tmpbyte,0,min);
               //line.write(tmpbyte, 0, readBytes);  //about
                   int writebyte=Math.min((int)(playByte-readedByte),readBytes);
                   
                   //becouse of error
                   int p=writebyte/bbyte;
                   if(writebyte%bbyte!=0){
                       p++;
                   }
                   int shoudread=p*bbyte;
                   log.trace("writing:"+shoudread); 
                   
                   int writed=line.write(bytedata,0,shoudread);//
                   log.trace("writed:"+writed);
               readedByte+=readBytes;
               break;
               }
               
           }
         }
         
         log.trace("readedByte:"+readedByte);
         long playsample=readedByte/format.getChannels()/(format.getSampleSizeInBits()/8);
         log.trace("playsample:"+playsample);
         long playtime=WaveUtils.sampleToMillisecond(playsample,format.getFrameRate());
         log.trace("playtime:"+playtime);
         
         while(System.currentTimeMillis()<playStart+playtime){
             if(stopped){
                 execClose(audioInputStream);
                 execStop();
                 return;
             }
             try {
                 
                 Thread.sleep(10);
           
             } catch (InterruptedException e) {
                 
                 e.printStackTrace();
             }
         }
         execFinish();
         
 }

public void execClose(AudioInputStream stream){
    try {
        stream.close();
    } catch (IOException e) {
       
        e.printStackTrace();
    }
    close();
}
public void execStart(){
    log.trace("start");
}

public void execStop(){
log.trace("close");    
}

public void execFinish(){
    log.info("finish");
}

public boolean isStopped(){
    return stopped;
}


private void open(){
    log.info("open");
    if(audioFile==null){
        log.trace("audioFile=null");
        return;
    }
    
    info = new DataLine.Info(SourceDataLine.class,audioFormat);
    try {
        line = (SourceDataLine) AudioSystem.getLine(info);
        line.open(audioFormat);
        line.start();
    } catch (LineUnavailableException e) {
       
        e.printStackTrace();
    }
   
}
private void close(){
    log.info("close");
    if(line!=null){
    line.stop();
    line.close();
    }
    line=null;
    info=null;
}


public class MP3Stopper implements AudioStopper{
    public void init(){
        
    }

    /* (non-Javadoc)
     * @see org.jpn.xucker.commons.audio.AudioStopper#isStopped()
     */
    public boolean isStopped() {
        
        return stopped;
    }

    /* (non-Javadoc)
     * @see org.jpn.xucker.commons.audio.AudioStopper#setStopped(boolean)
     */
    public void setStopped(boolean bool) {
        //do nothing.
    }
}
public void stop(){
    stopped=true;
    Thread.interrupted();//wave up.
    
}

private boolean stopped=true;
private AudioListener audioListener;

private DataLine.Info info;

private SourceDataLine line;
public class MyAudioListener implements AudioListener{

    /* (non-Javadoc)
     * @see org.jpn.xucker.commons.audio.AudioListener#startPlaying()
     */
    public void startPlaying() {
        
        if(audioListener!=null){
            audioListener.startPlaying();
        }
    }

    /* (non-Javadoc)
     * @see org.jpn.xucker.commons.audio.AudioListener#stopPlaying()
     */
    public void stopPlaying() {
        if(audioListener!=null){
            audioListener.stopPlaying();
        }
    }

    /* (non-Javadoc)
     * @see org.jpn.xucker.commons.audio.AudioListener#finishPlaying()
     */
    public void finishPlaying() {
        if(audioListener!=null){
            audioListener.finishPlaying();
        }
    }
    
}
public class Stopper implements AudioStopper{

    /* (non-Javadoc)
     * @see org.jpn.xucker.commons.audio.AudioStopper#isStopped()
     */
    public boolean isStopped() {
        
        return stopped;
    }

    /* (non-Javadoc)
     * @see org.jpn.xucker.commons.audio.AudioStopper#setStopped(boolean)
     */
    public void setStopped(boolean bool) {
        
    }
    
}

public File getAudioFile() {
    return audioFile;
}
public void setAudioFile(File audioFile) {
    this.audioFile = audioFile;
    audioFormat=toAudioFormat(audioFile);
    log.info(audioFormat);
}

/**
 * @param audioFile2
 * @return
 */
private AudioFormat toAudioFormat(File audioFile2) {
    if(audioFile2==null){
        return null;
    }
    AudioFormat format=null;
    try {
        if(TimeBaseFileObjectReadUtils.isMP3File(audioFile.getName())){
            AudioFormat mp3Format=MP3Utils.getAudioFormat(new FileInputStream(audioFile));
            format = new AudioFormat(
                    AudioFormat.Encoding.PCM_SIGNED,
                    mp3Format.getSampleRate(),
                    16,
                    mp3Format.getChannels(),
                    mp3Format.getChannels() * 2,
                    mp3Format.getSampleRate(),
                    false);
                
                //
        }else{
        format = WaveUtils.getAudioFormat(audioFile);
        }
    } catch (UnsupportedAudioFileException e1) {
        e1.printStackTrace();
    } catch (IOException e1) {
        e1.printStackTrace();
    }
    return format;
}
public int getIndex() {
    return index;
}
public void setIndex(int index) {
    this.index = index;
}
public MultiTimeAudioListener getMultiTimeAudioListener() {
    return multiTimeAudioListener;
}
public void setMultiTimeAudioListener(
        MultiTimeAudioListener multiTimeAudioListener) {
    this.multiTimeAudioListener = multiTimeAudioListener;
}
public int getExtendTime() {
    return extendTime;
}
public void setExtendTime(int extendTime) {
    this.extendTime = extendTime;
}

public int getWaitTime() {
    return waitTime;
}
public void setWaitTime(int waitTime) {
    this.waitTime = waitTime;
}
public int[] getPlayPattern() {
    return playPattern;
}
public void setPlayPattern(int[] playPattern) {
    this.playPattern = playPattern;
}
public boolean isRepeat() {
    return repeat;
}
public void setRepeat(boolean repeat) {
    this.repeat = repeat;
}
}
