/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.views;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.ICheatSheetAction;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.data.AbstractSubItem;
import org.eclipse.ui.internal.cheatsheets.data.Action;
import org.eclipse.ui.internal.cheatsheets.data.ConditionalSubItem;
import org.eclipse.ui.internal.cheatsheets.data.Item;
import org.eclipse.ui.internal.cheatsheets.data.RepeatedSubItem;
import org.eclipse.ui.internal.cheatsheets.data.SubItem;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetManager;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetViewer;
import org.eclipse.ui.internal.cheatsheets.views.StringDelimitedTokenizer;
import org.eclipse.ui.internal.cheatsheets.views.SubItemCompositeHolder;
import org.eclipse.ui.internal.cheatsheets.views.ViewItem;
import org.osgi.framework.Bundle;

public class CoreItem
extends ViewItem {
    protected boolean buttonsHandled = false;
    private ArrayList listOfSubItemCompositeHolders;

    public CoreItem(FormToolkit toolkit, ScrolledForm form, Item item, Color itemColor, CheatSheetViewer viewer) {
        super(toolkit, form, item, itemColor, viewer);
    }

    private void createButtonComposite() {
        this.buttonComposite = this.toolkit.createComposite(this.bodyWrapperComposite);
        GridLayout buttonlayout = new GridLayout(4, false);
        buttonlayout.marginHeight = 2;
        buttonlayout.marginWidth = 2;
        buttonlayout.verticalSpacing = 2;
        TableWrapData buttonData = new TableWrapData(128);
        this.buttonComposite.setLayout((Layout)buttonlayout);
        this.buttonComposite.setLayoutData((Object)buttonData);
        this.buttonComposite.setBackground(this.itemColor);
        Label spacer = this.toolkit.createLabel(this.buttonComposite, null);
        spacer.setBackground(this.itemColor);
        GridData spacerData = new GridData();
        spacerData.widthHint = 16;
        spacer.setLayoutData((Object)spacerData);
    }

    private void createButtons(Action action) {
        if (action != null) {
            final ImageHyperlink startButton = this.createButton(this.buttonComposite, CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_START"), this, this.itemColor, CheatSheetPlugin.getResourceString("%PERFORM_TASK_TOOLTIP"));
            this.toolkit.adapt((Control)startButton, true, true);
            startButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    CoreItem.this.viewer.runPerformAction(startButton);
                }
            });
        }
        if (this.item.isSkip()) {
            final ImageHyperlink skipButton = this.createButton(this.buttonComposite, CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_SKIP"), this, this.itemColor, CheatSheetPlugin.getResourceString("%SKIP_TASK_TOOLTIP"));
            this.toolkit.adapt((Control)skipButton, true, true);
            skipButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    CoreItem.this.viewer.advanceItem(skipButton, false);
                }
            });
        }
        if (action == null || action.isConfirm()) {
            final ImageHyperlink completeButton = this.createButton(this.buttonComposite, CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_COMPLETE"), this, this.itemColor, CheatSheetPlugin.getResourceString("%COMPLETE_TASK_TOOLTIP"));
            this.toolkit.adapt((Control)completeButton, true, true);
            completeButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    CoreItem.this.viewer.advanceItem(completeButton, true);
                }
            });
        }
    }

    private void createSubItemButtonComposite() {
        this.buttonComposite = this.toolkit.createComposite(this.bodyWrapperComposite);
        GridLayout xbuttonlayout = new GridLayout(6, false);
        xbuttonlayout.marginHeight = 2;
        xbuttonlayout.marginWidth = 2;
        xbuttonlayout.verticalSpacing = 2;
        TableWrapData xbuttonData = new TableWrapData(128);
        this.buttonComposite.setLayout((Layout)xbuttonlayout);
        this.buttonComposite.setLayoutData((Object)xbuttonData);
        this.buttonComposite.setBackground(this.itemColor);
    }

    private void createSubItemButtons(SubItem sub, String thisValue, int index) {
        int added = 0;
        Label checkDoneLabel = this.toolkit.createLabel(this.buttonComposite, null);
        checkDoneLabel.setBackground(this.itemColor);
        GridData checkDoneData = new GridData();
        checkDoneData.widthHint = 16;
        checkDoneLabel.setLayoutData((Object)checkDoneData);
        ++added;
        String labelText = null;
        labelText = thisValue != null ? this.performLineSubstitution(sub.getLabel(), "${this}", thisValue) : sub.getLabel();
        Label label = this.toolkit.createLabel(this.buttonComposite, labelText);
        label.setBackground(this.itemColor);
        ++added;
        Action subAction = null;
        if (sub.getPerformWhen() != null) {
            sub.getPerformWhen().setSelectedAction(this.viewer.getManager());
            subAction = sub.getPerformWhen().getSelectedAction();
        } else {
            subAction = sub.getAction();
        }
        final int fi = index;
        ImageHyperlink startButton = null;
        if (subAction != null) {
            ++added;
            final ImageHyperlink finalStartButton = startButton = this.createButton(this.buttonComposite, CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_START"), this, this.itemColor, CheatSheetPlugin.getResourceString("%PERFORM_TASK_TOOLTIP"));
            this.toolkit.adapt((Control)startButton, true, true);
            startButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    CoreItem.this.viewer.runSubItemPerformAction(finalStartButton, fi);
                }
            });
        }
        if (sub.isSkip()) {
            ++added;
            final ImageHyperlink skipButton = this.createButton(this.buttonComposite, CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_SKIP"), this, this.itemColor, CheatSheetPlugin.getResourceString("%SKIP_TASK_TOOLTIP"));
            this.toolkit.adapt((Control)skipButton, true, true);
            skipButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    CoreItem.this.viewer.advanceSubItem(skipButton, false, fi);
                }
            });
        }
        if (subAction == null || subAction.isConfirm()) {
            ++added;
            final ImageHyperlink completeButton = this.createButton(this.buttonComposite, CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_COMPLETE"), this, this.itemColor, CheatSheetPlugin.getResourceString("%COMPLETE_TASK_TOOLTIP"));
            this.toolkit.adapt((Control)completeButton, true, true);
            completeButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    CoreItem.this.viewer.advanceSubItem(completeButton, true, fi);
                }
            });
        }
        while (added < 6) {
            Label filler = this.toolkit.createLabel(this.buttonComposite, null);
            filler.setBackground(this.itemColor);
            ++added;
        }
        this.listOfSubItemCompositeHolders.add(new SubItemCompositeHolder(checkDoneLabel, startButton, thisValue, sub));
    }

    private Action getAction() {
        Action action = this.item.getAction();
        if (action == null && this.item.getPerformWhen() != null) {
            action = this.item.getPerformWhen().getSelectedAction();
        }
        return action;
    }

    private Action getAction(int index) {
        SubItemCompositeHolder s;
        if (this.item.getSubItems() != null && this.item.getSubItems().size() > 0 && this.listOfSubItemCompositeHolders != null && (s = (SubItemCompositeHolder)this.listOfSubItemCompositeHolders.get(index)) != null) {
            SubItem subItem = s.getSubItem();
            Action action = subItem.getAction();
            if (action == null && subItem.getPerformWhen() != null) {
                action = subItem.getPerformWhen().getSelectedAction();
            }
            return action;
        }
        return null;
    }

    public ArrayList getListOfSubItemCompositeHolders() {
        return this.listOfSubItemCompositeHolders;
    }

    private ImageHyperlink getStartButton() {
        if (this.buttonComposite != null) {
            Control[] controls = this.buttonComposite.getChildren();
            int i = 0;
            while (i < controls.length) {
                String toolTipText;
                Control control = controls[i];
                if (control instanceof ImageHyperlink && (toolTipText = control.getToolTipText()) != null && (toolTipText.equals(CheatSheetPlugin.getResourceString("%PERFORM_TASK_TOOLTIP")) || toolTipText.equals(CheatSheetPlugin.getResourceString("%RESTART_TASK_TOOLTIP")))) {
                    return (ImageHyperlink)control;
                }
                ++i;
            }
        }
        return null;
    }

    void handleButtons() {
        if (this.item.isDynamic()) {
            this.handleDynamicButtons();
            return;
        }
        if (this.item.getSubItems() != null && this.item.getSubItems().size() > 0) {
            try {
                this.handleSubButtons();
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, CheatSheetPlugin.getResourceString("%LESS_THAN_2_SUBITEMS"), (Throwable)e);
                CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)CheatSheetPlugin.getResourceString("%LESS_THAN_2_SUBITEMS"), null, (IStatus)status);
            }
        }
        if (this.buttonsHandled) {
            return;
        }
        this.createButtonComposite();
        this.createButtons(this.item.getAction());
        this.buttonsHandled = true;
    }

    private void handleDynamicButtons() {
        if (this.item.getSubItems() != null && this.item.getSubItems().size() > 0) {
            this.handleDynamicSubItemButtons();
        } else if (this.item.getPerformWhen() != null) {
            this.handlePerformWhenButtons();
        }
    }

    private void handleDynamicSubItemButtons() {
        boolean refreshRequired = false;
        if (this.buttonComposite != null) {
            Control[] children = this.buttonComposite.getChildren();
            int i = 0;
            while (i < children.length) {
                Control control = children[i];
                control.dispose();
                ++i;
            }
            refreshRequired = true;
        } else {
            this.createSubItemButtonComposite();
        }
        this.listOfSubItemCompositeHolders = new ArrayList(20);
        int i = 0;
        Iterator iter = this.item.getSubItems().iterator();
        while (iter.hasNext()) {
            Status status;
            String message;
            AbstractSubItem subItem = (AbstractSubItem)iter.next();
            if (subItem instanceof RepeatedSubItem) {
                RepeatedSubItem repeatedSubItem = (RepeatedSubItem)subItem;
                String values = repeatedSubItem.getValues();
                values = this.viewer.getManager().getVariableData(values);
                if (values == null || values.length() <= 0 || values.startsWith("${") && values.endsWith("}")) {
                    message = CheatSheetPlugin.formatResourceString("%ERROR_DATA_MISSING_LOG", new Object[]{repeatedSubItem.getValues()});
                    status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, null);
                    CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                    status = new Status(4, "org.eclipse.ui.cheatsheets", 0, CheatSheetPlugin.getResourceString("%ERROR_DATA_MISSING"), null);
                    CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                    ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, null, (IStatus)status);
                    break;
                }
                SubItem sub = (SubItem)repeatedSubItem.getSubItems().get(0);
                StringTokenizer tokenizer = new StringTokenizer(values, ",");
                while (tokenizer.hasMoreTokens()) {
                    String value = tokenizer.nextToken();
                    this.createSubItemButtons(sub, value, i++);
                }
                --i;
            } else if (subItem instanceof ConditionalSubItem) {
                ConditionalSubItem sub = (ConditionalSubItem)subItem;
                sub.setSelectedSubItem(this.viewer.getManager());
                SubItem selectedSubItem = sub.getSelectedSubItem();
                if (selectedSubItem == null) {
                    message = CheatSheetPlugin.formatResourceString("%ERROR_CONDITIONAL_DATA_MISSING_LOG", new Object[]{sub.getCondition(), this.getItem().getTitle()});
                    status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, null);
                    CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                    status = new Status(4, "org.eclipse.ui.cheatsheets", 0, CheatSheetPlugin.getResourceString("%ERROR_DATA_MISSING"), null);
                    CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                    ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, null, (IStatus)status);
                    break;
                }
                this.createSubItemButtons(selectedSubItem, null, i);
            } else if (subItem instanceof SubItem) {
                this.createSubItemButtons((SubItem)subItem, null, i);
            }
            ++i;
        }
        if (refreshRequired) {
            this.buttonComposite.layout();
            this.getMainItemComposite().layout();
            this.form.reflow(true);
        }
    }

    private void handlePerformWhenButtons() {
        boolean refreshRequired = false;
        if (this.buttonComposite != null) {
            Control[] controls = this.buttonComposite.getChildren();
            int i = 0;
            while (i < controls.length) {
                Control control = controls[i];
                if (control instanceof ImageHyperlink) {
                    control.dispose();
                }
                ++i;
            }
            refreshRequired = true;
        } else {
            this.createButtonComposite();
        }
        this.item.getPerformWhen().setSelectedAction(this.viewer.getManager());
        Action performAction = this.item.getPerformWhen().getSelectedAction();
        this.createButtons(performAction);
        if (refreshRequired) {
            this.buttonComposite.layout();
            this.getMainItemComposite().layout();
            this.form.reflow(true);
        }
    }

    private void handleSubButtons() throws Exception {
        if (this.buttonsHandled) {
            return;
        }
        this.listOfSubItemCompositeHolders = new ArrayList(20);
        ArrayList sublist = this.item.getSubItems();
        if (sublist == null || sublist.size() <= 1) {
            throw new Exception("%LESS_THAN_2_SUBITEMS");
        }
        this.createSubItemButtonComposite();
        int i = 0;
        while (i < sublist.size()) {
            this.createSubItemButtons((SubItem)sublist.get(i), null, i);
            ++i;
        }
        this.buttonsHandled = true;
    }

    boolean hasConfirm() {
        Action action = this.getAction();
        return action == null || action.isConfirm();
    }

    boolean hasConfirm(int index) {
        Action action = this.getAction(index);
        return action == null || action.isConfirm();
    }

    public String performLineSubstitution(String line, String variable, String value) {
        StringBuffer buffer = new StringBuffer(line.length());
        StringDelimitedTokenizer tokenizer = new StringDelimitedTokenizer(line, variable);
        boolean addValue = false;
        while (tokenizer.hasMoreTokens()) {
            if (addValue) {
                buffer.append(value);
            }
            buffer.append(tokenizer.nextToken());
            addValue = true;
        }
        if (tokenizer.endsWithDelimiter()) {
            buffer.append(value);
        }
        return buffer.toString();
    }

    byte runAction(CheatSheetManager csm) {
        Action action = this.getAction();
        if (action != null) {
            return this.runAction(action.getPluginID(), action.getActionClass(), action.getParams(), csm);
        }
        return 0;
    }

    byte runAction(String pluginId, String className, String[] params, CheatSheetManager csm) {
        IAction action;
        Class actionClass;
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            String message = CheatSheetPlugin.formatResourceString("%ERROR_FINDING_PLUGIN_FOR_ACTION", new Object[]{pluginId});
            Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, null);
            CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, (String)CheatSheetPlugin.getResourceString("%ERROR_RUNNING_ACTION"), (IStatus)status);
            return 1;
        }
        try {
            actionClass = bundle.loadClass(className);
        }
        catch (Exception e) {
            String message = CheatSheetPlugin.formatResourceString("%ERROR_LOADING_CLASS_FOR_ACTION", new Object[]{className});
            Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
            CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, (String)CheatSheetPlugin.getResourceString("%ERROR_RUNNING_ACTION"), (IStatus)status);
            return 1;
        }
        try {
            action = (IAction)actionClass.newInstance();
        }
        catch (Exception e) {
            String message = CheatSheetPlugin.formatResourceString("%ERROR_CREATING_CLASS_FOR_ACTION", new Object[]{className});
            Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
            CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, (String)CheatSheetPlugin.getResourceString("%ERROR_RUNNING_ACTION"), (IStatus)status);
            return 1;
        }
        final boolean[] listenerFired = new boolean[1];
        final boolean[] listenerResult = new boolean[1];
        IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("result") && event.getNewValue() instanceof Boolean) {
                    listenerFired[0] = true;
                    listenerResult[0] = (Boolean)event.getNewValue();
                }
            }
        };
        action.addPropertyChangeListener(propertyChangeListener);
        if (action instanceof ICheatSheetAction) {
            String[] clonedParams = null;
            if (params != null && params.length > 0) {
                clonedParams = new String[params.length];
                System.arraycopy(params, 0, clonedParams, 0, params.length);
                int i = 0;
                while (i < clonedParams.length) {
                    String param = clonedParams[i];
                    if (param != null && param.startsWith("${") && param.endsWith("}")) {
                        String value = csm.getData(param = param.substring(2, param.length() - 1));
                        clonedParams[i] = value == null ? "" : value;
                    }
                    ++i;
                }
            }
            ((ICheatSheetAction)action).run(clonedParams, csm);
        } else {
            action.run();
        }
        action.removePropertyChangeListener(propertyChangeListener);
        if (listenerFired[0]) {
            if (listenerResult[0]) {
                return 0;
            }
            return 1;
        }
        return 0;
    }

    byte runSubItemAction(CheatSheetManager csm, int index) {
        Action action;
        SubItemCompositeHolder s;
        if (this.item.getSubItems() != null && this.item.getSubItems().size() > 0 && this.listOfSubItemCompositeHolders != null && (s = (SubItemCompositeHolder)this.listOfSubItemCompositeHolders.get(index)) != null && (action = this.getAction(index)) != null) {
            try {
                if (s.getThisValue() != null) {
                    csm.setData("this", s.getThisValue());
                }
                String[] params = action.getParams();
                byte by = this.runAction(action.getPluginID(), action.getActionClass(), params, csm);
                Object var6_7 = null;
                if (s.getThisValue() != null) {
                    csm.setData("this", null);
                }
                return by;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (s.getThisValue() != null) {
                    csm.setData("this", null);
                }
                throw throwable;
            }
        }
        return 0;
    }

    void setButtonsHandled(boolean handled) {
        this.buttonsHandled = handled;
    }

    void setIncomplete() {
        super.setIncomplete();
        ArrayList l = this.getListOfSubItemCompositeHolders();
        if (l != null) {
            int j = 0;
            while (j < l.size()) {
                SubItemCompositeHolder s = (SubItemCompositeHolder)l.get(j);
                if (s.isCompleted() || s.isSkipped()) {
                    s.getIconLabel().setImage(null);
                }
                if (s.startButton != null) {
                    s.getStartButton().setImage(CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_START"));
                    s.getStartButton().setToolTipText(CheatSheetPlugin.getResourceString("%PERFORM_TASK_TOOLTIP"));
                }
                ++j;
            }
        }
    }

    void setRestartImage() {
        ImageHyperlink startButton = this.getStartButton();
        if (startButton != null) {
            startButton.setImage(CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_RESTART"));
            startButton.setToolTipText(CheatSheetPlugin.getResourceString("%RESTART_TASK_TOOLTIP"));
        }
    }

    void setStartImage() {
        ImageHyperlink startButton = this.getStartButton();
        if (startButton != null) {
            startButton.setImage(CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_START"));
            startButton.setToolTipText(CheatSheetPlugin.getResourceString("%PERFORM_TASK_TOOLTIP"));
        }
    }
}

