/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.console;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.console.AbstractConsole;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.internal.console.MessageConsolePage;
import org.eclipse.ui.internal.console.MessageConsolePartitioner;
import org.eclipse.ui.part.IPageBookViewPage;

public class MessageConsole
extends AbstractConsole {
    private Font fFont = null;
    public static final String P_FONT = String.valueOf(ConsolePlugin.getUniqueIdentifier()) + ".P_FONT";
    public static final String P_STREAM_COLOR = String.valueOf(ConsolePlugin.getUniqueIdentifier()) + ".P_STREAM_COLOR";
    public static final String P_TAB_SIZE = String.valueOf(ConsolePlugin.getUniqueIdentifier()) + ".P_TAB_SIZE";
    public static final int DEFAULT_TAB_SIZE = 8;
    private MessageConsolePartitioner fPartitioner = new MessageConsolePartitioner();
    private int tabWidth = 8;

    public MessageConsole(String name, ImageDescriptor imageDescriptor) {
        super(name, imageDescriptor);
    }

    public int getHighWaterMark() {
        return this.fPartitioner.getHighWaterMark();
    }

    public void setWaterMarks(int low, int high) {
        this.fPartitioner.setWaterMarks(low, high);
    }

    public int getLowWaterMark() {
        return this.fPartitioner.getLowWaterMark();
    }

    protected void dispose() {
        this.fPartitioner.disconnect();
    }

    public IPageBookViewPage createPage(IConsoleView view) {
        return new MessageConsolePage(view, this);
    }

    public void setFont(Font font) {
        Font old = this.fFont;
        this.fFont = font;
        this.firePropertyChange(this, P_FONT, old, font);
    }

    public Font getFont() {
        if (this.fFont == null) {
            return JFaceResources.getTextFont();
        }
        return this.fFont;
    }

    public MessageConsoleStream newMessageStream() {
        return new MessageConsoleStream(this);
    }

    protected synchronized void appendToDocument(String text, MessageConsoleStream stream) {
        this.fPartitioner.appendToDocument(text, stream);
    }

    public IDocument getDocument() {
        return this.fPartitioner.getDocument();
    }

    public void setTabWidth(int tabWidth) {
        int old = this.tabWidth;
        this.tabWidth = tabWidth;
        this.firePropertyChange(this, P_TAB_SIZE, new Integer(old), new Integer(tabWidth));
    }

    public int getTabWidth() {
        return this.tabWidth;
    }
}

