/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.Assert;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.editors.text.ColorEditor;
import org.eclipse.ui.internal.editors.text.IPreferenceConfigurationBlock;
import org.eclipse.ui.internal.editors.text.OverlayPreferenceStore;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.quickdiff.QuickDiff;
import org.eclipse.ui.texteditor.quickdiff.ReferenceProviderDescriptor;

class QuickDiffConfigurationBlock
implements IPreferenceConfigurationBlock {
    private OverlayPreferenceStore fStore;
    private Map fCheckBoxes = new HashMap();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            QuickDiffConfigurationBlock.this.fStore.setValue((String)QuickDiffConfigurationBlock.this.fCheckBoxes.get(button), button.getSelection());
        }
    };
    private org.eclipse.swt.widgets.List fQuickDiffProviderList;
    private String[][] fQuickDiffProviderListModel;
    private Button fSetDefaultButton;
    private String[][] fQuickDiffModel;
    private ColorEditor[] fQuickDiffColorEditors;
    private Button fQuickDiffOverviewRulerCheckBox;

    public QuickDiffConfigurationBlock(OverlayPreferenceStore store) {
        Assert.isNotNull((Object)store);
        this.fStore = store;
        MarkerAnnotationPreferences markerAnnotationPreferences = new MarkerAnnotationPreferences();
        this.fStore.addKeys(this.createOverlayStoreKeys(markerAnnotationPreferences));
        this.fQuickDiffModel = this.createQuickDiffModel(markerAnnotationPreferences);
        this.fQuickDiffProviderListModel = this.createQuickDiffReferenceListModel();
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys(MarkerAnnotationPreferences preferences) {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "quickdiff.quickDiff"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "quickdiff.defaultProvider"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "quickdiff.characterMode"));
        Iterator e = preferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            AnnotationPreference info = (AnnotationPreference)e.next();
            if (!info.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffChange") && !info.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffAddition") && !info.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffDeletion")) continue;
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, info.getColorPreferenceKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, info.getOverviewRulerPreferenceKey()));
        }
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    private String[][] createQuickDiffModel(MarkerAnnotationPreferences preferences) {
        String[][] items = new String[3][];
        Iterator e = preferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            AnnotationPreference info = (AnnotationPreference)e.next();
            if (info.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffChange")) {
                items[0] = new String[]{info.getColorPreferenceKey(), info.getOverviewRulerPreferenceKey(), TextEditorMessages.getString("QuickDiffConfigurationBlock.changeColor")};
                continue;
            }
            if (info.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffAddition")) {
                items[1] = new String[]{info.getColorPreferenceKey(), info.getOverviewRulerPreferenceKey(), TextEditorMessages.getString("QuickDiffConfigurationBlock.additionColor")};
                continue;
            }
            if (!info.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffDeletion")) continue;
            items[2] = new String[]{info.getColorPreferenceKey(), info.getOverviewRulerPreferenceKey(), TextEditorMessages.getString("QuickDiffConfigurationBlock.deletionColor")};
        }
        return items;
    }

    private String[][] createQuickDiffReferenceListModel() {
        List descriptors = new QuickDiff().getReferenceProviderDescriptors();
        ArrayList<String[]> listModelItems = new ArrayList<String[]>();
        Iterator it = descriptors.iterator();
        while (it.hasNext()) {
            ReferenceProviderDescriptor descriptor = (ReferenceProviderDescriptor)it.next();
            String label = descriptor.getLabel();
            int i = label.indexOf(38);
            while (i >= 0) {
                if (i < label.length()) {
                    label = String.valueOf(label.substring(0, i)) + label.substring(i + 1);
                } else {
                    label.substring(0, i);
                }
                i = label.indexOf(38);
            }
            listModelItems.add(new String[]{descriptor.getId(), label});
        }
        String[][] items = new String[listModelItems.size()][];
        listModelItems.toArray((T[])items);
        return items;
    }

    private Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        String label = TextEditorMessages.getString("QuickDiffConfigurationBlock.showForNewEditors");
        this.addCheckBox(composite, label, "quickdiff.quickDiff", 0);
        label = TextEditorMessages.getString("QuickDiffConfigurationBlock.characterMode");
        this.addCheckBox(composite, label, "quickdiff.characterMode", 0);
        label = TextEditorMessages.getString("QuickDiffConfigurationBlock.showInOverviewRuler");
        this.fQuickDiffOverviewRulerCheckBox = new Button(composite, 32);
        this.fQuickDiffOverviewRulerCheckBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = 0;
        gd.horizontalSpan = 2;
        this.fQuickDiffOverviewRulerCheckBox.setLayoutData((Object)gd);
        this.fQuickDiffOverviewRulerCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < QuickDiffConfigurationBlock.this.fQuickDiffModel.length) {
                    QuickDiffConfigurationBlock.this.fStore.setValue(QuickDiffConfigurationBlock.this.fQuickDiffModel[i][1], QuickDiffConfigurationBlock.this.fQuickDiffOverviewRulerCheckBox.getSelection());
                    ++i;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label l = new Label(composite, 16384);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = 5;
        l.setLayoutData((Object)gd);
        Group group = new Group(composite, 0);
        group.setText(TextEditorMessages.getString("QuickDiffConfigurationBlock.colorTitle"));
        layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        gd = new GridData(32);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        this.fQuickDiffColorEditors = new ColorEditor[3];
        int i = 0;
        while (i < this.fQuickDiffModel.length) {
            ColorEditor editor;
            label = this.fQuickDiffModel[i][2];
            l = new Label((Composite)group, 16384);
            l.setText(label);
            this.fQuickDiffColorEditors[i] = editor = new ColorEditor((Composite)group);
            Button changeColorButton = editor.getButton();
            gd = new GridData(768);
            gd.horizontalAlignment = 1;
            changeColorButton.setLayoutData((Object)gd);
            final int index = i++;
            changeColorButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    String key = QuickDiffConfigurationBlock.this.fQuickDiffModel[index][0];
                    PreferenceConverter.setValue((IPreferenceStore)QuickDiffConfigurationBlock.this.fStore, (String)key, (RGB)editor.getColorValue());
                }
            });
        }
        l = new Label(composite, 16384);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = 5;
        l.setLayoutData((Object)gd);
        l = new Label(composite, 16384);
        l.setText(TextEditorMessages.getString("QuickDiffConfigurationBlock.referenceProviderTitle"));
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fQuickDiffProviderList = new org.eclipse.swt.widgets.List(editorComposite, 2564);
        gd = new GridData(770);
        gd.heightHint = 60;
        this.fQuickDiffProviderList.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        this.fSetDefaultButton = new Button(stylesComposite, 8);
        this.fSetDefaultButton.setText(TextEditorMessages.getString("QuickDiffConfigurationBlock.setDefault"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fSetDefaultButton.setLayoutData((Object)gd);
        this.fQuickDiffProviderList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                QuickDiffConfigurationBlock.this.handleProviderListSelection();
            }
        });
        this.fSetDefaultButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = QuickDiffConfigurationBlock.this.fQuickDiffProviderList.getSelectionIndex();
                QuickDiffConfigurationBlock.this.fStore.setValue("quickdiff.defaultProvider", QuickDiffConfigurationBlock.this.fQuickDiffProviderListModel[i][0]);
                QuickDiffConfigurationBlock.this.updateProviderList();
            }
        });
        return composite;
    }

    private void updateProviderList() {
        int i = this.fQuickDiffProviderList.getSelectionIndex();
        int defaultIndex = -1;
        String defaultProvider = this.fStore.getString("quickdiff.defaultProvider");
        int j = 0;
        while (j < this.fQuickDiffProviderListModel.length) {
            this.fQuickDiffProviderList.remove(j);
            if (defaultProvider.equals(this.fQuickDiffProviderListModel[j][0])) {
                this.fQuickDiffProviderList.add(String.valueOf(this.fQuickDiffProviderListModel[j][1]) + " " + TextEditorMessages.getString("QuickDiffConfigurationBlock.defaultlabel"), j);
                defaultIndex = j;
            } else {
                this.fQuickDiffProviderList.add(this.fQuickDiffProviderListModel[j][1], j);
            }
            ++j;
        }
        this.fSetDefaultButton.setEnabled(defaultIndex != i);
        this.fQuickDiffProviderList.setSelection(i);
        this.fQuickDiffProviderList.redraw();
    }

    public void initialize() {
        int i = 0;
        while (i < this.fQuickDiffProviderListModel.length) {
            String label = this.fQuickDiffProviderListModel[i][1];
            if (this.fStore.getString("quickdiff.defaultProvider").equals(this.fQuickDiffProviderListModel[i][0])) {
                label = String.valueOf(label) + " " + TextEditorMessages.getString("QuickDiffConfigurationBlock.defaultlabel");
            }
            this.fQuickDiffProviderList.add(label);
            ++i;
        }
        this.fQuickDiffProviderList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (QuickDiffConfigurationBlock.this.fQuickDiffProviderList != null && !QuickDiffConfigurationBlock.this.fQuickDiffProviderList.isDisposed()) {
                    QuickDiffConfigurationBlock.this.fQuickDiffProviderList.select(0);
                    QuickDiffConfigurationBlock.this.handleProviderListSelection();
                }
            }
        });
        this.initializeFields();
    }

    private void initializeFields() {
        Iterator e = this.fCheckBoxes.keySet().iterator();
        while (e.hasNext()) {
            Button b = (Button)e.next();
            String key = (String)this.fCheckBoxes.get(b);
            b.setSelection(this.fStore.getBoolean(key));
        }
        this.updateQuickDiffControls();
    }

    public void performOk() {
    }

    public void performDefaults() {
        this.initializeFields();
        this.updateProviderList();
    }

    private void handleProviderListSelection() {
        int i = this.fQuickDiffProviderList.getSelectionIndex();
        if (i != -1) {
            boolean b = this.fStore.getString("quickdiff.defaultProvider").equals(this.fQuickDiffProviderListModel[i][0]);
            this.fSetDefaultButton.setEnabled(!b);
        }
    }

    private void updateQuickDiffControls() {
        boolean quickdiffOverviewRuler = false;
        int i = 0;
        while (i < this.fQuickDiffModel.length) {
            this.fQuickDiffColorEditors[i].setColorValue(PreferenceConverter.getColor((IPreferenceStore)this.fStore, (String)this.fQuickDiffModel[i][0]));
            quickdiffOverviewRuler |= this.fStore.getBoolean(this.fQuickDiffModel[i][1]);
            ++i;
        }
        this.fQuickDiffOverviewRulerCheckBox.setSelection(quickdiffOverviewRuler);
    }

    public void dispose() {
    }
}

