/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.operations.IInstallFeatureOperation;

public class DuplicateConflictsValidator {
    private static final String KEY_CONFLICT = "DuplicateConflictsDialog.conflict";

    public static ArrayList computeDuplicateConflicts(IInstallFeatureOperation job, IInstallConfiguration config, IConfiguredSite targetSite, IFeatureReference[] optionalFeatures) {
        Hashtable featureTable = new Hashtable();
        try {
            DuplicateConflictsValidator.computePresentState(featureTable, config);
            DuplicateConflictsValidator.computeNewFeature(job.getFeature(), targetSite, featureTable, optionalFeatures);
            return DuplicateConflictsValidator.computeConflicts(featureTable);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static ArrayList computeDuplicateConflicts(IInstallFeatureOperation[] jobs, IInstallConfiguration config) {
        Hashtable featureTable = new Hashtable();
        DuplicateConflictsValidator.computePresentState(featureTable, config);
        DuplicateConflictsValidator.computeNewFeatures(jobs, featureTable);
        return DuplicateConflictsValidator.computeConflicts(featureTable);
    }

    private static ArrayList computeConflicts(Hashtable featureTable) {
        ArrayList<ArrayList> result = null;
        Enumeration enumeration = featureTable.elements();
        while (enumeration.hasMoreElements()) {
            ArrayList conflict;
            ArrayList candidate = (ArrayList)enumeration.nextElement();
            if (candidate.size() == 1 || (conflict = DuplicateConflictsValidator.checkForConflict(candidate)) == null) continue;
            if (result == null) {
                result = new ArrayList<ArrayList>();
            }
            result.add(conflict);
        }
        return result;
    }

    private static ArrayList checkForConflict(ArrayList candidate) {
        IdEntry firstEntry = null;
        int i = 0;
        while (i < candidate.size()) {
            IdEntry entry = (IdEntry)candidate.get(i);
            if (firstEntry == null) {
                firstEntry = entry;
            } else if (!entry.sameLevel(firstEntry)) {
                return candidate;
            }
            ++i;
        }
        return null;
    }

    private static void computePresentState(Hashtable table, IInstallConfiguration config) {
        IConfiguredSite[] csites = config.getConfiguredSites();
        int i = 0;
        while (i < csites.length) {
            IConfiguredSite csite = csites[i];
            IFeatureReference[] refs = csite.getConfiguredFeatures();
            int j = 0;
            while (j < refs.length) {
                try {
                    DuplicateConflictsValidator.addEntry(refs[j].getFeature(null), csite, table);
                }
                catch (CoreException coreException) {}
                ++j;
            }
            ++i;
        }
    }

    private static void computeNewFeatures(IInstallFeatureOperation[] jobs, Hashtable featureTable) {
        int i = 0;
        while (i < jobs.length) {
            IInstallFeatureOperation job = jobs[i];
            IConfiguredSite targetSite = job.getTargetSite();
            IFeature newFeature = job.getFeature();
            try {
                DuplicateConflictsValidator.computeNewFeature(newFeature, targetSite, featureTable, null);
            }
            catch (CoreException coreException) {}
            ++i;
        }
    }

    private static void computeNewFeature(IFeature feature, IConfiguredSite csite, Hashtable table, IFeatureReference[] optionalFeatures) throws CoreException {
        DuplicateConflictsValidator.addEntry(feature, csite, table);
        IIncludedFeatureReference[] irefs = feature.getIncludedFeatureReferences();
        int i = 0;
        while (i < irefs.length) {
            IIncludedFeatureReference iref = irefs[i];
            boolean add = true;
            if (iref.isOptional() && optionalFeatures != null) {
                boolean found = false;
                int j = 0;
                while (j < optionalFeatures.length) {
                    IFeatureReference checked = optionalFeatures[j];
                    if (checked.equals(iref)) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                add = found;
            }
            if (add) {
                DuplicateConflictsValidator.computeNewFeature(iref.getFeature(null), csite, table, optionalFeatures);
            }
            ++i;
        }
    }

    private static void addEntry(IFeature feature, IConfiguredSite csite, Hashtable featureTable) {
        String id = feature.getVersionedIdentifier().getIdentifier();
        ArrayList<IdEntry> entries = (ArrayList<IdEntry>)featureTable.get(id);
        if (entries == null) {
            entries = new ArrayList<IdEntry>();
            featureTable.put(id, entries);
        }
        IdEntry entry = new IdEntry(feature, csite);
        boolean replaced = false;
        int i = 0;
        while (i < entries.size()) {
            IdEntry existingEntry = (IdEntry)entries.get(i);
            IConfiguredSite existingSite = existingEntry.getConfiguredSite();
            if (existingSite.equals(entry.getConfiguredSite())) {
                if (entry.isInstallCandidate()) {
                    entries.set(i, entry);
                    entries.remove(existingEntry);
                }
                replaced = true;
                break;
            }
            ++i;
        }
        if (!replaced) {
            entries.add(entry);
        }
    }

    public static class IdEntry {
        IConfiguredSite csite;
        IFeature feature;

        public IdEntry(IFeature feature, IConfiguredSite csite) {
            this.feature = feature;
            this.csite = csite;
            if (csite == null) {
                System.out.println("csite null");
            }
        }

        public boolean isInstallCandidate() {
            return this.csite != null;
        }

        public IFeature getFeature() {
            return this.feature;
        }

        public String getIdentifier() {
            return this.feature.getVersionedIdentifier().getIdentifier();
        }

        public IConfiguredSite getConfiguredSite() {
            if (this.csite != null) {
                return this.csite;
            }
            return this.feature.getSite().getCurrentConfiguredSite();
        }

        public boolean sameLevel(IdEntry entry) {
            VersionedIdentifier vid = this.feature.getVersionedIdentifier();
            VersionedIdentifier evid = entry.getFeature().getVersionedIdentifier();
            return vid.equals(evid);
        }

        public String toString() {
            IConfiguredSite configSite = this.getConfiguredSite();
            String version = this.feature.getVersionedIdentifier().getVersion().toString();
            String location = configSite.getSite().getURL().getFile();
            return Policy.bind(DuplicateConflictsValidator.KEY_CONFLICT, new String[]{version, location});
        }
    }
}

