/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.operations.Operation;
import org.eclipse.update.operations.IBatchOperation;
import org.eclipse.update.operations.IFeatureOperation;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.IOperationListener;
import org.eclipse.update.operations.OperationsManager;

public class BatchInstallOperation
extends Operation
implements IBatchOperation {
    private static final String KEY_INSTALLING = "OperationsManager.installing";
    protected IInstallFeatureOperation[] operations;

    public BatchInstallOperation(IInstallFeatureOperation[] operations) {
        this.operations = operations;
    }

    public IFeatureOperation[] getOperations() {
        return this.operations;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor monitor, IOperationListener listener) throws CoreException, InvocationTargetException {
        boolean bl;
        int installCount = 0;
        if (this.operations == null) return false;
        if (this.operations.length == 0) {
            return false;
        }
        IStatus status = OperationsManager.getValidator().validatePendingChanges(this.operations);
        if (status != null && status.getCode() == 4) {
            throw new CoreException(status);
        }
        OperationsManager.setInProgress(true);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try {
                if (listener != null) {
                    listener.beforeExecute(this, null);
                }
                monitor.beginTask(Policy.bind(KEY_INSTALLING), this.operations.length);
                int i = 0;
                while (true) {
                    if (i >= this.operations.length) {
                        bl = SiteManager.getLocalSite().save();
                        Object var7_10 = null;
                        break;
                    }
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1, 4);
                    this.operations[i].execute((IProgressMonitor)subMonitor, listener);
                    OperationsManager.addPendingOperation(this.operations[i]);
                    this.operations[i].markProcessed();
                    if (listener != null) {
                        listener.afterExecute(this.operations[i], null);
                    }
                    ++installCount;
                    ++i;
                }
            }
            catch (InstallAbortedException e) {
                if (installCount <= 0) throw new InvocationTargetException((Throwable)((Object)e));
                SiteManager.getLocalSite().save();
                throw new InvocationTargetException((Throwable)((Object)e));
            }
            catch (CoreException e) {
                if (installCount <= 0) throw new InvocationTargetException(e);
                SiteManager.getLocalSite().save();
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            OperationsManager.setInProgress(false);
            monitor.done();
            throw throwable;
        }
        OperationsManager.setInProgress(false);
        monitor.done();
        return bl;
    }
}

