/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

class MinimizedFileSystemElement
extends FileSystemElement {
    private boolean populated = false;

    MinimizedFileSystemElement(String name, FileSystemElement parent, boolean isDirectory) {
        super(name, parent, isDirectory);
    }

    public AdaptableList getFiles(IImportStructureProvider provider) {
        if (!this.populated) {
            this.populate(provider);
        }
        return super.getFiles();
    }

    public AdaptableList getFolders(IImportStructureProvider provider) {
        if (!this.populated) {
            this.populate(provider);
        }
        return super.getFolders();
    }

    boolean isPopulated() {
        return this.populated;
    }

    boolean notPopulated() {
        return !this.populated;
    }

    private void populate(IImportStructureProvider provider) {
        Object fileSystemObject = this.getFileSystemObject();
        ArrayList children = provider.getChildren(fileSystemObject);
        if (children == null) {
            children = new ArrayList(1);
        }
        Iterator childrenEnum = children.iterator();
        while (childrenEnum.hasNext()) {
            Object child = childrenEnum.next();
            String elementLabel = provider.getLabel(child);
            MinimizedFileSystemElement result = new MinimizedFileSystemElement(elementLabel, this, provider.isFolder(child));
            result.setFileSystemObject(child);
        }
        this.setPopulated();
    }

    void setPopulated() {
        this.populated = true;
    }
}

