/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.text.MessageFormat;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.ide.dialogs.InternalErrorDialog;

public final class IDEExceptionHandler {
    private int exceptionCount = 0;
    private InternalErrorDialog dialog;
    private Shell defaultParent = new Shell();
    private boolean closing = false;
    private IWorkbenchConfigurer workbenchConfigurer;
    private static String MSG_OutOfMemoryError = IDEWorkbenchMessages.getString("FatalError_OutOfMemoryError");
    private static String MSG_StackOverflowError = IDEWorkbenchMessages.getString("FatalError_StackOverflowError");
    private static String MSG_VirtualMachineError = IDEWorkbenchMessages.getString("FatalError_VirtualMachineError");
    private static String MSG_SWTError = IDEWorkbenchMessages.getString("FatalError_SWTError");
    private static String MSG_FATAL_ERROR = IDEWorkbenchMessages.getString("FatalError");
    private static String MSG_FATAL_ERROR_Recursive = IDEWorkbenchMessages.getString("FatalError_RecursiveError");
    private static String MSG_FATAL_ERROR_RecursiveTitle = IDEWorkbenchMessages.getString("Internal_error");

    public IDEExceptionHandler(IWorkbenchConfigurer configurer) {
        this.workbenchConfigurer = configurer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleException(Throwable t) {
        try {
            ++this.exceptionCount;
            if (this.exceptionCount > 1) {
                if (this.closing) {
                    Object var5_2 = null;
                    --this.exceptionCount;
                    return;
                }
                Shell parent = this.defaultParent;
                if (this.dialog != null && this.dialog.getShell() != null && !this.dialog.getShell().isDisposed()) {
                    parent = this.dialog.getShell();
                }
                MessageBox box = new MessageBox(parent, 131265);
                box.setText(MSG_FATAL_ERROR_RecursiveTitle);
                box.setMessage(MessageFormat.format(MSG_FATAL_ERROR, MSG_FATAL_ERROR_Recursive));
                int result = box.open();
                if (result == 64) {
                    this.closeWorkbench();
                }
            } else if (this.openQuestionDialog(t)) {
                this.closeWorkbench();
            }
            Object var5_4 = null;
            --this.exceptionCount;
            return;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            --this.exceptionCount;
            throw throwable;
        }
    }

    private void closeWorkbench() {
        if (this.closing) {
            return;
        }
        try {
            this.closing = true;
            if (this.dialog != null && this.dialog.getShell() != null && !this.dialog.getShell().isDisposed()) {
                this.dialog.close();
            }
            this.workbenchConfigurer.emergencyClose();
        }
        catch (RuntimeException re) {
            System.err.println("Fatal runtime error happened during workbench emergency close.");
            re.printStackTrace();
            throw re;
        }
        catch (Error e) {
            System.err.println("Fatal error happened during workbench emergency close.");
            e.printStackTrace();
            throw e;
        }
    }

    private boolean openQuestionDialog(Throwable internalError) {
        try {
            String msg = null;
            if (internalError instanceof OutOfMemoryError) {
                msg = MSG_OutOfMemoryError;
            } else if (internalError instanceof StackOverflowError) {
                msg = MSG_StackOverflowError;
            } else if (internalError instanceof VirtualMachineError) {
                msg = MSG_VirtualMachineError;
            } else if (internalError instanceof SWTError) {
                msg = MSG_SWTError;
            } else {
                msg = internalError.getMessage() == null ? IDEWorkbenchMessages.getString("InternalErrorNoArg") : IDEWorkbenchMessages.format("InternalErrorOneArg", new Object[]{internalError.getMessage()});
                if (Policy.DEBUG_OPEN_ERROR_DIALOG) {
                    return this.openQuestion(null, IDEWorkbenchMessages.getString("Internal_error"), msg, internalError, 1);
                }
                return false;
            }
            Throwable detail = internalError;
            if (!Policy.DEBUG_OPEN_ERROR_DIALOG) {
                detail = null;
            }
            return InternalErrorDialog.openQuestion(null, IDEWorkbenchMessages.getString("Internal_error"), MessageFormat.format(MSG_FATAL_ERROR, msg), detail, 1);
        }
        catch (Throwable th) {
            System.err.println("Error while informing user about event loop exception:");
            internalError.printStackTrace();
            System.err.println("Dialog open exception:");
            th.printStackTrace();
            return true;
        }
    }

    private boolean openQuestion(Shell parent, String title, String message, Throwable detail, int defaultIndex) {
        String[] labels = detail == null ? new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL} : new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.SHOW_DETAILS_LABEL};
        this.dialog = new InternalErrorDialog(parent, title, null, message, detail, 3, labels, defaultIndex);
        if (detail != null) {
            this.dialog.setDetailButton(2);
        }
        boolean result = this.dialog.open() == 0;
        this.dialog = null;
        return result;
    }
}

