/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class AddBookmarkAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.AddBookmarkAction";
    private Shell shell;
    private boolean promptForName = true;
    static /* synthetic */ Class class$0;

    public AddBookmarkAction(Shell shell) {
        this(shell, true);
    }

    public AddBookmarkAction(Shell shell, boolean promptForName) {
        super(IDEWorkbenchMessages.getString("AddBookmarkLabel"));
        this.setId(ID);
        if (shell == null) {
            throw new IllegalArgumentException();
        }
        this.shell = shell;
        this.promptForName = promptForName;
        this.setToolTipText(IDEWorkbenchMessages.getString("AddBookmarkToolTip"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.ide.add_bookmark_action_context");
    }

    void createMarker(String markerType) {
        IStructuredSelection selection = this.getStructuredSelection();
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            Object resource;
            Object o = i.next();
            if (o instanceof IFile) {
                this.createMarker((IFile)o, markerType);
                continue;
            }
            if (!(o instanceof IAdaptable)) continue;
            IAdaptable iAdaptable = (IAdaptable)o;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!((resource = iAdaptable.getAdapter((Class)clazz)) instanceof IFile)) continue;
            this.createMarker((IFile)resource, markerType);
        }
    }

    void createMarker(final IFile file, final String markerType) {
        try {
            file.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    String markerMessage = file.getName();
                    if (AddBookmarkAction.this.promptForName) {
                        markerMessage = AddBookmarkAction.this.askForLabel(markerMessage);
                    }
                    if (markerMessage != null) {
                        IMarker marker = file.createMarker(markerType);
                        marker.setAttribute("message", (Object)markerMessage);
                    }
                }
            }, null);
        }
        catch (CoreException e) {
            IDEWorkbenchPlugin.log(null, e.getStatus());
        }
    }

    public void run() {
        this.createMarker("org.eclipse.core.resources.bookmark");
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return super.updateSelection(selection) && !selection.isEmpty() && this.selectionIsOfType(1);
    }

    String askForLabel(String proposal) {
        IInputValidator inputValidator;
        String message;
        String title = IDEWorkbenchMessages.getString("AddBookmarkDialog.title");
        InputDialog dialog = new InputDialog(this.shell, title, message = IDEWorkbenchMessages.getString("AddBookmarkDialog.message"), proposal, inputValidator = new IInputValidator(){

            public String isValid(String newText) {
                return newText == null || newText.length() == 0 ? " " : null;
            }
        });
        if (dialog.open() != 1) {
            String name = dialog.getValue();
            if (name == null) {
                return null;
            }
            return (name = name.trim()).length() == 0 ? null : name;
        }
        return null;
    }
}

