/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.digester;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Set;
import org.apache.commons.betwixt.AttributeDescriptor;
import org.apache.commons.betwixt.BeanProperty;
import org.apache.commons.betwixt.Descriptor;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.NodeDescriptor;
import org.apache.commons.betwixt.XMLBeanInfo;
import org.apache.commons.betwixt.digester.RuleSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AddDefaultsRule
extends RuleSupport {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$betwixt$digester$AddDefaultsRule == null ? (class$org$apache$commons$betwixt$digester$AddDefaultsRule = AddDefaultsRule.class$("org.apache.commons.betwixt.digester.AddDefaultsRule")) : class$org$apache$commons$betwixt$digester$AddDefaultsRule));
    static /* synthetic */ Class class$org$apache$commons$betwixt$digester$AddDefaultsRule;

    public void begin(String name, String namespace, Attributes attributes) throws Exception {
        boolean addProperties = true;
        String addPropertiesAttributeValue = attributes.getValue("add-properties");
        if (addPropertiesAttributeValue != null) {
            addProperties = Boolean.valueOf(addPropertiesAttributeValue);
        }
        boolean addAdders = true;
        String addAddersAttributeValue = attributes.getValue("add-adders");
        if (addAddersAttributeValue != null) {
            addProperties = Boolean.valueOf(addAddersAttributeValue);
        }
        if (addProperties) {
            this.addDefaultProperties();
        }
        if (addAdders) {
            this.addAdders();
        }
    }

    private void addAdders() {
        Class beanClass = this.getBeanClass();
        this.getXMLIntrospector().defaultAddMethods(this.getRootElementDescriptor(), beanClass);
    }

    private void addDefaultProperties() {
        block5: {
            Class beanClass = this.getBeanClass();
            Set processedProperties = this.getProcessedPropertyNameSet();
            if (beanClass == null) break block5;
            try {
                boolean attributesForPrimitives = this.getXMLInfoDigester().isAttributesForPrimitives();
                BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
                PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
                if (descriptors != null) {
                    int i = 0;
                    int size = descriptors.length;
                    while (i < size) {
                        Descriptor nodeDescriptor;
                        PropertyDescriptor descriptor = descriptors[i];
                        String propertyName = descriptor.getName();
                        if (!processedProperties.contains(propertyName) && (nodeDescriptor = this.getXMLIntrospector().createXMLDescriptor(new BeanProperty(descriptor))) != null) {
                            this.addDescriptor(nodeDescriptor);
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                log.info((Object)"Caught introspection exception", (Throwable)e);
            }
        }
    }

    protected void addDescriptor(NodeDescriptor nodeDescriptor) throws SAXException {
        this.addDescriptor((Descriptor)nodeDescriptor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addDescriptor(Descriptor nodeDescriptor) throws SAXException {
        Object top = this.digester.peek();
        if (top instanceof XMLBeanInfo) {
            log.warn((Object)"It is advisable to put an <addDefaults/> element inside an <element> tag");
            XMLBeanInfo beanInfo = (XMLBeanInfo)top;
            if (!(nodeDescriptor instanceof ElementDescriptor)) throw new SAXException("the <addDefaults> element should be within an <element> tag");
            ElementDescriptor elementDescriptor = (ElementDescriptor)nodeDescriptor;
            ElementDescriptor root = beanInfo.getElementDescriptor();
            if (root == null) {
                beanInfo.setElementDescriptor(elementDescriptor);
                return;
            } else {
                root.addElementDescriptor(elementDescriptor);
            }
            return;
        } else {
            if (!(top instanceof ElementDescriptor)) throw new SAXException("Invalid use of <addDefaults>. It should be nested inside <element> element");
            ElementDescriptor parent = (ElementDescriptor)top;
            if (nodeDescriptor instanceof ElementDescriptor) {
                parent.addElementDescriptor((ElementDescriptor)nodeDescriptor);
                return;
            } else {
                parent.addAttributeDescriptor((AttributeDescriptor)nodeDescriptor);
            }
        }
    }

    protected ElementDescriptor getRootElementDescriptor() {
        Object top = this.digester.peek();
        if (top instanceof XMLBeanInfo) {
            XMLBeanInfo beanInfo = (XMLBeanInfo)top;
            return beanInfo.getElementDescriptor();
        }
        if (top instanceof ElementDescriptor) {
            ElementDescriptor parent = (ElementDescriptor)top;
            return parent;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

