/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.internal.registry.ConfigurationElement;
import org.eclipse.core.internal.registry.ConfigurationProperty;
import org.eclipse.core.internal.registry.Extension;
import org.eclipse.core.internal.registry.ExtensionPoint;
import org.eclipse.core.internal.registry.Namespace;
import org.eclipse.core.internal.registry.RegistryModelObject;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.internal.runtime.ResourceTranslator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.util.tracker.ServiceTracker;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ExtensionsParser
extends DefaultHandler {
    private static final String NO_EXTENSION_MUNGING = "eclipse.noExtensionMunging";
    private static Map extensionPointMap;
    private static long cumulativeTime;
    private boolean compatibilityMode;
    private String locationName = null;
    private Stack stateStack = new Stack();
    private Stack objectStack = new Stack();
    private String schemaVersion = null;
    private MultiStatus status;
    private ResourceBundle resources;
    public static final int PARSE_PROBLEM = 1;
    public static final String PLUGIN = "plugin";
    public static final String PLUGIN_ID = "id";
    public static final String PLUGIN_NAME = "name";
    public static final String FRAGMENT = "fragment";
    public static final String BUNDLE_UID = "id";
    public static final String EXTENSION_POINT = "extension-point";
    public static final String EXTENSION_POINT_NAME = "name";
    public static final String EXTENSION_POINT_ID = "id";
    public static final String EXTENSION_POINT_SCHEMA = "schema";
    public static final String EXTENSION = "extension";
    public static final String EXTENSION_NAME = "name";
    public static final String EXTENSION_ID = "id";
    public static final String EXTENSION_TARGET = "point";
    public static final String ELEMENT = "element";
    public static final String ELEMENT_NAME = "name";
    public static final String ELEMENT_VALUE = "value";
    public static final String PROPERTY = "property";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_VALUE = "value";
    private static final int IGNORED_ELEMENT_STATE = 0;
    private static final int INITIAL_STATE = 1;
    private static final int BUNDLE_STATE = 2;
    private static final int BUNDLE_EXTENSION_POINT_STATE = 5;
    private static final int BUNDLE_EXTENSION_STATE = 6;
    private static final int CONFIGURATION_ELEMENT_STATE = 10;
    private static final int EXTENSION_POINT_INDEX = 0;
    private static final int EXTENSION_INDEX = 1;
    private static final int LAST_INDEX = 1;
    private ArrayList[] scratchVectors = new ArrayList[2];
    private String manifestType;
    private Locator locator = null;
    private String configurationElementValue = null;

    static {
        ExtensionsParser.initializeExtensionPointMap();
        cumulativeTime = 0L;
    }

    private static void initializeExtensionPointMap() {
        HashMap<String, String> map = new HashMap<String, String>(13);
        map.put("org.eclipse.ui.markerImageProvider", "org.eclipse.ui.ide.markerImageProvider");
        map.put("org.eclipse.ui.markerHelp", "org.eclipse.ui.ide.markerHelp");
        map.put("org.eclipse.ui.markerImageProviders", "org.eclipse.ui.ide.markerImageProviders");
        map.put("org.eclipse.ui.markerResolution", "org.eclipse.ui.ide.markerResolution");
        map.put("org.eclipse.ui.projectNatureImages", "org.eclipse.ui.ide.projectNatureImages");
        map.put("org.eclipse.ui.resourceFilters", "org.eclipse.ui.ide.resourceFilters");
        map.put("org.eclipse.ui.markerUpdaters", "org.eclipse.ui.editors.markerUpdaters");
        map.put("org.eclipse.ui.documentProviders", "org.eclipse.ui.editors.documentProviders");
        map.put("org.eclipse.ui.workbench.texteditor.markerAnnotationSpecification", "org.eclipse.ui.editors.markerAnnotationSpecification");
        map.put("org.eclipse.help.browser", "org.eclipse.help.base.browser");
        map.put("org.eclipse.help.luceneAnalyzer", "org.eclipse.help.base.luceneAnalyzer");
        map.put("org.eclipse.help.webapp", "org.eclipse.help.base.webapp");
        map.put("org.eclipse.help.support", "org.eclipse.ui.helpSupport");
        extensionPointMap = map;
    }

    public ExtensionsParser(MultiStatus status) {
        this.status = status;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void characters(char[] ch, int start, int length) {
        int state = (Integer)this.stateStack.peek();
        if (state != 10) {
            return;
        }
        if (state == 10) {
            ConfigurationElement currentConfigElement = (ConfigurationElement)this.objectStack.peek();
            String value = new String(ch, start, length);
            if (this.configurationElementValue == null) {
                if (value.trim().length() != 0) {
                    this.configurationElementValue = value;
                }
            } else {
                this.configurationElementValue = String.valueOf(this.configurationElementValue) + value;
            }
            if (this.configurationElementValue != null) {
                currentConfigElement.setValue(this.translate(this.configurationElementValue));
            }
        }
    }

    public void endDocument() {
    }

    public void endElement(String uri, String elementName, String qName) {
        switch ((Integer)this.stateStack.peek()) {
            case 0: {
                this.stateStack.pop();
                break;
            }
            case 1: {
                this.internalError(Policy.bind("parse.internalStack", elementName));
                break;
            }
            case 2: {
                ArrayList extensions;
                if (!elementName.equals(this.manifestType)) break;
                this.stateStack.pop();
                Namespace root = (Namespace)this.objectStack.peek();
                ArrayList extensionPoints = this.scratchVectors[0];
                if (extensionPoints.size() > 0) {
                    root.setExtensionPoints(extensionPoints.toArray(new ExtensionPoint[extensionPoints.size()]));
                    this.scratchVectors[0].clear();
                }
                if ((extensions = this.scratchVectors[1]).size() <= 0) break;
                root.setExtensions(this.fixRenamedExtensionPoints(extensions.toArray(new Extension[extensions.size()])));
                this.scratchVectors[1].clear();
                break;
            }
            case 5: {
                if (!elementName.equals(EXTENSION_POINT)) break;
                this.stateStack.pop();
                break;
            }
            case 6: {
                if (!elementName.equals(EXTENSION)) break;
                this.stateStack.pop();
                Extension currentExtension = (Extension)this.objectStack.pop();
                Namespace parent = (Namespace)this.objectStack.peek();
                currentExtension.setParent(parent);
                this.scratchVectors[1].add(currentExtension);
                break;
            }
            case 10: {
                this.stateStack.pop();
                this.configurationElementValue = null;
                ConfigurationElement currentConfigElement = (ConfigurationElement)this.objectStack.pop();
                String value = currentConfigElement.getValueAsIs();
                if (value != null) {
                    currentConfigElement.setValue(value.trim());
                }
                Object parent = this.objectStack.peek();
                currentConfigElement.setParent((RegistryModelObject)parent);
                if ((Integer)this.stateStack.peek() == 6) {
                    IConfigurationElement[] oldValues = ((Extension)parent).getConfigurationElements();
                    int size = oldValues == null ? 0 : oldValues.length;
                    IConfigurationElement[] newValues = new IConfigurationElement[size + 1];
                    int i = 0;
                    while (i < size) {
                        newValues[i] = oldValues[i];
                        ++i;
                    }
                    newValues[size] = currentConfigElement;
                    ((Extension)parent).setSubElements(newValues);
                    break;
                }
                IConfigurationElement[] oldValues = ((ConfigurationElement)parent).getChildren();
                int size = oldValues == null ? 0 : oldValues.length;
                IConfigurationElement[] newValues = new IConfigurationElement[size + 1];
                int i = 0;
                while (i < size) {
                    newValues[i] = oldValues[i];
                    ++i;
                }
                newValues[size] = currentConfigElement;
                ((ConfigurationElement)parent).setChildren(newValues);
            }
        }
    }

    public void error(SAXParseException ex) {
        this.logStatus(ex);
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        this.logStatus(ex);
        throw ex;
    }

    private void handleExtensionPointState(String elementName) {
        this.stateStack.push(new Integer(0));
        this.unknownElement(EXTENSION_POINT, elementName);
    }

    private void handleExtensionState(String elementName, Attributes attributes) {
        this.stateStack.push(new Integer(10));
        this.configurationElementValue = null;
        ConfigurationElement currentConfigurationElement = new ConfigurationElement();
        this.objectStack.push(currentConfigurationElement);
        currentConfigurationElement.setName(elementName);
        this.parseConfigurationElementAttributes(attributes);
    }

    private void handleInitialState(String elementName, Attributes attributes) {
        if (!elementName.equals(this.manifestType)) {
            this.stateStack.push(new Integer(0));
            this.internalError(Policy.bind("parse.unknownTopElement", elementName));
            return;
        }
        this.compatibilityMode = !elementName.equals(PLUGIN) || attributes.getLength() != 0;
        this.stateStack.push(new Integer(2));
        Namespace current = new Namespace();
        this.objectStack.push(current);
    }

    protected static String[] getArrayFromList(String line) {
        if (line == null || line.trim().length() == 0) {
            return null;
        }
        Vector<String> list = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(line, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.length() == 0) continue;
            list.addElement(token);
        }
        return list.isEmpty() ? null : list.toArray(new String[0]);
    }

    private void handleBundleState(String elementName, Attributes attributes) {
        if (elementName.equals(EXTENSION_POINT)) {
            this.stateStack.push(new Integer(5));
            this.parseExtensionPointAttributes(attributes);
            return;
        }
        if (elementName.equals(EXTENSION)) {
            this.stateStack.push(new Integer(6));
            this.parseExtensionAttributes(attributes);
            return;
        }
        this.stateStack.push(new Integer(0));
        if (!this.compatibilityMode) {
            this.unknownElement(this.manifestType, elementName);
        }
    }

    private void logStatus(SAXParseException ex) {
        String name = ex.getSystemId();
        if (name == null) {
            name = this.locationName;
        }
        name = name == null ? "" : name.substring(1 + name.lastIndexOf("/"));
        String msg = name.equals("") ? Policy.bind("parse.error", ex.getMessage()) : Policy.bind("parse.errorNameLineColumn", new String[]{name, Integer.toString(ex.getLineNumber()), Integer.toString(ex.getColumnNumber()), ex.getMessage()});
        this.error(new Status(2, "org.eclipse.core.runtime", 1, msg, ex));
    }

    public Namespace parseManifest(ServiceTracker factoryTracker, InputSource in, String manifestType, String manifestName, ResourceBundle bundle) throws ParserConfigurationException, SAXException, IOException {
        Namespace namespace;
        block9: {
            SAXParserFactory factory;
            long start = 0L;
            this.resources = bundle;
            if (InternalPlatform.DEBUG) {
                start = System.currentTimeMillis();
            }
            if ((factory = (SAXParserFactory)factoryTracker.getService()) == null) {
                throw new SAXException(Policy.bind("parse.xmlParserNotAvailable"));
            }
            try {
                if (manifestType == null) {
                    throw new NullPointerException();
                }
                if (!manifestType.equals(PLUGIN) && !manifestType.equals(FRAGMENT)) {
                    throw new IllegalArgumentException("Invalid manifest type: " + manifestType);
                }
                this.manifestType = manifestType;
                this.locationName = in.getSystemId();
                if (this.locationName == null) {
                    this.locationName = manifestName;
                }
                factory.setNamespaceAware(true);
                try {
                    factory.setFeature("http://xml.org/sax/features/string-interning", true);
                }
                catch (SAXException sAXException) {}
                factory.setValidating(false);
                factory.newSAXParser().parse(in, (DefaultHandler)this);
                namespace = (Namespace)this.objectStack.pop();
                Object var9_9 = null;
                if (!InternalPlatform.DEBUG) break block9;
            }
            catch (Throwable throwable) {
                block10: {
                    Object var9_10 = null;
                    if (!InternalPlatform.DEBUG) break block10;
                    InternalPlatform.getDefault().setOption("org.eclipse.core.runtime/registry/parsing/timing/value", Long.toString(cumulativeTime += System.currentTimeMillis() - start));
                }
                throw throwable;
            }
            InternalPlatform.getDefault().setOption("org.eclipse.core.runtime/registry/parsing/timing/value", Long.toString(cumulativeTime += System.currentTimeMillis() - start));
        }
        return namespace;
    }

    private void parseConfigurationElementAttributes(Attributes attributes) {
        int len;
        ConfigurationElement parentConfigurationElement = (ConfigurationElement)this.objectStack.peek();
        Vector<ConfigurationProperty> propVector = null;
        int n = len = attributes != null ? attributes.getLength() : 0;
        if (len == 0) {
            return;
        }
        propVector = new Vector<ConfigurationProperty>();
        int i = 0;
        while (i < len) {
            String attrName = attributes.getLocalName(i);
            String attrValue = attributes.getValue(i);
            ConfigurationProperty currentConfigurationProperty = new ConfigurationProperty();
            currentConfigurationProperty.setName(attrName);
            currentConfigurationProperty.setValue(this.translate(attrValue));
            propVector.addElement(currentConfigurationProperty);
            ++i;
        }
        parentConfigurationElement.setProperties(propVector.toArray(new ConfigurationProperty[propVector.size()]));
        propVector = null;
    }

    private void parseExtensionAttributes(Attributes attributes) {
        Namespace parent = (Namespace)this.objectStack.peek();
        Extension currentExtension = new Extension();
        this.objectStack.push(currentExtension);
        int len = attributes != null ? attributes.getLength() : 0;
        int i = 0;
        while (i < len) {
            String attrName = attributes.getLocalName(i);
            String attrValue = attributes.getValue(i).trim();
            if (attrName.equals("name")) {
                currentExtension.setName(this.translate(attrValue));
            } else if (attrName.equals("id")) {
                currentExtension.setSimpleIdentifier(attrValue);
            } else if (attrName.equals(EXTENSION_TARGET)) {
                String targetName;
                if (attrValue.lastIndexOf(46) == -1) {
                    String baseId = parent.getName();
                    targetName = String.valueOf(baseId) + "." + attrValue;
                } else {
                    targetName = attrValue;
                }
                currentExtension.setExtensionPointIdentifier(targetName);
            } else {
                this.unknownAttribute(EXTENSION, attrName);
            }
            ++i;
        }
        if (currentExtension.getExtensionPointUniqueIdentifier() == null) {
            this.missingAttribute(EXTENSION_TARGET, EXTENSION);
            this.stateStack.pop();
            this.stateStack.push(new Integer(0));
            this.objectStack.pop();
            return;
        }
    }

    private void missingAttribute(String attribute, String element) {
        if (this.locator == null) {
            this.internalError(Policy.bind("parse.missingAttribute", new String[]{attribute, element}));
        } else {
            this.internalError(Policy.bind("parse.missingAttributeLine", new String[]{attribute, element, Integer.toString(this.locator.getLineNumber())}));
        }
    }

    private void unknownAttribute(String attribute, String element) {
        if (this.locator == null) {
            this.internalError(Policy.bind("parse.unknownAttribute", new String[]{attribute, element}));
        } else {
            this.internalError(Policy.bind("parse.unknownAttributeLine", new String[]{attribute, element, Integer.toString(this.locator.getLineNumber())}));
        }
    }

    private void unknownElement(String element, String parent) {
        if (this.locator == null) {
            this.internalError(Policy.bind("parse.unknownAttribute", new String[]{parent, element}));
        } else {
            this.internalError(Policy.bind("parse.unknownAttributeLine", new String[]{parent, element, Integer.toString(this.locator.getLineNumber())}));
        }
    }

    private void parseExtensionPointAttributes(Attributes attributes) {
        ExtensionPoint currentExtPoint = new ExtensionPoint();
        int len = attributes != null ? attributes.getLength() : 0;
        int i = 0;
        while (i < len) {
            String attrName = attributes.getLocalName(i);
            String attrValue = attributes.getValue(i).trim();
            if (attrName.equals("name")) {
                currentExtPoint.setName(this.translate(attrValue));
            } else if (attrName.equals("id")) {
                currentExtPoint.setSimpleIdentifier(attrValue);
            } else if (attrName.equals(EXTENSION_POINT_SCHEMA)) {
                currentExtPoint.setSchema(attrValue);
            } else {
                this.unknownAttribute(EXTENSION_POINT, attrName);
            }
            ++i;
        }
        if (currentExtPoint.getSimpleIdentifier() == null || currentExtPoint.getName() == null) {
            String attribute = currentExtPoint.getSimpleIdentifier() == null ? "id" : "name";
            this.missingAttribute(attribute, EXTENSION_POINT);
            this.stateStack.pop();
            this.stateStack.push(new Integer(0));
            return;
        }
        Namespace root = (Namespace)this.objectStack.peek();
        currentExtPoint.setParent(root);
        this.scratchVectors[0].add(currentExtPoint);
    }

    public void startDocument() {
        this.stateStack.push(new Integer(1));
        int i = 0;
        while (i <= 1) {
            this.scratchVectors[i] = new ArrayList();
            ++i;
        }
    }

    public void startElement(String uri, String elementName, String qName, Attributes attributes) {
        switch ((Integer)this.stateStack.peek()) {
            case 1: {
                this.handleInitialState(elementName, attributes);
                break;
            }
            case 2: {
                this.handleBundleState(elementName, attributes);
                break;
            }
            case 5: {
                this.handleExtensionPointState(elementName);
                break;
            }
            case 6: 
            case 10: {
                this.handleExtensionState(elementName, attributes);
                break;
            }
            default: {
                this.stateStack.push(new Integer(0));
                if (this.compatibilityMode) break;
                this.internalError(Policy.bind("parse.unknownTopElement", elementName));
            }
        }
    }

    public void warning(SAXParseException ex) {
        this.logStatus(ex);
    }

    private void internalError(String message) {
        this.error(new Status(2, "org.eclipse.core.runtime", 1, message, null));
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (target.equalsIgnoreCase("eclipse")) {
            this.schemaVersion = "3.0";
            StringTokenizer tokenizer = new StringTokenizer(data, "=\"");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (!token.equalsIgnoreCase("version")) continue;
                if (!tokenizer.hasMoreTokens()) break;
                this.schemaVersion = tokenizer.nextToken();
                break;
            }
        }
    }

    public void error(IStatus error) {
        this.status.add(error);
    }

    private String translate(String key) {
        return ResourceTranslator.getResourceString(null, key, this.resources);
    }

    private Extension[] fixRenamedExtensionPoints(Extension[] extensions) {
        if (extensions == null || this.schemaVersion != null && this.schemaVersion.equals("3.0") || System.getProperties().get(NO_EXTENSION_MUNGING) != null) {
            return extensions;
        }
        int i = 0;
        while (i < extensions.length) {
            Extension extension = extensions[i];
            String oldPointId = extension.getExtensionPointIdentifier();
            String newPointId = (String)extensionPointMap.get(oldPointId);
            if (newPointId != null) {
                extension.setExtensionPointIdentifier(newPointId);
            }
            ++i;
        }
        return extensions;
    }
}

