/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.ui;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ScalableLayeredPane;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.jpn.xucker.rcp.ui.GraphMemoryLabelProvider;
import org.jpn.xucker.rcp.ui.NumberLabelProvider;
import org.jpn.xucker.rcp.ui.SimpleGraphMemoryPainter;

public class FigureMemoryComposite
extends Composite {
    private FigureCanvas canvas;
    ScalableLayeredPane scalableLayeredPane;
    private HMemoryCanvas horizontalMemoryCanvas;
    private VMemoryCanvas verticalMemoryCanvas;
    private double[] zooms = new double[]{0.05125, 0.125, 0.25, 0.5, 1.0, 2.0, 4.0, 8.0, 16.0, 32.0};
    private int[] grids = new int[]{100, 100, 100, 100, 100, 100, 100, 96, 96, 96};
    private int currentZoom = 4;
    int horizontalMemoryStart;
    int verticalMemoryStart;
    private int maxHorizontalValue = 30000;
    private int maxVerticalValue = 30000;
    private GraphMemoryLabelProvider vscrollLabelProvider = new NumberLabelProvider();
    private GraphMemoryLabelProvider hscrollLabelProvider = new NumberLabelProvider();

    public ScalableLayeredPane getScalableLayeredPane() {
        return this.scalableLayeredPane;
    }

    public int getHorizontalMemoryStart() {
        return this.horizontalMemoryStart;
    }

    public void setHorizontalMemoryStart(int horizontalMemoryStart) {
        this.horizontalMemoryStart = horizontalMemoryStart;
    }

    public int getVerticalMemoryStart() {
        return this.verticalMemoryStart;
    }

    public void setVerticalMemoryStart(int verticalMemoryStart) {
        this.verticalMemoryStart = verticalMemoryStart;
    }

    public int getMaxHorizontalValue() {
        return this.maxHorizontalValue;
    }

    public void setMaxHorizontalValue(int maxHorizontalValue) {
        this.maxHorizontalValue = maxHorizontalValue;
    }

    public int getMaxVerticalValue() {
        return this.maxVerticalValue;
    }

    public void setMaxVerticalValue(int maxVerticalValue) {
        this.maxVerticalValue = maxVerticalValue;
    }

    public SimpleGraphMemoryPainter getHorizontalGraphPainter() {
        return this.horizontalMemoryCanvas.getGraphMemoryPainter();
    }

    public SimpleGraphMemoryPainter getVerticalGraphPainter() {
        return this.verticalMemoryCanvas.getGraphMemoryPainter();
    }

    public FigureMemoryComposite(Composite parent, int style) {
        this(parent, style, 32, 32);
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public IFigure getContents() {
        return this.canvas.getContents();
    }

    public FigureMemoryComposite(Composite parent, int style, int memoryWidth, int memoryHeight) {
        super(parent, style);
        FigureMemoryComposite base = this;
        GridLayout gridlayout = new GridLayout(2, false);
        gridlayout.horizontalSpacing = 0;
        gridlayout.verticalSpacing = 0;
        gridlayout.marginHeight = 0;
        gridlayout.marginWidth = 0;
        base.setLayout((Layout)gridlayout);
        this.setBackground(ColorConstants.white);
        Composite space = new Composite((Composite)base, 0);
        space.setBackground(ColorConstants.white);
        GridData s1 = new GridData();
        s1.widthHint = memoryHeight;
        s1.heightHint = memoryWidth;
        space.setLayoutData((Object)s1);
        this.horizontalMemoryCanvas = new HMemoryCanvas(base, 0);
        GridData c2 = new GridData(768);
        c2.heightHint = memoryWidth;
        this.horizontalMemoryCanvas.setLayoutData(c2);
        this.verticalMemoryCanvas = new VMemoryCanvas(base, 0);
        GridData c1 = new GridData(1040);
        c1.widthHint = memoryHeight;
        this.verticalMemoryCanvas.setLayoutData(c1);
        this.canvas = new FigureCanvas((Composite)base);
        this.canvas.setBackground(ColorConstants.white);
        this.canvas.getVerticalBar().addSelectionListener((SelectionListener)this.verticalMemoryCanvas);
        this.canvas.getHorizontalBar().addSelectionListener((SelectionListener)this.horizontalMemoryCanvas);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.scalableLayeredPane = new ScalableLayeredPane();
        this.scalableLayeredPane.setLayoutManager((LayoutManager)new FlowLayout(false));
        this.canvas.setContents((IFigure)this.scalableLayeredPane);
        this.scalableLayeredPane.setScale(1.0);
        this.canvas.addControlListener((ControlListener)new ResizeCheck());
        this.verticalMemoryCanvas.setPosition(memoryHeight);
        this.horizontalMemoryCanvas.setPosition(memoryWidth);
        this.canvas.getVerticalBar().addSelectionListener((SelectionListener)new ScrollChange());
    }

    private void start() {
    }

    public void zoomUp() {
        if (this.currentZoom < this.zooms.length - 1) {
            ++this.currentZoom;
            double zoom = this.zooms[this.currentZoom];
            this.horizontalMemoryCanvas.setGrid(this.grids[this.currentZoom]);
            this.verticalMemoryCanvas.setGrid(this.grids[this.currentZoom]);
            this.horizontalMemoryCanvas.setZoom(zoom);
            this.verticalMemoryCanvas.setZoom(zoom);
            this.scalableLayeredPane.setScale(zoom);
            this.verticalMemoryCanvas.redraw();
            this.horizontalMemoryCanvas.redraw();
        }
    }

    public void zoomDown() {
        if (this.currentZoom > 0) {
            --this.currentZoom;
            double zoom = this.zooms[this.currentZoom];
            this.scalableLayeredPane.setScale(zoom);
            this.horizontalMemoryCanvas.setGrid(this.grids[this.currentZoom]);
            this.verticalMemoryCanvas.setGrid(this.grids[this.currentZoom]);
            this.horizontalMemoryCanvas.setZoom(zoom);
            this.verticalMemoryCanvas.setZoom(zoom);
            this.canvas.scrollToY((this.canvas.getVerticalBar().getSelection() - this.canvas.getVerticalBar().getThumb()) / 2);
            this.verticalMemoryCanvas.redraw();
            this.canvas.scrollToY((this.canvas.getHorizontalBar().getSelection() - this.canvas.getHorizontalBar().getThumb()) / 2);
            this.horizontalMemoryCanvas.redraw();
        }
    }

    public void init() {
        this.horizontalMemoryCanvas.setZoom(1.0);
        this.verticalMemoryCanvas.setZoom(1.0);
        this.scalableLayeredPane.setScale(1.0);
        this.canvas.scrollToX(0);
        this.canvas.scrollToY(0);
        this.currentZoom = 4;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public GraphMemoryLabelProvider getHscrollLabelProvider() {
        return this.hscrollLabelProvider;
    }

    public void setHscrollLabelProvider(GraphMemoryLabelProvider hscrollLabelProvider) {
        this.hscrollLabelProvider = hscrollLabelProvider;
        this.getHorizontalGraphPainter().setMainLabel(hscrollLabelProvider.createLabel(this.horizontalMemoryCanvas.getZoom()));
    }

    public GraphMemoryLabelProvider getVscrollLabelProvider() {
        return this.vscrollLabelProvider;
    }

    public void setVscrollLabelProvider(GraphMemoryLabelProvider vscrollLabelProvider) {
        this.vscrollLabelProvider = vscrollLabelProvider;
        this.getVerticalGraphPainter().setMainLabel(vscrollLabelProvider.createLabel(this.verticalMemoryCanvas.getZoom()));
    }

    public HMemoryCanvas getHorizontalMemoryCanvas() {
        return this.horizontalMemoryCanvas;
    }

    public void setHorizontalMemoryCanvas(HMemoryCanvas horizontalMemoryCanvas) {
        this.horizontalMemoryCanvas = horizontalMemoryCanvas;
    }

    public VMemoryCanvas getVerticalMemoryCanvas() {
        return this.verticalMemoryCanvas;
    }

    public void setVerticalMemoryCanvas(VMemoryCanvas verticalMemoryCanvas) {
        this.verticalMemoryCanvas = verticalMemoryCanvas;
    }

    public class ScrollChange
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            if (!FigureMemoryComposite.this.canvas.getVerticalBar().isVisible()) {
                int inc = FigureMemoryComposite.this.canvas.getHorizontalBar().getIncrement();
                if (e.detail == 0x1000001) {
                    inc *= -1;
                }
                FigureMemoryComposite.this.canvas.scrollToX(FigureMemoryComposite.this.canvas.getHorizontalBar().getSelection() + inc);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class ResizeCheck
    implements ControlListener {
        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            FigureMemoryComposite.this.verticalMemoryCanvas.redraw();
            FigureMemoryComposite.this.horizontalMemoryCanvas.redraw();
        }
    }

    public class VMemoryCanvas
    extends AbstractMemoryCanvas {
        public VMemoryCanvas(Composite parent, int style) {
            super(parent, style);
            this.painter.setVerticalGraph(true);
            this.painter.setGraphPlus(true);
            this.painter.setMainLabel(FigureMemoryComposite.this.vscrollLabelProvider.createLabel(this.zoom));
        }

        public void setZoom(double zoom) {
            this.zoom = zoom;
            this.painter.setMainLabel(FigureMemoryComposite.this.vscrollLabelProvider.createLabel(zoom));
            this.redraw();
        }

        public void paintControl(PaintEvent e) {
            Image bimage = new Image((Device)this.getShell().getDisplay(), this.getClientArea().width, this.getClientArea().height);
            GC g2 = new GC((Drawable)bimage);
            this.painter.draw(g2, this.position - 1, 0 - FigureMemoryComposite.this.canvas.getVerticalBar().getSelection() + FigureMemoryComposite.this.verticalMemoryStart, FigureMemoryComposite.this.maxVerticalValue);
            e.gc.drawImage(bimage, 0, 0);
            g2.dispose();
            bimage.dispose();
        }
    }

    public abstract class AbstractMemoryCanvas
    extends Canvas
    implements PaintListener,
    SelectionListener {
        double zoom = 1.0;
        int per = 100;
        int position = 50;
        SimpleGraphMemoryPainter painter = new SimpleGraphMemoryPainter();

        public double getZoom() {
            return this.zoom;
        }

        public void setZoom(double zoom) {
            this.zoom = zoom;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public AbstractMemoryCanvas(Composite parent, int style) {
            super(parent, style | 0x40000);
            this.addPaintListener(this);
        }

        public SimpleGraphMemoryPainter getGraphMemoryPainter() {
            return this.painter;
        }

        public void setGraphMemoryPainter(SimpleGraphMemoryPainter painter) {
            this.painter = painter;
        }

        public void setGrid(int size) {
            this.painter.setPerMain(size);
        }

        public void widgetSelected(SelectionEvent e) {
            this.redraw();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public abstract void paintControl(PaintEvent var1);
    }

    public class HMemoryCanvas
    extends AbstractMemoryCanvas {
        public HMemoryCanvas(Composite parent, int style) {
            super(parent, style);
            this.painter.setVerticalGraph(false);
            this.painter.setGraphPlus(true);
            this.painter.setMainLabel(FigureMemoryComposite.this.hscrollLabelProvider.createLabel(this.zoom));
        }

        public void paintControl(PaintEvent e) {
            Image bimage = new Image((Device)this.getShell().getDisplay(), this.getClientArea().width, this.getClientArea().height);
            GC g2 = new GC((Drawable)bimage);
            this.painter.draw(g2, 0 - FigureMemoryComposite.this.canvas.getHorizontalBar().getSelection() + FigureMemoryComposite.this.horizontalMemoryStart, this.position - 1, FigureMemoryComposite.this.canvas.getHorizontalBar().getSelection() + this.getClientArea().width);
            e.gc.drawImage(bimage, 0, 0);
            g2.dispose();
            bimage.dispose();
        }

        public void setZoom(double zoom) {
            this.zoom = zoom;
            this.painter.setMainLabel(FigureMemoryComposite.this.hscrollLabelProvider.createLabel(zoom));
            this.redraw();
        }
    }
}

