/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.mp3;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Header;
import javazoom.spi.mpeg.sampled.convert.MpegFormatConversionProvider;
import javazoom.spi.mpeg.sampled.file.MpegAudioFileFormat;
import javazoom.spi.mpeg.sampled.file.MpegAudioFileReader;
import org.apache.commons.collections.primitives.ArrayShortList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.commons.audio.WaveUtils;
import org.jpn.xucker.mp3.MP3FixOutputStream;
import org.tritonus.share.sampled.file.TAudioFileFormat;

public class MP3Utils {
    public static final int SAMPLING_1152 = 1152;
    public static final int MP3_HEADER_BYTES = 4;
    public static Log log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.mp3.MP3Utils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public static long calculateByteAt(int bps, long millisecond) {
        return (long)(bps / 8) * millisecond / 1000L;
    }

    public static AudioInputStream toPCMAudioInputStream(File inputMP3File, short[] mp3FrameSizes, long readStartSampleAt) throws UnsupportedAudioFileException, IOException {
        int frameAt = (int)(readStartSampleAt / 1152L);
        long skipPCMSamples = readStartSampleAt % 1152L;
        long byteAt = MP3Utils.qucikSearchByte(inputMP3File, frameAt, mp3FrameSizes);
        log.trace((Object)("file-size:" + inputMP3File.length() + ",skip=" + byteAt));
        FileInputStream inputStream = new FileInputStream(inputMP3File);
        inputStream.skip(byteAt);
        return MP3Utils.toPCMAudioInputStream(inputStream, skipPCMSamples);
    }

    public static AudioInputStream toPCMAudioInputStream(InputStream input) throws UnsupportedAudioFileException, IOException {
        return MP3Utils.toPCMAudioInputStream(input, 0L);
    }

    public static AudioFormat getAudioFormat(InputStream input) {
        MpegAudioFileReader mpegAudioFileReader = new MpegAudioFileReader();
        try {
            AudioInputStream in = mpegAudioFileReader.getAudioInputStream(input);
            AudioFormat format = in.getFormat();
            in.close();
            return format;
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static long getAudioDurationTime(File file) throws UnsupportedAudioFileException, IOException {
        long result = 0L;
        float frequence = MP3Utils.getAudioFormat(new FileInputStream(file)).getSampleRate();
        short[] frames = MP3Utils.countFrameSizes(file);
        result = WaveUtils.sampleToMillisecond(frames.length * 1152, frequence);
        return result;
    }

    public static long getAudioDurationTimeQuickly(File file) throws UnsupportedAudioFileException, IOException {
        long result = 0L;
        Bitstream stream = new Bitstream((InputStream)new FileInputStream(file));
        Header header = null;
        int skip = stream.header_pos();
        long framelength = 0L;
        boolean mpeg2 = false;
        float frequence = 0.0f;
        try {
            header = stream.readFrame();
            if (header.version_string().equals("MPEG-2 LSF")) {
                mpeg2 = true;
            }
            stream.unreadFrame();
            stream.close();
            int framesize = header.calculate_framesize();
            frequence = header.frequency();
            framelength = (file.length() - (long)skip) / (long)(framesize + 4);
        }
        catch (BitstreamException e) {
            e.printStackTrace();
        }
        try {
            stream.close();
        }
        catch (BitstreamException e1) {
            e1.printStackTrace();
        }
        if (framelength > 0L) {
            result = WaveUtils.sampleToMillisecond(framelength * 1152L, frequence);
        }
        if (mpeg2) {
            result /= 2L;
        }
        return result;
    }

    public static AudioInputStream toPCMAudioInputStream(InputStream input, long skip) throws UnsupportedAudioFileException, IOException {
        MpegAudioFileReader mpegAudioFileReader = new MpegAudioFileReader();
        log.trace((Object)mpegAudioFileReader);
        AudioInputStream in = mpegAudioFileReader.getAudioInputStream(input);
        AudioFormat baseFormat = in.getFormat();
        log.trace((Object)baseFormat);
        AudioFileFormat baseFileFormat = mpegAudioFileReader.getAudioFileFormat((InputStream)in);
        long skipbyte = 0L;
        double fps = 0.0;
        boolean bps = false;
        double frequency = 0.0;
        if (baseFileFormat instanceof MpegAudioFileFormat) {
            Map props = ((TAudioFileFormat)baseFileFormat).properties();
            Object[] obj = props.keySet().toArray();
            int i = 0;
            while (i < obj.length) {
                log.trace((Object)(obj[i] + "=" + props.get(obj[i]).toString()));
                ++i;
            }
        }
        AudioFormat decodedFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), false);
        MpegFormatConversionProvider provider = new MpegFormatConversionProvider();
        AudioInputStream audioInputStream = provider.getAudioInputStream(decodedFormat, in);
        long skipping = skip * (long)baseFormat.getChannels() * 2L;
        log.trace((Object)("pcm-skipping:" + skipping));
        int i = 0;
        while ((long)i < skipping) {
            int v = audioInputStream.read();
            log.trace((Object)("" + v));
            ++i;
        }
        return audioInputStream;
    }

    public static long quickFoundFrameAt(File file, int frameindex) throws FileNotFoundException {
        short[] frameSizes = MP3Utils.countFrameSizes(file);
        return MP3Utils.qucikSearchByte(file, frameindex, frameSizes);
    }

    public static long qucikSearchByte(File file, int frameindex, short[] frames) {
        long result = MP3Utils.findFirstFrameAt(file);
        int i = 0;
        while (i < frameindex) {
            if (i >= frames.length) {
                log.warn((Object)"index over");
                break;
            }
            result += (long)(frames[i] + 4);
            ++i;
        }
        return result;
    }

    public static int countFirstFrame(File file) {
        int result = 0;
        try {
            Bitstream stream = new Bitstream((InputStream)new FileInputStream(file));
            Header header = null;
            int skip = stream.header_pos();
            log.trace((Object)("skip:" + skip));
            float currentTime = 0.0f;
            long currentByte = 0L;
            boolean searchStart = true;
            double value = 1152000.0;
            try {
                header = stream.readFrame();
                stream.unreadFrame();
                stream.close();
                int framesize = header.calculate_framesize();
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                FileInputStream finput = new FileInputStream(file);
                finput.skip(skip);
                byte[] data = new byte[framesize + 4];
                int rb = finput.read(data);
                if (rb < data.length) {
                    log.fatal((Object)("wrong read byte:" + rb));
                }
                bout.write(data);
                finput.close();
                bout.close();
                ByteArrayInputStream binput = new ByteArrayInputStream(bout.toByteArray());
                result = MP3Utils.countSampleSize(binput);
            }
            catch (BitstreamException e2) {
                e2.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static int countFrame(File file) {
        Bitstream stream = null;
        try {
            stream = new Bitstream((InputStream)new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        Header header = null;
        int frame = 0;
        while (true) {
            try {
                header = stream.readFrame();
            }
            catch (BitstreamException e1) {
                e1.printStackTrace();
            }
            if (header == null) break;
            stream.closeFrame();
            ++frame;
        }
        return frame;
    }

    public static int countSampleSize(InputStream input) {
        int result = 0;
        AudioInputStream audioInputStream = null;
        MpegAudioFileReader mpegAudioFileReader = new MpegAudioFileReader();
        try {
            AudioInputStream in = mpegAudioFileReader.getAudioInputStream(input);
            AudioFormat baseFormat = in.getFormat();
            AudioFileFormat baseFileFormat = mpegAudioFileReader.getAudioFileFormat((InputStream)in);
            AudioFormat decodedFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), false);
            MpegFormatConversionProvider provider = new MpegFormatConversionProvider();
            audioInputStream = provider.getAudioInputStream(decodedFormat, in);
            AudioFormat format = audioInputStream.getFormat();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("javax.sound.sampled.SourceDataLine");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            DataLine.Info info = new DataLine.Info(clazz, format);
            long readed = 0L;
            try {
                SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
                line.open(format);
                line.start();
                int readbytes = 0;
                int buffer = 1024;
                byte[] bytedata = new byte[buffer];
                while (readbytes != -1) {
                    readbytes = audioInputStream.read(bytedata, 0, bytedata.length);
                    if (readbytes <= 0) continue;
                    readed += (long)readbytes;
                }
            }
            catch (LineUnavailableException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            log.trace((Object)("readed:" + readed + "frequency:" + format.getFrameRate() + "channel:" + format.getChannels() + "bit:" + format.getSampleSizeInBits()));
            return (int)(readed / (long)format.getChannels() / (long)(format.getSampleSizeInBits() / 8));
        }
        catch (UnsupportedAudioFileException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return result;
    }

    public static short[] countFrameSizes(File file) throws FileNotFoundException {
        ArrayShortList list = new ArrayShortList();
        Bitstream stream = new Bitstream((InputStream)new FileInputStream(file));
        int skipbyte = stream.header_pos();
        Header header = null;
        try {
            header = stream.readFrame();
            log.trace((Object)("framesize:" + header.calculate_framesize()));
            stream.unreadFrame();
        }
        catch (BitstreamException e2) {
            e2.printStackTrace();
        }
        long currentsamples = 0L;
        long frame = 0L;
        while (true) {
            try {
                header = stream.readFrame();
                if (header == null) break;
                list.add((short)header.calculate_framesize());
                stream.closeFrame();
                ++frame;
            }
            catch (BitstreamException e) {
                e.printStackTrace();
            }
        }
        log.trace((Object)("fames:" + frame));
        try {
            stream.close();
        }
        catch (BitstreamException e) {
            e.printStackTrace();
        }
        return list.toArray();
    }

    public static void copy(File file1, File file2, long startByte, long size) throws IOException {
        log.trace((Object)("start:" + startByte + " size:" + size));
        if (file1.length() <= startByte) {
            log.warn((Object)("skip all:" + file1.getAbsolutePath()));
        }
        try {
            int b;
            BufferedInputStream binput = new BufferedInputStream(new FileInputStream(file1));
            binput.skip(startByte);
            BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(file2));
            MP3FixOutputStream mp3out = new MP3FixOutputStream(bout);
            long read = 0L;
            int margin = 4000;
            int m = 0;
            while ((b = binput.read()) != -1) {
                mp3out.write(b);
                if (++read < size) continue;
                mp3out.setFixMode(true);
                if (++m > margin) break;
            }
            log.trace((Object)("write:" + read + ",after:" + mp3out.getAfterWrite()));
            binput.close();
            mp3out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isCleanMP3(File file) throws IOException {
        short[] framesizes = MP3Utils.countFrameSizes(file);
        return MP3Utils.isCleanMP3(file, framesizes);
    }

    public static boolean isCleanMP3(File file, short[] framesizes) throws IOException {
        boolean result = true;
        long header = MP3Utils.findFirstFrameAt(file);
        FileInputStream finput = new FileInputStream(file);
        finput.skip(header);
        int i = 0;
        while (i < framesizes.length) {
            int b1 = finput.read();
            int b2 = finput.read();
            if (b1 < 255 && b2 <= 224) {
                return false;
            }
            finput.skip(framesizes[i] + 4 - 2);
            ++i;
        }
        return result;
    }

    public static long findFirstFrameAt(File file) {
        long result = 0L;
        try {
            int b;
            Bitstream bt = new Bitstream((InputStream)new FileInputStream(file));
            int header = bt.header_pos();
            bt.close();
            FileInputStream finput = new FileInputStream(file);
            finput.skip(header);
            log.trace((Object)("header:" + header));
            boolean F = false;
            long readed = 0L;
            while ((b = finput.read()) != -1) {
                ++readed;
                if (F) {
                    if (b >= 224) {
                        result = readed - 2L + (long)header;
                        break;
                    }
                    F = false;
                    continue;
                }
                if (b != 255) continue;
                F = true;
            }
            finput.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (BitstreamException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static long[] searchByteByTime(File file, long startmillisecond, long endmillisecond) {
        long[] result = new long[2];
        try {
            Bitstream stream = new Bitstream((InputStream)new FileInputStream(file));
            Header header = null;
            int skip = stream.header_pos();
            log.trace((Object)("skip:" + skip));
            float currentTime = 0.0f;
            long currentByte = 0L;
            boolean searchStart = true;
            double value = 1152000.0;
            try {
                header = stream.readFrame();
                stream.unreadFrame();
            }
            catch (BitstreamException e2) {
                e2.printStackTrace();
            }
            long currentsamples = 0L;
            long startsamples = (long)header.frequency() * startmillisecond / 1000L;
            long endsamples = (long)header.frequency() * endmillisecond / 1000L;
            while (true) {
                try {
                    header = stream.readFrame();
                    if (header == null) break;
                    if (searchStart) {
                        if (currentsamples >= startsamples) {
                            result[0] = currentByte + (long)skip;
                            searchStart = false;
                        }
                    } else if (currentsamples > endsamples) {
                        result[1] = currentByte + (long)skip;
                        break;
                    }
                    currentsamples += 1152L;
                    currentByte += (long)(4 + header.calculate_framesize());
                    stream.closeFrame();
                }
                catch (BitstreamException e1) {
                    e1.printStackTrace();
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return result;
    }
}

