/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.jsyn.data.FloatSample;
import com.jsyn.util.AudioSampleLoader;
import com.jsyn.util.JavaTools;
import com.jsyn.util.soundfile.CustomSampleLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class SampleLoader {
    private static boolean javaSoundPreferred = false;
    private static final String JS_LOADER_NAME = "com.jsyn.util.JavaSoundSampleLoader";

    private static AudioSampleLoader createLoader() {
        AudioSampleLoader audioSampleLoader = null;
        try {
            audioSampleLoader = javaSoundPreferred ? (AudioSampleLoader)JavaTools.loadClass(JS_LOADER_NAME).newInstance() : new CustomSampleLoader();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return audioSampleLoader;
    }

    public static FloatSample loadFloatSample(File file) throws IOException {
        AudioSampleLoader audioSampleLoader = SampleLoader.createLoader();
        return audioSampleLoader.loadFloatSample(file);
    }

    public static FloatSample loadFloatSample(InputStream inputStream) throws IOException {
        AudioSampleLoader audioSampleLoader = SampleLoader.createLoader();
        return audioSampleLoader.loadFloatSample(inputStream);
    }

    public static FloatSample loadFloatSample(URL uRL) throws IOException {
        AudioSampleLoader audioSampleLoader = SampleLoader.createLoader();
        return audioSampleLoader.loadFloatSample(uRL);
    }

    public static boolean isJavaSoundPreferred() {
        return javaSoundPreferred;
    }

    public static void setJavaSoundPreferred(boolean bl) {
        javaSoundPreferred = bl;
    }

    public static void decodeBigI24ToF32(byte[] byArray, int n, int n2, float[] fArray, int n3) {
        int n4 = n + n2;
        int n5 = n;
        int n6 = n3;
        while (n5 < n4) {
            int n7 = byArray[n5++] & 0xFF;
            int n8 = byArray[n5++] & 0xFF;
            int n9 = byArray[n5++] & 0xFF;
            int n10 = n7 << 24 | n8 << 16 | n9 << 8;
            fArray[n6++] = (float)n10 * 4.656613E-10f;
        }
    }

    public static void decodeBigI16ToF32(byte[] byArray, int n, int n2, float[] fArray, int n3) {
        int n4 = n + n2;
        int n5 = n;
        int n6 = n3;
        while (n5 < n4) {
            int n7 = byArray[n5++] & 0xFF;
            int n8 = byArray[n5++] & 0xFF;
            short s = (short)(n7 << 8 | n8);
            fArray[n6++] = (float)s * 3.0517578E-5f;
        }
    }

    public static void decodeBigF32ToF32(byte[] byArray, int n, int n2, float[] fArray, int n3) {
        int n4 = n + n2;
        int n5 = n;
        int n6 = n3;
        while (n5 < n4) {
            int n7 = byArray[n5++];
            n7 = n7 << 8 | byArray[n5++] & 0xFF;
            n7 = n7 << 8 | byArray[n5++] & 0xFF;
            n7 = n7 << 8 | byArray[n5++] & 0xFF;
            fArray[n6++] = Float.intBitsToFloat(n7);
        }
    }

    public static void decodeBigI32ToF32(byte[] byArray, int n, int n2, float[] fArray, int n3) {
        int n4 = n + n2;
        int n5 = n;
        int n6 = n3;
        while (n5 < n4) {
            int n7 = byArray[n5++];
            n7 = n7 << 8 | byArray[n5++] & 0xFF;
            n7 = n7 << 8 | byArray[n5++] & 0xFF;
            n7 = n7 << 8 | byArray[n5++] & 0xFF;
            fArray[n6++] = (float)n7 * 4.656613E-10f;
        }
    }

    public static void decodeLittleF32ToF32(byte[] byArray, int n, int n2, float[] fArray, int n3) {
        int n4 = n + n2;
        int n5 = n;
        int n6 = n3;
        while (n5 < n4) {
            int n7 = byArray[n5++] & 0xFF;
            n7 += (byArray[n5++] & 0xFF) << 8;
            n7 += (byArray[n5++] & 0xFF) << 16;
            fArray[n6++] = Float.intBitsToFloat(n7 += byArray[n5++] << 24);
        }
    }

    public static void decodeLittleI32ToF32(byte[] byArray, int n, int n2, float[] fArray, int n3) {
        int n4 = n + n2;
        int n5 = n;
        int n6 = n3;
        while (n5 < n4) {
            int n7 = byArray[n5++] & 0xFF;
            n7 += (byArray[n5++] & 0xFF) << 8;
            n7 += (byArray[n5++] & 0xFF) << 16;
            fArray[n6++] = (float)(n7 += byArray[n5++] << 24) * 4.656613E-10f;
        }
    }

    public static void decodeLittleI24ToF32(byte[] byArray, int n, int n2, float[] fArray, int n3) {
        int n4 = n + n2;
        int n5 = n;
        int n6 = n3;
        while (n5 < n4) {
            int n7 = byArray[n5++] & 0xFF;
            int n8 = byArray[n5++] & 0xFF;
            int n9 = byArray[n5++] & 0xFF;
            int n10 = n9 << 24 | n8 << 16 | n7 << 8;
            fArray[n6++] = (float)n10 * 4.656613E-10f;
        }
    }

    public static void decodeLittleI16ToF32(byte[] byArray, int n, int n2, float[] fArray, int n3) {
        int n4 = n + n2;
        int n5 = n;
        int n6 = n3;
        while (n5 < n4) {
            int n7 = byArray[n5++] & 0xFF;
            int n8 = byArray[n5++] & 0xFF;
            short s = (short)(n8 << 8 | n7);
            float f = (float)s * 3.0517578E-5f;
            fArray[n6++] = f;
        }
    }
}

