/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitGenerator;
import com.softsynth.math.FourierMath;

public abstract class FFTBase
extends UnitGenerator {
    public UnitInputPort inputReal = new UnitInputPort("InputReal");
    public UnitInputPort inputImaginary;
    public UnitOutputPort outputReal;
    public UnitOutputPort outputImaginary;
    protected double[] realInput;
    protected double[] realOutput;
    protected double[] imaginaryInput;
    protected double[] imaginaryOutput;
    protected int cursor;

    protected FFTBase() {
        this.addPort(this.inputReal);
        this.inputImaginary = new UnitInputPort("InputImaginary");
        this.addPort(this.inputImaginary);
        this.outputReal = new UnitOutputPort("OutputReal");
        this.addPort(this.outputReal);
        this.outputImaginary = new UnitOutputPort("OutputImaginary");
        this.addPort(this.outputImaginary);
        this.setSize(512);
    }

    public void setSize(int n) {
        this.realInput = new double[n];
        this.realOutput = new double[n];
        this.imaginaryInput = new double[n];
        this.imaginaryOutput = new double[n];
        this.cursor = 0;
    }

    public int getSize() {
        return this.realInput.length;
    }

    @Override
    public void generate(int n, int n2) {
        double[] dArray = this.inputReal.getValues();
        double[] dArray2 = this.inputImaginary.getValues();
        double[] dArray3 = this.outputReal.getValues();
        double[] dArray4 = this.outputImaginary.getValues();
        for (int i = n; i < n2; ++i) {
            this.realInput[this.cursor] = dArray[i];
            this.imaginaryInput[this.cursor] = dArray2[i];
            dArray3[i] = this.realOutput[this.cursor];
            dArray4[i] = this.imaginaryOutput[this.cursor];
            ++this.cursor;
            if (this.cursor != this.realInput.length) continue;
            System.arraycopy(this.realInput, 0, this.realOutput, 0, this.realInput.length);
            System.arraycopy(this.imaginaryInput, 0, this.imaginaryOutput, 0, this.imaginaryInput.length);
            FourierMath.transform(this.getSign(), this.realOutput.length, this.realOutput, this.imaginaryOutput);
            this.cursor = 0;
        }
    }

    protected abstract int getSign();
}

